package org.apache.fulcrum.security.torque.om;

import java.io.Serializable;
import java.sql.Connection;
import java.util.Objects;

import org.apache.torque.TorqueException;
import org.apache.torque.map.TableMap;
import org.apache.torque.om.ComboKey;
import org.apache.torque.om.NumberKey;
import org.apache.torque.om.ObjectKey;
import org.apache.torque.om.SimpleKey;
import org.apache.torque.om.Persistent;
import org.apache.torque.util.TorqueConnection;
import org.apache.torque.util.Transaction;

/**
 * This class was autogenerated by Torque on:
 *
 * [Thu Nov 04 10:23:59 CET 2021]
 *
 * You should not use this class directly.  It should not even be
 * extended; all references should be to TorqueBasicUserGroup
 */
@SuppressWarnings("unused")
public abstract class BaseTorqueBasicUserGroup 
    implements Persistent, Serializable
{
    /** Serial version */
    private static final long serialVersionUID = 1636017839277L;



    /** Defines the userId field. */
    private Integer userId = null;

    /** Defines the groupId field. */
    private Integer groupId = null;

    /** Whether this object was modified after loading or after last save. */
    private boolean modified = true;

    /** 
     * Whether this object was loaded from the database or already saved 
     * (false) or whether it is not yet in the database(true).
     */
    private boolean isNew = true;

    /** Flag which indicates whether this object is currently saving. */
    private boolean saving = false;

    /** 
     * Flag which indicates whether this object is currently loaded
     * from the database. 
     */
    private boolean loading = false;

    /** 
     * Flag which indicates whether this object was deleted from the database.
     * Note that this flags does not always display the current database state,
     * there is no magical connection between this flag and the database.
     */
    private boolean deleted = false;

    /** Defines the aTorqueBasicUser field. */
    private TorqueBasicUser aTorqueBasicUser = null;

    /** Defines the aTorqueBasicGroup field. */
    private TorqueBasicGroup aTorqueBasicGroup = null;





    /**
     * Get the value of userId.
     *
     * @return the value of userId as Integer
     */
    public Integer getUserId() 
    {
        
        return userId;
    }

    /**
     * Set the value of userId.
     *
     * @param v new value of userId
     */
    public void setUserId(Integer v)
    {
        if (!Objects.equals(this.userId, v))
        {
            setModified(true);
        }

        this.userId = v;
        if (aTorqueBasicUser != null && !Objects.equals(aTorqueBasicUser.getEntityId(), v))
        {
            aTorqueBasicUser = null;
        }


    }
    
    /**
     * Get the value of groupId.
     *
     * @return the value of groupId as Integer
     */
    public Integer getGroupId() 
    {
        
        return groupId;
    }

    /**
     * Set the value of groupId.
     *
     * @param v new value of groupId
     */
    public void setGroupId(Integer v)
    {
        if (!Objects.equals(this.groupId, v))
        {
            setModified(true);
        }

        this.groupId = v;
        if (aTorqueBasicGroup != null && !Objects.equals(aTorqueBasicGroup.getEntityId(), v))
        {
            aTorqueBasicGroup = null;
        }


    }
    

    /**
     * Returns whether the object has ever been saved.  This will
     * be false, if the object was retrieved from storage or was created
     * and then saved.
     *
     * @return true, if the object has never been persisted.
     */
    public boolean isNew()
    {
        return isNew;
    }

    /**
     * Sets whether the object has ever been saved.
     *
     * @param isNew true if the object has never been saved, false otherwise.
     */
    public void setNew(boolean isNew)
    {
        this.isNew = isNew;
    }

    /**
     * Returns whether the object has been modified.
     *
     * @return True if the object has been modified.
     */
    public boolean isModified()
    {
        return modified;
    }

    /**
     * Sets whether the object has been modified.
     *
     * @param modified true if the object has been modified, false otherwise.
     */
    public void setModified(boolean modified)
    {
        this.modified = modified;
    }

    /**
     * Sets the modified state for the object to be false.
     */
    public void resetModified()
    {
        modified = false;
    }


    /**
     * Returns whether this object is currently saving.
     *
     * @return true if this object is currently saving, false otherwise.
     */
    public boolean isSaving()
    {
        return saving;
    }

    /**
     * Sets whether this object is currently saving.
     *
     * @param saving true if this object is currently saving, false otherwise.
     */
    public void setSaving(boolean saving)
    {
        this.saving = saving;
    }


    /**
     * Returns whether this object is currently being loaded from the database.
     *
     * @return true if this object is currently loading, false otherwise.
     */
    public boolean isLoading()
    {
        return loading;
    }

    /**
     * Sets whether this object is currently being loaded from the database.
     *
     * @param loading true if this object is currently loading, false otherwise.
     */
    public void setLoading(boolean loading)
    {
        this.loading = loading;
    }


    /**
     * Returns whether this object was deleted from the database.
     * Note that this getter does not automatically reflect database state,
     * it will be set to true by Torque if doDelete() was called with this 
     * object. Bulk deletes and deletes via primary key do not change
     * this flag. Also, if doDelete() was called on an object which does
     * not exist in the database, the deleted flag is set to true even if
     * it was not deleted.
     *
     * @return true if this object was deleted, false otherwise.
     */
    public boolean isDeleted()
    {
        return deleted;
    }

    /**
     * Sets whether this object was deleted from the database.
     *
     * @param deleted true if this object was deleted, false otherwise.
     */
    public void setDeleted(boolean deleted)
    {
        this.deleted = deleted;
    }


    /**
     * Returns the associated TorqueBasicUser object.
     * If it was not retrieved before, the object is retrieved from
     * the database
     *
     * @return the associated TorqueBasicUser object
     * @throws TorqueException when reading from the database fails.
     */
    public TorqueBasicUser getTorqueBasicUser()
        throws TorqueException
    {
        if (aTorqueBasicUser == null && !Objects.equals(this.userId, null))
        {
            aTorqueBasicUser = org.apache.fulcrum.security.torque.om.TorqueBasicUserPeer.retrieveByPK(SimpleKey.keyFor(this.userId));
        }
        return aTorqueBasicUser;
    }

    /**
     * Return the associated TorqueBasicUser object
     * If it was not retrieved before, the object is retrieved from
     * the database using the passed connection
     *
     * @param connection the connection used to retrieve the associated object
     *        from the database, if it was not retrieved before
     * @return the associated TorqueBasicUser object
     * @throws TorqueException If a problem occurs with the get[TorqueBasicUser] method.
     */
    public TorqueBasicUser getTorqueBasicUser(Connection connection)
        throws TorqueException
    {
        if (aTorqueBasicUser == null && !Objects.equals(this.userId, null))
        {
            aTorqueBasicUser = org.apache.fulcrum.security.torque.om.TorqueBasicUserPeer.retrieveByPK(SimpleKey.keyFor(this.userId), connection);
        }
        return aTorqueBasicUser;
    }


    /**
     * Declares an association between this object and a TorqueBasicUser object
     *
     * @param v TorqueBasicUser
     */
    public void setTorqueBasicUser(TorqueBasicUser v)
    {
        if (v == null)
        {
            setUserId(null);
        }
        else
        {
            setUserId(v.getEntityId());
        }
        aTorqueBasicUser = v;
    }
    /**
     * Provides convenient way to set a relationship based on a
     * ObjectKey, for example
     * <code>bar.setFooKey(foo.getPrimaryKey())</code>
     *
     * @param key the key to set
     * @throws TorqueException if associated objects are not found
     */
    public void setTorqueBasicUserKey(ObjectKey<?> key) throws TorqueException
    {
       
        setUserId(Integer.valueOf(((NumberKey) key).intValue()));
     }

    /**
     * Returns the associated TorqueBasicGroup object.
     * If it was not retrieved before, the object is retrieved from
     * the database
     *
     * @return the associated TorqueBasicGroup object
     * @throws TorqueException when reading from the database fails.
     */
    public TorqueBasicGroup getTorqueBasicGroup()
        throws TorqueException
    {
        if (aTorqueBasicGroup == null && !Objects.equals(this.groupId, null))
        {
            aTorqueBasicGroup = org.apache.fulcrum.security.torque.om.TorqueBasicGroupPeer.retrieveByPK(SimpleKey.keyFor(this.groupId));
        }
        return aTorqueBasicGroup;
    }

    /**
     * Return the associated TorqueBasicGroup object
     * If it was not retrieved before, the object is retrieved from
     * the database using the passed connection
     *
     * @param connection the connection used to retrieve the associated object
     *        from the database, if it was not retrieved before
     * @return the associated TorqueBasicGroup object
     * @throws TorqueException If a problem occurs with the get[TorqueBasicGroup] method.
     */
    public TorqueBasicGroup getTorqueBasicGroup(Connection connection)
        throws TorqueException
    {
        if (aTorqueBasicGroup == null && !Objects.equals(this.groupId, null))
        {
            aTorqueBasicGroup = org.apache.fulcrum.security.torque.om.TorqueBasicGroupPeer.retrieveByPK(SimpleKey.keyFor(this.groupId), connection);
        }
        return aTorqueBasicGroup;
    }


    /**
     * Declares an association between this object and a TorqueBasicGroup object
     *
     * @param v TorqueBasicGroup
     */
    public void setTorqueBasicGroup(TorqueBasicGroup v)
    {
        if (v == null)
        {
            setGroupId(null);
        }
        else
        {
            setGroupId(v.getEntityId());
        }
        aTorqueBasicGroup = v;
    }
    /**
     * Provides convenient way to set a relationship based on a
     * ObjectKey, for example
     * <code>bar.setFooKey(foo.getPrimaryKey())</code>
     *
     * @param key the key to set
     * @throws TorqueException if associated objects are not found
     */
    public void setTorqueBasicGroupKey(ObjectKey<?> key) throws TorqueException
    {
       
        setGroupId(Integer.valueOf(((NumberKey) key).intValue()));
     }







    /**
     * Stores an object in the database.  If the object is new,
     * it is inserted; otherwise an update is performed.
     *
     * @throws TorqueException if an error occurs during saving.
     */
    public void save() throws TorqueException
    {
        save(TorqueBasicUserGroupPeer.DATABASE_NAME);
    }

    /**
     * Stores an object in the database.  If the object is new,
     * it is inserted; otherwise an update is performed.
     *
     * @param dbName the name of the database to which the object
     *        should be saved.
     *
     * @throws TorqueException if an error occurs during saving.
     */
    public void save(String dbName) 
            throws TorqueException
    {
        try (TorqueConnection con = Transaction.begin(dbName))
        {
            save(con);
            Transaction.commit(con);
        }
    }

    /**
     * Stores an object in the database.  If the object is new,
     * it is inserted; otherwise an update is performed.  This method
     * is meant to be used as part of a transaction, otherwise use
     * the save() method and the connection details will be handled
     * internally.
     *
     * @param con the connection to use for saving the object, not null.
     *
     * @throws TorqueException if an error occurs during saving.
     */
    public void save(Connection con) 
            throws TorqueException
    {
        if (isSaving())
        {
            return;
        }
        try
        {
            setSaving(true);
            // If this object has been modified, then save it to the database.
            if (isModified())
            {
                if (isNew())
                {
                    TorqueBasicUserGroupPeer.doInsert((TorqueBasicUserGroup) this, con);
                    setNew(false);
                }
                else
                {
                    TorqueBasicUserGroupPeer.doUpdate((TorqueBasicUserGroup) this, con);
                }
            }

        }
        finally
        {
            setSaving(false);
        }
    }





    private final SimpleKey<?>[] pks = new SimpleKey[2];
    private final ComboKey comboPK = new ComboKey(pks);

    /**
     * Set the PrimaryKey with an ObjectKey
     *
     * @param key the primary key to set, not null.
     */
    public void setPrimaryKey(ObjectKey<?> key) throws TorqueException
    {
        SimpleKey<?>[] keys = (SimpleKey[]) key.getValue();
        setUserId(((NumberKey) keys[0]).intValue());
        setGroupId(((NumberKey) keys[1]).intValue());
    }

    /**
     * Set the PrimaryKey using SimpleKeys.
     *
     * @param userId a part of the primary key.
     * @param groupId a part of the primary key.
     */
    public void setPrimaryKey(Integer userId, Integer groupId)
        
    {
        setUserId(userId);
        setGroupId(groupId);
    }

    /**
     * Set the PrimaryKey using a String.
     * @param key the primary key to set.
     */
    public void setPrimaryKey(String key) throws TorqueException
    {
        setPrimaryKey(new ComboKey(key));
    }

    /**
     * returns an id that differentiates this object from others
     * of its class.
     */
    public ObjectKey<?> getPrimaryKey()
    {
        SimpleKey<?>[] pks = new SimpleKey[2];
        pks[0] = SimpleKey.keyFor(getUserId());
        pks[1] = SimpleKey.keyFor(getGroupId());
        return new ComboKey(pks);
    }


    /**
     * Returns an id that differentiates the referenced TorqueBasicUser object
     * from all other TorqueBasicUser objects.
     *
     * @return an ObjectKey.
     */
    public ObjectKey<?> getForeignKeyForTorqueBasicUser()
    {
        return SimpleKey.keyFor(getUserId());
    }
    /**
     * Returns an id that differentiates the referenced TorqueBasicGroup object
     * from all other TorqueBasicGroup objects.
     *
     * @return an ObjectKey.
     */
    public ObjectKey<?> getForeignKeyForTorqueBasicGroup()
    {
        return SimpleKey.keyFor(getGroupId());
    }

    /**
     * Makes a copy of this object.
     * It creates a new object filling in the simple attributes.
     * It then fills all the association collections and sets the
     * related objects to isNew=true.
     * @throws TorqueException if retrieval of the associated objects fails  
     */
    public TorqueBasicUserGroup copy() throws TorqueException
    {
        return copy(true);
    }

    /**
     * Makes a copy of this object using a connection.
     * It creates a new object filling in the simple attributes.
     * It then fills all the association collections and sets the
     * related objects to isNew=true.
     *
     * @param con the database connection to read associated objects.
     * @throws TorqueException if retrieval of the associated objects fails     
     */
    public TorqueBasicUserGroup copy(Connection con) throws TorqueException
    {
        return copy(true, con);
    }

    /**
     * Makes a copy of this object.
     * It creates a new object filling in the simple attributes.
     * If the parameter deepcopy is true, it then fills all the
     * association collections and sets the related objects to
     * isNew=true.
     *
     * @param deepcopy whether to copy the associated objects.
     * @throws TorqueException if retrieval of the associated objects fails
     */
    public TorqueBasicUserGroup copy(boolean deepcopy) throws TorqueException
    {
        TorqueBasicUserGroup torqueBasicUserGroup = new TorqueBasicUserGroup();

        return copyInto(torqueBasicUserGroup, deepcopy);
    }

    /**
     * Makes a copy of this object using connection.
     * It creates a new object filling in the simple attributes.
     * If the parameter deepcopy is true, it then fills all the
     * association collections and sets the related objects to
     * isNew=true.
     *
     * @param deepcopy whether to copy the associated objects.
     * @param con the database connection to read associated objects.
     * @throws TorqueException if retrieval of the associated objects fails
     */
    public TorqueBasicUserGroup copy(boolean deepcopy, Connection con) throws TorqueException
    {
        TorqueBasicUserGroup torqueBasicUserGroup = new TorqueBasicUserGroup();

        return copyInto(torqueBasicUserGroup, deepcopy, con);
    }
  
    /**
     * Fills the copyObj with the contents of this object.
     * The associated objects are also copied and treated as new objects.
     *
     * @param copyObj the object to fill.
     * @throws TorqueException if retrieval of the associated objects fails
     */
    public TorqueBasicUserGroup copyInto(TorqueBasicUserGroup copyObj) throws TorqueException
    {
        return copyInto(copyObj, true);
    }

    /**
     * Fills the copyObj with the contents of this object using connection.
     * The associated objects are also copied and treated as new objects.
     *
     * @param copyObj the object to fill.
     * @param con the database connection to read associated objects.
     * @throws TorqueException if retrieval of the associated objects fails
     */
    public TorqueBasicUserGroup copyInto(TorqueBasicUserGroup copyObj, Connection con) throws TorqueException
    {
        return copyInto(copyObj, true, con);
    }
  
    /**
     * Fills the copyObj with the contents of this object.
     * If deepcopy is true, The associated objects are also copied
     * and treated as new objects.
     *
     * @param copyObj the object to fill.
     * @param deepcopy whether the associated objects should be copied.
     * @throws TorqueException if retrieval of the associated objects fails
     */
    protected TorqueBasicUserGroup copyInto(TorqueBasicUserGroup copyObj, boolean deepcopy) throws TorqueException
    {
        copyObj.setUserId((Integer) null);
        copyObj.setGroupId((Integer) null);

        if (deepcopy)
        {
        }
        return copyObj;
    }
        
    
    /**
     * Fills the copyObj with the contents of this object using connection.
     * If deepcopy is true, The associated objects are also copied
     * and treated as new objects.
     *
     * @param copyObj the object to fill.
     * @param deepcopy whether the associated objects should be copied.
     * @param con the database connection to read associated objects.
     * @throws TorqueException if retrieval of the associated objects fails
     */
    public TorqueBasicUserGroup copyInto(TorqueBasicUserGroup copyObj, boolean deepcopy, Connection con) throws TorqueException
    {
        copyObj.setUserId((Integer) null);
        copyObj.setGroupId((Integer) null);

        if (deepcopy)
        {
        }
        return copyObj;
    }

    /** The Peer class */
    private static final org.apache.fulcrum.security.torque.om.TorqueBasicUserGroupPeer peer
            = new org.apache.fulcrum.security.torque.om.TorqueBasicUserGroupPeer();

    /**
     * returns a peer instance associated with this om.  Since Peer classes
     * are not to have any instance attributes, this method returns the
     * same instance for all member of this class. The method could therefore
     * be static, but this would prevent one from overriding the behavior.
     */
    public org.apache.fulcrum.security.torque.om.TorqueBasicUserGroupPeer getPeer()
    {
        return peer;
    }

    /**
     * Retrieves the TableMap object related to this Table data without
     * compiler warnings of using getPeer().getTableMap().
     *
     * @return The associated TableMap object.
     * @throws TorqueException if associated objects are not found
     */
    public TableMap getTableMap() throws TorqueException
    {
        return org.apache.fulcrum.security.torque.om.TorqueBasicUserGroupPeer.getTableMap();
    }



    public String toString()
    {
        StringBuffer str = new StringBuffer();
        str.append("TorqueBasicUserGroup:\n");
        str.append("userId = ")
           .append(getUserId())
           .append("\n");
        str.append("groupId = ")
           .append(getGroupId())
           .append("\n");
        return(str.toString());
    }

    /**
     * Compares the primary key of this instance with the key of another.
     *
     * @param toCompare The object to compare to.
     * @return Whether the primary keys are equal and the object have the
     *         same class.
     */
    public boolean equals(Object toCompare)
    {
        if (toCompare == null)
        {
            return false;
        }
        if (this == toCompare)
        {
            return true;
        }
        if (!getClass().equals(toCompare.getClass()))
        {
            return false;
        }
        TorqueBasicUserGroup other = (TorqueBasicUserGroup) toCompare;
        if (getPrimaryKey() == null || other.getPrimaryKey() == null)
        {
            return false;
        }
        return getPrimaryKey().equals(other.getPrimaryKey());
    }

    /**
     * If the primary key is not <code>null</code>, return the hashcode of the
     * primary key.  Otherwise calls <code>Object.hashCode()</code>.
     *
     * @return an <code>int</code> value
     */
    public int hashCode()
    {
        ObjectKey<?> ok = getPrimaryKey();
        if (ok == null)
        {
            return super.hashCode();
        }

        return ok.hashCode();
    }



    /**
     * Compares the content of this object to another object
     *
     * @param toCompare The object to compare to.
     * @return true if all of the columns in the other object have 
     *         the same value as the objects in this class.
     */
    public boolean valueEquals(TorqueBasicUserGroup toCompare)
    {
        if (toCompare == null)
        {
            return false;
        }
        if (this == toCompare)
        {
            return true;
        }
        if (!Objects.equals(this.userId, toCompare.getUserId()))
        {
            return false;
        }
        if (!Objects.equals(this.groupId, toCompare.getGroupId()))
        {
            return false;
        }
        return true;
    }



}
