/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fulcrum.security.torque.om;

import java.io.Serializable;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.apache.fulcrum.security.torque.om.TurbineRole;
import org.apache.fulcrum.security.torque.om.TurbineRolePeer;
import org.apache.fulcrum.security.torque.om.TurbineRolePermission;
import org.apache.fulcrum.security.torque.om.TurbineRolePermissionPeer;
import org.apache.fulcrum.security.torque.om.TurbineUserGroupRole;
import org.apache.fulcrum.security.torque.om.TurbineUserGroupRolePeer;
import org.apache.fulcrum.security.torque.turbine.DefaultAbstractTurbineRole;
import org.apache.torque.TorqueException;
import org.apache.torque.criteria.Criteria;
import org.apache.torque.map.TableMap;
import org.apache.torque.om.NumberKey;
import org.apache.torque.om.ObjectKey;
import org.apache.torque.om.Persistent;
import org.apache.torque.om.SimpleKey;
import org.apache.torque.util.TorqueConnection;
import org.apache.torque.util.Transaction;

public abstract class BaseTurbineRole
extends DefaultAbstractTurbineRole
implements Persistent,
Serializable {
    private static final long serialVersionUID = 1636017840357L;
    private Integer entityId = null;
    private String entityName = null;
    private boolean modified = true;
    private boolean isNew = true;
    private boolean saving = false;
    private boolean loading = false;
    private boolean deleted = false;
    protected List<TurbineRolePermission> collTurbineRolePermissions = null;
    protected List<TurbineUserGroupRole> collTurbineUserGroupRoles = null;
    private Criteria lastTurbineRolePermissionCriteria = null;
    private Criteria lastTurbineUserGroupRoleCriteria = null;
    private static final TurbineRolePeer peer = new TurbineRolePeer();

    @Override
    public Integer getEntityId() {
        return this.entityId;
    }

    @Override
    public void setEntityId(Integer v) {
        if (!Objects.equals(this.entityId, v)) {
            this.setModified(true);
        }
        this.entityId = v;
        if (this.collTurbineRolePermissions != null) {
            for (TurbineRolePermission turbineRolePermission : this.collTurbineRolePermissions) {
                turbineRolePermission.setRoleId(v);
            }
        }
        if (this.collTurbineUserGroupRoles != null) {
            for (TurbineUserGroupRole turbineUserGroupRole : this.collTurbineUserGroupRoles) {
                turbineUserGroupRole.setRoleId(v);
            }
        }
    }

    @Override
    public String getEntityName() {
        return this.entityName;
    }

    @Override
    public void setEntityName(String v) {
        if (!Objects.equals(this.entityName, v)) {
            this.setModified(true);
        }
        this.entityName = v;
    }

    public boolean isNew() {
        return this.isNew;
    }

    public void setNew(boolean isNew) {
        this.isNew = isNew;
    }

    public boolean isModified() {
        return this.modified;
    }

    public void setModified(boolean modified) {
        this.modified = modified;
    }

    public void resetModified() {
        this.modified = false;
    }

    public boolean isSaving() {
        return this.saving;
    }

    public void setSaving(boolean saving) {
        this.saving = saving;
    }

    public boolean isLoading() {
        return this.loading;
    }

    public void setLoading(boolean loading) {
        this.loading = loading;
    }

    public boolean isDeleted() {
        return this.deleted;
    }

    public void setDeleted(boolean deleted) {
        this.deleted = deleted;
    }

    public List<TurbineRolePermission> initTurbineRolePermissions() {
        if (this.collTurbineRolePermissions == null) {
            this.collTurbineRolePermissions = new ArrayList<TurbineRolePermission>();
        }
        return this.collTurbineRolePermissions;
    }

    public boolean isTurbineRolePermissionsInitialized() {
        return this.collTurbineRolePermissions != null;
    }

    public void addTurbineRolePermission(TurbineRolePermission toAdd) throws TorqueException {
        toAdd.setTurbineRole((TurbineRole)this);
        this.getTurbineRolePermissions().add(toAdd);
    }

    public void addTurbineRolePermission(TurbineRolePermission l, Connection con) throws TorqueException {
        this.getTurbineRolePermissions(con).add(l);
        l.setTurbineRole((TurbineRole)this);
    }

    public void resetTurbineRolePermission() {
        this.collTurbineRolePermissions = null;
    }

    public List<TurbineRolePermission> getTurbineRolePermissions() throws TorqueException {
        if (this.collTurbineRolePermissions == null) {
            this.collTurbineRolePermissions = this.getTurbineRolePermissions(new Criteria());
            for (TurbineRolePermission turbineRolePermission : this.collTurbineRolePermissions) {
                turbineRolePermission.setTurbineRole((TurbineRole)this);
            }
        }
        return this.collTurbineRolePermissions;
    }

    public List<TurbineRolePermission> getTurbineRolePermissions(Criteria criteria) throws TorqueException {
        if (this.collTurbineRolePermissions == null) {
            if (this.isNew()) {
                this.initTurbineRolePermissions();
            } else {
                criteria.and((Object)TurbineRolePermissionPeer.ROLE_ID, (Object)this.getEntityId());
                this.collTurbineRolePermissions = TurbineRolePermissionPeer.doSelect(criteria);
                for (TurbineRolePermission turbineRolePermission : this.collTurbineRolePermissions) {
                    turbineRolePermission.setTurbineRole((TurbineRole)this);
                }
            }
        } else if (!this.isNew()) {
            criteria.and((Object)TurbineRolePermissionPeer.ROLE_ID, (Object)this.getEntityId());
            if (this.lastTurbineRolePermissionCriteria == null || !this.lastTurbineRolePermissionCriteria.equals((Object)criteria)) {
                this.collTurbineRolePermissions = TurbineRolePermissionPeer.doSelect(criteria);
                for (TurbineRolePermission turbineRolePermission : this.collTurbineRolePermissions) {
                    turbineRolePermission.setTurbineRole((TurbineRole)this);
                }
            }
        }
        this.lastTurbineRolePermissionCriteria = criteria;
        return this.collTurbineRolePermissions;
    }

    public List<TurbineRolePermission> getTurbineRolePermissions(Connection con) throws TorqueException {
        if (this.collTurbineRolePermissions == null) {
            this.collTurbineRolePermissions = this.getTurbineRolePermissions(new Criteria(), con);
            for (TurbineRolePermission turbineRolePermission : this.collTurbineRolePermissions) {
                turbineRolePermission.setTurbineRole((TurbineRole)this);
            }
        }
        return this.collTurbineRolePermissions;
    }

    public List<TurbineRolePermission> getTurbineRolePermissions(Criteria criteria, Connection con) throws TorqueException {
        if (this.collTurbineRolePermissions == null) {
            if (this.isNew()) {
                this.initTurbineRolePermissions();
            } else {
                criteria.and((Object)TurbineRolePermissionPeer.ROLE_ID, (Object)this.getEntityId());
                this.collTurbineRolePermissions = TurbineRolePermissionPeer.doSelect(criteria, con);
                for (TurbineRolePermission turbineRolePermission : this.collTurbineRolePermissions) {
                    turbineRolePermission.setTurbineRole((TurbineRole)this);
                }
            }
        } else if (!this.isNew()) {
            criteria.and((Object)TurbineRolePermissionPeer.ROLE_ID, (Object)this.getEntityId());
            if (this.lastTurbineRolePermissionCriteria == null || !this.lastTurbineRolePermissionCriteria.equals((Object)criteria)) {
                this.collTurbineRolePermissions = TurbineRolePermissionPeer.doSelect(criteria, con);
                for (TurbineRolePermission turbineRolePermission : this.collTurbineRolePermissions) {
                    turbineRolePermission.setTurbineRole((TurbineRole)this);
                }
            }
        }
        this.lastTurbineRolePermissionCriteria = criteria;
        return this.collTurbineRolePermissions;
    }

    public List<TurbineUserGroupRole> initTurbineUserGroupRoles() {
        if (this.collTurbineUserGroupRoles == null) {
            this.collTurbineUserGroupRoles = new ArrayList<TurbineUserGroupRole>();
        }
        return this.collTurbineUserGroupRoles;
    }

    public boolean isTurbineUserGroupRolesInitialized() {
        return this.collTurbineUserGroupRoles != null;
    }

    public void addTurbineUserGroupRole(TurbineUserGroupRole toAdd) throws TorqueException {
        toAdd.setTurbineRole((TurbineRole)this);
        this.getTurbineUserGroupRoles().add(toAdd);
    }

    public void addTurbineUserGroupRole(TurbineUserGroupRole l, Connection con) throws TorqueException {
        this.getTurbineUserGroupRoles(con).add(l);
        l.setTurbineRole((TurbineRole)this);
    }

    public void resetTurbineUserGroupRole() {
        this.collTurbineUserGroupRoles = null;
    }

    public List<TurbineUserGroupRole> getTurbineUserGroupRoles() throws TorqueException {
        if (this.collTurbineUserGroupRoles == null) {
            this.collTurbineUserGroupRoles = this.getTurbineUserGroupRoles(new Criteria());
            for (TurbineUserGroupRole turbineUserGroupRole : this.collTurbineUserGroupRoles) {
                turbineUserGroupRole.setTurbineRole((TurbineRole)this);
            }
        }
        return this.collTurbineUserGroupRoles;
    }

    public List<TurbineUserGroupRole> getTurbineUserGroupRoles(Criteria criteria) throws TorqueException {
        if (this.collTurbineUserGroupRoles == null) {
            if (this.isNew()) {
                this.initTurbineUserGroupRoles();
            } else {
                criteria.and((Object)TurbineUserGroupRolePeer.ROLE_ID, (Object)this.getEntityId());
                this.collTurbineUserGroupRoles = TurbineUserGroupRolePeer.doSelect(criteria);
                for (TurbineUserGroupRole turbineUserGroupRole : this.collTurbineUserGroupRoles) {
                    turbineUserGroupRole.setTurbineRole((TurbineRole)this);
                }
            }
        } else if (!this.isNew()) {
            criteria.and((Object)TurbineUserGroupRolePeer.ROLE_ID, (Object)this.getEntityId());
            if (this.lastTurbineUserGroupRoleCriteria == null || !this.lastTurbineUserGroupRoleCriteria.equals((Object)criteria)) {
                this.collTurbineUserGroupRoles = TurbineUserGroupRolePeer.doSelect(criteria);
                for (TurbineUserGroupRole turbineUserGroupRole : this.collTurbineUserGroupRoles) {
                    turbineUserGroupRole.setTurbineRole((TurbineRole)this);
                }
            }
        }
        this.lastTurbineUserGroupRoleCriteria = criteria;
        return this.collTurbineUserGroupRoles;
    }

    public List<TurbineUserGroupRole> getTurbineUserGroupRoles(Connection con) throws TorqueException {
        if (this.collTurbineUserGroupRoles == null) {
            this.collTurbineUserGroupRoles = this.getTurbineUserGroupRoles(new Criteria(), con);
            for (TurbineUserGroupRole turbineUserGroupRole : this.collTurbineUserGroupRoles) {
                turbineUserGroupRole.setTurbineRole((TurbineRole)this);
            }
        }
        return this.collTurbineUserGroupRoles;
    }

    public List<TurbineUserGroupRole> getTurbineUserGroupRoles(Criteria criteria, Connection con) throws TorqueException {
        if (this.collTurbineUserGroupRoles == null) {
            if (this.isNew()) {
                this.initTurbineUserGroupRoles();
            } else {
                criteria.and((Object)TurbineUserGroupRolePeer.ROLE_ID, (Object)this.getEntityId());
                this.collTurbineUserGroupRoles = TurbineUserGroupRolePeer.doSelect(criteria, con);
                for (TurbineUserGroupRole turbineUserGroupRole : this.collTurbineUserGroupRoles) {
                    turbineUserGroupRole.setTurbineRole((TurbineRole)this);
                }
            }
        } else if (!this.isNew()) {
            criteria.and((Object)TurbineUserGroupRolePeer.ROLE_ID, (Object)this.getEntityId());
            if (this.lastTurbineUserGroupRoleCriteria == null || !this.lastTurbineUserGroupRoleCriteria.equals((Object)criteria)) {
                this.collTurbineUserGroupRoles = TurbineUserGroupRolePeer.doSelect(criteria, con);
                for (TurbineUserGroupRole turbineUserGroupRole : this.collTurbineUserGroupRoles) {
                    turbineUserGroupRole.setTurbineRole((TurbineRole)this);
                }
            }
        }
        this.lastTurbineUserGroupRoleCriteria = criteria;
        return this.collTurbineUserGroupRoles;
    }

    protected List<TurbineRolePermission> getTurbineRolePermissionsJoinTurbinePermission(Criteria criteria) throws TorqueException {
        try (TorqueConnection connection = Transaction.begin((String)criteria.getDbName());){
            List<TurbineRolePermission> result = this.getTurbineRolePermissionsJoinTurbinePermission(criteria, (Connection)connection);
            Transaction.commit((Connection)connection);
            List<TurbineRolePermission> list = result;
            return list;
        }
    }

    protected List<TurbineRolePermission> getTurbineRolePermissionsJoinTurbinePermission(Criteria criteria, Connection connection) throws TorqueException {
        if (this.collTurbineRolePermissions == null) {
            if (this.isNew()) {
                this.initTurbineRolePermissions();
            } else {
                criteria.and((Object)TurbineRolePermissionPeer.ROLE_ID, (Object)this.getEntityId());
                this.collTurbineRolePermissions = TurbineRolePermissionPeer.doSelectJoinTurbinePermission(criteria, connection);
                for (TurbineRolePermission turbineRolePermission : this.collTurbineRolePermissions) {
                    turbineRolePermission.setTurbineRole((TurbineRole)this);
                }
            }
        } else {
            criteria.and((Object)TurbineRolePermissionPeer.ROLE_ID, (Object)this.getEntityId());
            if (this.lastTurbineRolePermissionCriteria == null || !this.lastTurbineRolePermissionCriteria.equals((Object)criteria)) {
                this.collTurbineRolePermissions = TurbineRolePermissionPeer.doSelectJoinTurbinePermission(criteria, connection);
                for (TurbineRolePermission turbineRolePermission : this.collTurbineRolePermissions) {
                    turbineRolePermission.setTurbineRole((TurbineRole)this);
                }
            }
        }
        this.lastTurbineRolePermissionCriteria = criteria;
        return this.collTurbineRolePermissions;
    }

    protected List<TurbineUserGroupRole> getTurbineUserGroupRolesJoinTurbineUser(Criteria criteria) throws TorqueException {
        try (TorqueConnection connection = Transaction.begin((String)criteria.getDbName());){
            List<TurbineUserGroupRole> result = this.getTurbineUserGroupRolesJoinTurbineUser(criteria, (Connection)connection);
            Transaction.commit((Connection)connection);
            List<TurbineUserGroupRole> list = result;
            return list;
        }
    }

    protected List<TurbineUserGroupRole> getTurbineUserGroupRolesJoinTurbineUser(Criteria criteria, Connection connection) throws TorqueException {
        if (this.collTurbineUserGroupRoles == null) {
            if (this.isNew()) {
                this.initTurbineUserGroupRoles();
            } else {
                criteria.and((Object)TurbineUserGroupRolePeer.ROLE_ID, (Object)this.getEntityId());
                this.collTurbineUserGroupRoles = TurbineUserGroupRolePeer.doSelectJoinTurbineUser(criteria, connection);
                for (TurbineUserGroupRole turbineUserGroupRole : this.collTurbineUserGroupRoles) {
                    turbineUserGroupRole.setTurbineRole((TurbineRole)this);
                }
            }
        } else {
            criteria.and((Object)TurbineUserGroupRolePeer.ROLE_ID, (Object)this.getEntityId());
            if (this.lastTurbineUserGroupRoleCriteria == null || !this.lastTurbineUserGroupRoleCriteria.equals((Object)criteria)) {
                this.collTurbineUserGroupRoles = TurbineUserGroupRolePeer.doSelectJoinTurbineUser(criteria, connection);
                for (TurbineUserGroupRole turbineUserGroupRole : this.collTurbineUserGroupRoles) {
                    turbineUserGroupRole.setTurbineRole((TurbineRole)this);
                }
            }
        }
        this.lastTurbineUserGroupRoleCriteria = criteria;
        return this.collTurbineUserGroupRoles;
    }

    protected List<TurbineUserGroupRole> getTurbineUserGroupRolesJoinTurbineGroup(Criteria criteria) throws TorqueException {
        try (TorqueConnection connection = Transaction.begin((String)criteria.getDbName());){
            List<TurbineUserGroupRole> result = this.getTurbineUserGroupRolesJoinTurbineGroup(criteria, (Connection)connection);
            Transaction.commit((Connection)connection);
            List<TurbineUserGroupRole> list = result;
            return list;
        }
    }

    protected List<TurbineUserGroupRole> getTurbineUserGroupRolesJoinTurbineGroup(Criteria criteria, Connection connection) throws TorqueException {
        if (this.collTurbineUserGroupRoles == null) {
            if (this.isNew()) {
                this.initTurbineUserGroupRoles();
            } else {
                criteria.and((Object)TurbineUserGroupRolePeer.ROLE_ID, (Object)this.getEntityId());
                this.collTurbineUserGroupRoles = TurbineUserGroupRolePeer.doSelectJoinTurbineGroup(criteria, connection);
                for (TurbineUserGroupRole turbineUserGroupRole : this.collTurbineUserGroupRoles) {
                    turbineUserGroupRole.setTurbineRole((TurbineRole)this);
                }
            }
        } else {
            criteria.and((Object)TurbineUserGroupRolePeer.ROLE_ID, (Object)this.getEntityId());
            if (this.lastTurbineUserGroupRoleCriteria == null || !this.lastTurbineUserGroupRoleCriteria.equals((Object)criteria)) {
                this.collTurbineUserGroupRoles = TurbineUserGroupRolePeer.doSelectJoinTurbineGroup(criteria, connection);
                for (TurbineUserGroupRole turbineUserGroupRole : this.collTurbineUserGroupRoles) {
                    turbineUserGroupRole.setTurbineRole((TurbineRole)this);
                }
            }
        }
        this.lastTurbineUserGroupRoleCriteria = criteria;
        return this.collTurbineUserGroupRoles;
    }

    public void save() throws TorqueException {
        this.save(TurbineRolePeer.DATABASE_NAME);
    }

    public void save(String dbName) throws TorqueException {
        try (TorqueConnection con = Transaction.begin((String)dbName);){
            this.save((Connection)con);
            Transaction.commit((Connection)con);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void save(Connection con) throws TorqueException {
        if (this.isSaving()) {
            return;
        }
        try {
            this.setSaving(true);
            if (this.isModified()) {
                if (this.isNew()) {
                    TurbineRolePeer.doInsert((TurbineRole)this, con);
                    this.setNew(false);
                } else {
                    TurbineRolePeer.doUpdate((TurbineRole)this, con);
                }
            }
            if (this.isTurbineRolePermissionsInitialized()) {
                for (TurbineRolePermission collTurbineRolePermissions : this.getTurbineRolePermissions()) {
                    collTurbineRolePermissions.save(con);
                }
            }
            if (this.isTurbineUserGroupRolesInitialized()) {
                for (TurbineUserGroupRole collTurbineUserGroupRoles : this.getTurbineUserGroupRoles()) {
                    collTurbineUserGroupRoles.save(con);
                }
            }
        }
        finally {
            this.setSaving(false);
        }
    }

    public void setPrimaryKey(ObjectKey<?> key) {
        this.setEntityId(((NumberKey)key).intValue());
    }

    public void setPrimaryKey(String key) {
        this.setEntityId(new Integer(key));
    }

    public ObjectKey<?> getPrimaryKey() {
        return SimpleKey.keyFor((Number)this.getEntityId());
    }

    public TurbineRole copy() throws TorqueException {
        return this.copy(true);
    }

    public TurbineRole copy(Connection con) throws TorqueException {
        return this.copy(true, con);
    }

    public TurbineRole copy(boolean deepcopy) throws TorqueException {
        TurbineRole turbineRole = new TurbineRole();
        return this.copyInto(turbineRole, deepcopy);
    }

    public TurbineRole copy(boolean deepcopy, Connection con) throws TorqueException {
        TurbineRole turbineRole = new TurbineRole();
        return this.copyInto(turbineRole, deepcopy, con);
    }

    public TurbineRole copyInto(TurbineRole copyObj) throws TorqueException {
        return this.copyInto(copyObj, true);
    }

    public TurbineRole copyInto(TurbineRole copyObj, Connection con) throws TorqueException {
        return this.copyInto(copyObj, true, con);
    }

    protected TurbineRole copyInto(TurbineRole copyObj, boolean deepcopy) throws TorqueException {
        copyObj.setEntityId(null);
        copyObj.setEntityName(this.entityName);
        if (deepcopy) {
            if (this.collTurbineRolePermissions != null) {
                for (TurbineRolePermission turbineRolePermission : this.collTurbineRolePermissions) {
                    copyObj.addTurbineRolePermission(turbineRolePermission.copy());
                }
            } else {
                copyObj.collTurbineRolePermissions = null;
            }
            if (this.collTurbineUserGroupRoles != null) {
                for (TurbineUserGroupRole turbineUserGroupRole : this.collTurbineUserGroupRoles) {
                    copyObj.addTurbineUserGroupRole(turbineUserGroupRole.copy());
                }
            } else {
                copyObj.collTurbineUserGroupRoles = null;
            }
        }
        return copyObj;
    }

    public TurbineRole copyInto(TurbineRole copyObj, boolean deepcopy, Connection con) throws TorqueException {
        copyObj.setEntityId(null);
        copyObj.setEntityName(this.entityName);
        if (deepcopy) {
            for (TurbineRolePermission turbineRolePermission : this.getTurbineRolePermissions(con)) {
                copyObj.addTurbineRolePermission(turbineRolePermission.copy());
            }
            for (TurbineUserGroupRole turbineUserGroupRole : this.getTurbineUserGroupRoles(con)) {
                copyObj.addTurbineUserGroupRole(turbineUserGroupRole.copy());
            }
        }
        return copyObj;
    }

    public TurbineRolePeer getPeer() {
        return peer;
    }

    public TableMap getTableMap() throws TorqueException {
        return TurbineRolePeer.getTableMap();
    }

    public String toString() {
        StringBuffer str = new StringBuffer();
        str.append("TurbineRole:\n");
        str.append("entityId = ").append(this.getEntityId()).append("\n");
        str.append("entityName = ").append(this.getEntityName()).append("\n");
        return str.toString();
    }

    public boolean equals(Object toCompare) {
        if (toCompare == null) {
            return false;
        }
        if (this == toCompare) {
            return true;
        }
        if (!this.getClass().equals(toCompare.getClass())) {
            return false;
        }
        TurbineRole other = (TurbineRole)toCompare;
        if (this.getPrimaryKey() == null || other.getPrimaryKey() == null) {
            return false;
        }
        return this.getPrimaryKey().equals(other.getPrimaryKey());
    }

    public int hashCode() {
        ObjectKey<?> ok = this.getPrimaryKey();
        if (ok == null) {
            return super.hashCode();
        }
        return ok.hashCode();
    }

    public boolean valueEquals(TurbineRole toCompare) {
        if (toCompare == null) {
            return false;
        }
        if (this == toCompare) {
            return true;
        }
        if (!Objects.equals(this.entityId, toCompare.getEntityId())) {
            return false;
        }
        return Objects.equals(this.entityName, toCompare.getEntityName());
    }
}

