/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fulcrum.security.torque.om;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.fulcrum.security.torque.om.BaseTurbinePermissionPeer;
import org.apache.fulcrum.security.torque.om.TurbinePermission;
import org.apache.torque.Column;
import org.apache.torque.TorqueException;
import org.apache.torque.criteria.Criteria;
import org.apache.torque.om.mapper.RecordMapper;
import org.apache.torque.util.UniqueColumnList;

public class BaseTurbinePermissionRecordMapper
implements RecordMapper<TurbinePermission> {
    private static final long serialVersionUID = 1636017844085L;
    private static Log log = LogFactory.getLog(BaseTurbinePermissionRecordMapper.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TurbinePermission processRow(ResultSet resultSet, int offset, Criteria criteria) throws TorqueException {
        TurbinePermission turbinePermission = new TurbinePermission();
        try {
            turbinePermission.setLoading(true);
            if (criteria == null) {
                turbinePermission.setEntityId(this.getEntityId(resultSet, offset + 1));
                turbinePermission.setEntityName(this.getEntityName(resultSet, offset + 2));
            } else {
                boolean columnMapped = false;
                int totalOffset = offset + 1;
                UniqueColumnList selectColumns = criteria.getSelectColumns();
                List columnsWithoutOffset = selectColumns.subList(offset, selectColumns.size());
                for (Column column : columnsWithoutOffset) {
                    if (BaseTurbinePermissionPeer.PERMISSION_ID.getSqlExpression().equals(column.getSqlExpression())) {
                        turbinePermission.setEntityId(this.getEntityId(resultSet, totalOffset));
                        columnMapped = true;
                    } else if (BaseTurbinePermissionPeer.PERMISSION_NAME.getSqlExpression().equals(column.getSqlExpression())) {
                        turbinePermission.setEntityName(this.getEntityName(resultSet, totalOffset));
                        columnMapped = true;
                    }
                    ++totalOffset;
                }
                if (!columnMapped) {
                    log.debug((Object)"no columns to map found in criteria, returning null");
                    Iterator iterator = null;
                    return iterator;
                }
            }
            turbinePermission.setNew(false);
            turbinePermission.setModified(false);
        }
        finally {
            turbinePermission.setLoading(false);
        }
        return turbinePermission;
    }

    protected Integer getEntityId(ResultSet resultSet, int columnIndex) throws TorqueException {
        try {
            Integer value = resultSet.getInt(columnIndex);
            if (resultSet.wasNull()) {
                value = null;
            }
            return value;
        }
        catch (SQLException e) {
            throw new TorqueException((Throwable)e);
        }
    }

    protected String getEntityName(ResultSet resultSet, int columnIndex) throws TorqueException {
        try {
            return resultSet.getString(columnIndex);
        }
        catch (SQLException e) {
            throw new TorqueException((Throwable)e);
        }
    }
}

