/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fulcrum.security.torque.om;

import java.io.Serializable;
import java.sql.Connection;
import java.util.Objects;
import org.apache.fulcrum.security.torque.om.TorqueDynamicPermission;
import org.apache.fulcrum.security.torque.om.TorqueDynamicPermissionPeer;
import org.apache.fulcrum.security.torque.om.TorqueDynamicRole;
import org.apache.fulcrum.security.torque.om.TorqueDynamicRolePeer;
import org.apache.fulcrum.security.torque.om.TorqueDynamicRolePermission;
import org.apache.fulcrum.security.torque.om.TorqueDynamicRolePermissionPeer;
import org.apache.torque.TorqueException;
import org.apache.torque.map.TableMap;
import org.apache.torque.om.ComboKey;
import org.apache.torque.om.NumberKey;
import org.apache.torque.om.ObjectKey;
import org.apache.torque.om.Persistent;
import org.apache.torque.om.SimpleKey;
import org.apache.torque.util.TorqueConnection;
import org.apache.torque.util.Transaction;

public abstract class BaseTorqueDynamicRolePermission
implements Persistent,
Serializable {
    private static final long serialVersionUID = 1636017839909L;
    private Integer roleId = null;
    private Integer permissionId = null;
    private boolean modified = true;
    private boolean isNew = true;
    private boolean saving = false;
    private boolean loading = false;
    private boolean deleted = false;
    private TorqueDynamicRole aTorqueDynamicRole = null;
    private TorqueDynamicPermission aTorqueDynamicPermission = null;
    private final SimpleKey<?>[] pks = new SimpleKey[2];
    private final ComboKey comboPK = new ComboKey(this.pks);
    private static final TorqueDynamicRolePermissionPeer peer = new TorqueDynamicRolePermissionPeer();

    public Integer getRoleId() {
        return this.roleId;
    }

    public void setRoleId(Integer v) {
        if (!Objects.equals(this.roleId, v)) {
            this.setModified(true);
        }
        this.roleId = v;
        if (this.aTorqueDynamicRole != null && !Objects.equals(this.aTorqueDynamicRole.getEntityId(), v)) {
            this.aTorqueDynamicRole = null;
        }
    }

    public Integer getPermissionId() {
        return this.permissionId;
    }

    public void setPermissionId(Integer v) {
        if (!Objects.equals(this.permissionId, v)) {
            this.setModified(true);
        }
        this.permissionId = v;
        if (this.aTorqueDynamicPermission != null && !Objects.equals(this.aTorqueDynamicPermission.getEntityId(), v)) {
            this.aTorqueDynamicPermission = null;
        }
    }

    public boolean isNew() {
        return this.isNew;
    }

    public void setNew(boolean isNew) {
        this.isNew = isNew;
    }

    public boolean isModified() {
        return this.modified;
    }

    public void setModified(boolean modified) {
        this.modified = modified;
    }

    public void resetModified() {
        this.modified = false;
    }

    public boolean isSaving() {
        return this.saving;
    }

    public void setSaving(boolean saving) {
        this.saving = saving;
    }

    public boolean isLoading() {
        return this.loading;
    }

    public void setLoading(boolean loading) {
        this.loading = loading;
    }

    public boolean isDeleted() {
        return this.deleted;
    }

    public void setDeleted(boolean deleted) {
        this.deleted = deleted;
    }

    public TorqueDynamicRole getTorqueDynamicRole() throws TorqueException {
        if (this.aTorqueDynamicRole == null && !Objects.equals(this.roleId, null)) {
            this.aTorqueDynamicRole = TorqueDynamicRolePeer.retrieveByPK(SimpleKey.keyFor((Number)this.roleId));
        }
        return this.aTorqueDynamicRole;
    }

    public TorqueDynamicRole getTorqueDynamicRole(Connection connection) throws TorqueException {
        if (this.aTorqueDynamicRole == null && !Objects.equals(this.roleId, null)) {
            this.aTorqueDynamicRole = TorqueDynamicRolePeer.retrieveByPK(SimpleKey.keyFor((Number)this.roleId), connection);
        }
        return this.aTorqueDynamicRole;
    }

    public void setTorqueDynamicRole(TorqueDynamicRole v) {
        if (v == null) {
            this.setRoleId(null);
        } else {
            this.setRoleId(v.getEntityId());
        }
        this.aTorqueDynamicRole = v;
    }

    public void setTorqueDynamicRoleKey(ObjectKey<?> key) throws TorqueException {
        this.setRoleId(((NumberKey)key).intValue());
    }

    public TorqueDynamicPermission getTorqueDynamicPermission() throws TorqueException {
        if (this.aTorqueDynamicPermission == null && !Objects.equals(this.permissionId, null)) {
            this.aTorqueDynamicPermission = TorqueDynamicPermissionPeer.retrieveByPK(SimpleKey.keyFor((Number)this.permissionId));
        }
        return this.aTorqueDynamicPermission;
    }

    public TorqueDynamicPermission getTorqueDynamicPermission(Connection connection) throws TorqueException {
        if (this.aTorqueDynamicPermission == null && !Objects.equals(this.permissionId, null)) {
            this.aTorqueDynamicPermission = TorqueDynamicPermissionPeer.retrieveByPK(SimpleKey.keyFor((Number)this.permissionId), connection);
        }
        return this.aTorqueDynamicPermission;
    }

    public void setTorqueDynamicPermission(TorqueDynamicPermission v) {
        if (v == null) {
            this.setPermissionId(null);
        } else {
            this.setPermissionId(v.getEntityId());
        }
        this.aTorqueDynamicPermission = v;
    }

    public void setTorqueDynamicPermissionKey(ObjectKey<?> key) throws TorqueException {
        this.setPermissionId(((NumberKey)key).intValue());
    }

    public void save() throws TorqueException {
        this.save(TorqueDynamicRolePermissionPeer.DATABASE_NAME);
    }

    public void save(String dbName) throws TorqueException {
        try (TorqueConnection con = Transaction.begin((String)dbName);){
            this.save((Connection)con);
            Transaction.commit((Connection)con);
        }
    }

    public void save(Connection con) throws TorqueException {
        if (this.isSaving()) {
            return;
        }
        try {
            this.setSaving(true);
            if (this.isModified()) {
                if (this.isNew()) {
                    TorqueDynamicRolePermissionPeer.doInsert((TorqueDynamicRolePermission)this, con);
                    this.setNew(false);
                } else {
                    TorqueDynamicRolePermissionPeer.doUpdate((TorqueDynamicRolePermission)this, con);
                }
            }
        }
        finally {
            this.setSaving(false);
        }
    }

    public void setPrimaryKey(ObjectKey<?> key) throws TorqueException {
        SimpleKey[] keys = (SimpleKey[])key.getValue();
        this.setRoleId(((NumberKey)keys[0]).intValue());
        this.setPermissionId(((NumberKey)keys[1]).intValue());
    }

    public void setPrimaryKey(Integer roleId, Integer permissionId) {
        this.setRoleId(roleId);
        this.setPermissionId(permissionId);
    }

    public void setPrimaryKey(String key) throws TorqueException {
        this.setPrimaryKey((ObjectKey<?>)new ComboKey(key));
    }

    public ObjectKey<?> getPrimaryKey() {
        SimpleKey[] pks = new SimpleKey[]{SimpleKey.keyFor((Number)this.getRoleId()), SimpleKey.keyFor((Number)this.getPermissionId())};
        return new ComboKey(pks);
    }

    public ObjectKey<?> getForeignKeyForTorqueDynamicRole() {
        return SimpleKey.keyFor((Number)this.getRoleId());
    }

    public ObjectKey<?> getForeignKeyForTorqueDynamicPermission() {
        return SimpleKey.keyFor((Number)this.getPermissionId());
    }

    public TorqueDynamicRolePermission copy() throws TorqueException {
        return this.copy(true);
    }

    public TorqueDynamicRolePermission copy(Connection con) throws TorqueException {
        return this.copy(true, con);
    }

    public TorqueDynamicRolePermission copy(boolean deepcopy) throws TorqueException {
        TorqueDynamicRolePermission torqueDynamicRolePermission = new TorqueDynamicRolePermission();
        return this.copyInto(torqueDynamicRolePermission, deepcopy);
    }

    public TorqueDynamicRolePermission copy(boolean deepcopy, Connection con) throws TorqueException {
        TorqueDynamicRolePermission torqueDynamicRolePermission = new TorqueDynamicRolePermission();
        return this.copyInto(torqueDynamicRolePermission, deepcopy, con);
    }

    public TorqueDynamicRolePermission copyInto(TorqueDynamicRolePermission copyObj) throws TorqueException {
        return this.copyInto(copyObj, true);
    }

    public TorqueDynamicRolePermission copyInto(TorqueDynamicRolePermission copyObj, Connection con) throws TorqueException {
        return this.copyInto(copyObj, true, con);
    }

    protected TorqueDynamicRolePermission copyInto(TorqueDynamicRolePermission copyObj, boolean deepcopy) throws TorqueException {
        copyObj.setRoleId(null);
        copyObj.setPermissionId(null);
        if (deepcopy) {
            // empty if block
        }
        return copyObj;
    }

    public TorqueDynamicRolePermission copyInto(TorqueDynamicRolePermission copyObj, boolean deepcopy, Connection con) throws TorqueException {
        copyObj.setRoleId(null);
        copyObj.setPermissionId(null);
        if (deepcopy) {
            // empty if block
        }
        return copyObj;
    }

    public TorqueDynamicRolePermissionPeer getPeer() {
        return peer;
    }

    public TableMap getTableMap() throws TorqueException {
        return TorqueDynamicRolePermissionPeer.getTableMap();
    }

    public String toString() {
        StringBuffer str = new StringBuffer();
        str.append("TorqueDynamicRolePermission:\n");
        str.append("roleId = ").append(this.getRoleId()).append("\n");
        str.append("permissionId = ").append(this.getPermissionId()).append("\n");
        return str.toString();
    }

    public boolean equals(Object toCompare) {
        if (toCompare == null) {
            return false;
        }
        if (this == toCompare) {
            return true;
        }
        if (!this.getClass().equals(toCompare.getClass())) {
            return false;
        }
        TorqueDynamicRolePermission other = (TorqueDynamicRolePermission)toCompare;
        if (this.getPrimaryKey() == null || other.getPrimaryKey() == null) {
            return false;
        }
        return this.getPrimaryKey().equals(other.getPrimaryKey());
    }

    public int hashCode() {
        ObjectKey<?> ok = this.getPrimaryKey();
        if (ok == null) {
            return super.hashCode();
        }
        return ok.hashCode();
    }

    public boolean valueEquals(TorqueDynamicRolePermission toCompare) {
        if (toCompare == null) {
            return false;
        }
        if (this == toCompare) {
            return true;
        }
        if (!Objects.equals(this.roleId, toCompare.getRoleId())) {
            return false;
        }
        return Objects.equals(this.permissionId, toCompare.getPermissionId());
    }
}

