/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fulcrum.security.torque;

import java.sql.Connection;
import java.util.List;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.fulcrum.security.entity.Group;
import org.apache.fulcrum.security.entity.SecurityEntity;
import org.apache.fulcrum.security.spi.AbstractGroupManager;
import org.apache.fulcrum.security.torque.LazyLoadable;
import org.apache.fulcrum.security.torque.security.TorqueAbstractSecurityEntity;
import org.apache.fulcrum.security.util.DataBackendException;
import org.apache.fulcrum.security.util.GroupSet;
import org.apache.fulcrum.security.util.UnknownEntityException;
import org.apache.torque.NoRowsException;
import org.apache.torque.TooManyRowsException;
import org.apache.torque.TorqueException;
import org.apache.torque.util.TorqueConnection;
import org.apache.torque.util.Transaction;

public abstract class TorqueAbstractGroupManager
extends AbstractGroupManager
implements LazyLoadable {
    private static final long serialVersionUID = -3735730556110100621L;
    private static final String LAZY_LOADING = "lazy";
    protected Boolean lazyLoading = false;

    public void configure(Configuration conf) throws ConfigurationException {
        super.configure(conf);
        this.lazyLoading = conf.getAttributeAsBoolean(LAZY_LOADING, false);
        this.getLogger().debug("setting lazyLoading: " + this.lazyLoading);
    }

    protected abstract <T extends Group> List<T> doSelectAllGroups(Connection var1) throws TorqueException;

    protected abstract <T extends Group> T doSelectByName(String var1, Connection var2) throws NoRowsException, TooManyRowsException, TorqueException;

    protected abstract <T extends Group> T doSelectById(Integer var1, Connection var2) throws NoRowsException, TooManyRowsException, TorqueException;

    protected synchronized <T extends Group> T persistNewGroup(T group) throws DataBackendException {
        try {
            ((TorqueAbstractSecurityEntity)group).save();
        }
        catch (Exception e) {
            throw new DataBackendException("Adding Group '" + group.getName() + "' failed", (Throwable)e);
        }
        return group;
    }

    public synchronized void renameGroup(Group group, String name) throws DataBackendException, UnknownEntityException {
        if (this.checkExists(group)) {
            group.setName(name);
            try {
                TorqueAbstractSecurityEntity g = (TorqueAbstractSecurityEntity)group;
                g.setNew(false);
                g.save();
            }
            catch (Exception e) {
                throw new DataBackendException("Renaming Group '" + group.getName() + "' failed", (Throwable)e);
            }
        } else {
            throw new UnknownEntityException("Unknown group '" + group.getName() + "'");
        }
    }

    public synchronized void removeGroup(Group group) throws DataBackendException, UnknownEntityException {
        try {
            ((TorqueAbstractSecurityEntity)group).delete();
        }
        catch (TorqueException e) {
            throw new DataBackendException("Removing Group '" + group.getName() + "' failed", (Throwable)e);
        }
    }

    public <T extends Group> T getGroupByName(String name) throws DataBackendException, UnknownEntityException {
        T group = null;
        TorqueConnection con = null;
        try {
            con = Transaction.begin();
            group = this.doSelectByName(name, (Connection)con);
            ((TorqueAbstractSecurityEntity)group).retrieveAttachedObjects((Connection)con, this.getLazyLoading());
            Transaction.commit((Connection)con);
            con = null;
        }
        catch (NoRowsException e) {
            throw new UnknownEntityException("Could not find group " + name);
        }
        catch (TooManyRowsException e) {
            throw new DataBackendException("Multiple Groups with same name '" + name + "'");
        }
        catch (TorqueException e) {
            throw new DataBackendException("Error retrieving group information", (Throwable)e);
        }
        finally {
            if (con != null) {
                Transaction.safeRollback((Connection)con);
            }
        }
        return group;
    }

    public GroupSet getAllGroups() throws DataBackendException {
        GroupSet groupSet = new GroupSet();
        TorqueConnection con = null;
        try {
            con = Transaction.begin();
            List groups = this.doSelectAllGroups((Connection)con);
            for (Group group : groups) {
                ((TorqueAbstractSecurityEntity)group).retrieveAttachedObjects((Connection)con, this.getLazyLoading());
                groupSet.add((SecurityEntity)group);
            }
            Transaction.commit((Connection)con);
            con = null;
        }
        catch (TorqueException e) {
            throw new DataBackendException("Error retrieving group information", (Throwable)e);
        }
        finally {
            if (con != null) {
                Transaction.safeRollback((Connection)con);
            }
        }
        return groupSet;
    }

    public boolean checkExists(String groupName) throws DataBackendException {
        boolean exists = false;
        TorqueConnection con = null;
        try {
            con = Transaction.begin();
            this.doSelectByName(groupName, (Connection)con);
            Transaction.commit((Connection)con);
            con = null;
            exists = true;
        }
        catch (NoRowsException e) {
            exists = false;
        }
        catch (TooManyRowsException e) {
            throw new DataBackendException("Multiple groups with same name '" + groupName + "'");
        }
        catch (TorqueException e) {
            throw new DataBackendException("Error retrieving group information", (Throwable)e);
        }
        finally {
            if (con != null) {
                Transaction.safeRollback((Connection)con);
            }
        }
        return exists;
    }

    public <T extends Group> T getGroupById(Object id) throws DataBackendException, UnknownEntityException {
        T group;
        if (id != null && id instanceof Integer) {
            TorqueConnection con = null;
            try {
                con = Transaction.begin();
                group = this.doSelectById((Integer)id, (Connection)con);
                ((TorqueAbstractSecurityEntity)group).retrieveAttachedObjects((Connection)con, this.getLazyLoading());
                Transaction.commit((Connection)con);
                con = null;
            }
            catch (NoRowsException e) {
                throw new UnknownEntityException("Group with id '" + id + "' does not exist.", (Throwable)e);
            }
            catch (TorqueException e) {
                throw new DataBackendException("Error retrieving group information", (Throwable)e);
            }
            finally {
                if (con != null) {
                    Transaction.safeRollback((Connection)con);
                }
            }
        } else {
            throw new UnknownEntityException("Invalid group id '" + id + "'");
        }
        return group;
    }

    @Override
    public Boolean getLazyLoading() {
        return this.lazyLoading;
    }

    @Override
    public void setLazyLoading(Boolean lazyLoading) {
        this.lazyLoading = lazyLoading;
    }
}

