/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fulcrum.security.model.turbine.test;

import java.util.Set;
import org.apache.fulcrum.security.GroupManager;
import org.apache.fulcrum.security.PermissionManager;
import org.apache.fulcrum.security.RoleManager;
import org.apache.fulcrum.security.SecurityService;
import org.apache.fulcrum.security.UserManager;
import org.apache.fulcrum.security.entity.Group;
import org.apache.fulcrum.security.entity.Permission;
import org.apache.fulcrum.security.entity.Role;
import org.apache.fulcrum.security.entity.User;
import org.apache.fulcrum.security.model.turbine.TurbineModelManager;
import org.apache.fulcrum.security.model.turbine.entity.TurbineGroup;
import org.apache.fulcrum.security.model.turbine.entity.TurbineRole;
import org.apache.fulcrum.security.model.turbine.entity.TurbineUser;
import org.apache.fulcrum.security.model.turbine.entity.TurbineUserGroupRole;
import org.apache.fulcrum.security.util.PermissionSet;
import org.apache.fulcrum.security.util.UserSet;
import org.apache.fulcrum.testcontainer.BaseUnit5Test;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public abstract class AbstractTurbineModelManagerTest
extends BaseUnit5Test {
    protected Role role;
    protected TurbineModelManager modelManager;
    protected RoleManager roleManager;
    protected GroupManager groupManager;
    protected PermissionManager permissionManager;
    protected UserManager userManager;
    protected SecurityService securityService;

    @BeforeEach
    public void setUp() throws Exception {
        this.securityService = (SecurityService)this.lookup(SecurityService.ROLE);
        this.roleManager = this.securityService.getRoleManager();
        this.userManager = this.securityService.getUserManager();
        this.groupManager = this.securityService.getGroupManager();
        this.permissionManager = this.securityService.getPermissionManager();
        this.modelManager = (TurbineModelManager)this.securityService.getModelManager();
    }

    @Test
    public void testGetGlobalGroup() throws Exception {
        Group global = this.modelManager.getGlobalGroup();
        Assertions.assertNotNull((Object)global);
        Assertions.assertEquals((Object)global.getName(), (Object)this.modelManager.getGlobalGroupName());
    }

    @Test
    public void testGrantRolePermission() throws Exception {
        Permission permission = this.permissionManager.getPermissionInstance();
        permission.setName("ANSWER_PHONE");
        this.permissionManager.addPermission(permission);
        this.role = this.roleManager.getRoleInstance("RECEPTIONIST");
        this.roleManager.addRole(this.role);
        this.modelManager.grant(this.role, permission);
        this.role = this.roleManager.getRoleById(this.role.getId());
        PermissionSet permissions = ((TurbineRole)this.role).getPermissions();
        Assertions.assertEquals((int)1, (int)permissions.size());
        Assertions.assertTrue((boolean)((TurbineRole)this.role).getPermissions().contains((Object)permission));
    }

    @Test
    public void testRevokeRolePermission() throws Exception {
        Permission permission = this.securityService.getPermissionManager().getPermissionInstance();
        permission.setName("ANSWER_FAX");
        this.securityService.getPermissionManager().addPermission(permission);
        this.role = this.roleManager.getRoleInstance("SECRETARY");
        this.roleManager.addRole(this.role);
        this.modelManager.grant(this.role, permission);
        this.role = this.roleManager.getRoleById(this.role.getId());
        PermissionSet permissions = ((TurbineRole)this.role).getPermissions();
        Assertions.assertEquals((int)1, (int)permissions.size());
        this.modelManager.revoke(this.role, permission);
        this.role = this.roleManager.getRoleById(this.role.getId());
        permissions = ((TurbineRole)this.role).getPermissions();
        Assertions.assertEquals((int)0, (int)permissions.size());
        Assertions.assertFalse((boolean)((TurbineRole)this.role).getPermissions().contains((Object)permission));
    }

    @Test
    public void testRevokeRolePermissionOneOfTwo() throws Exception {
        Permission permission = this.securityService.getPermissionManager().getPermissionInstance();
        Permission permission2 = this.securityService.getPermissionManager().getPermissionInstance();
        permission.setName("ANOTHER_SEND_SPAM");
        permission2.setName("ANOTHER_ANSWER_EMAIL");
        permission = this.securityService.getPermissionManager().addPermission(permission);
        permission2 = this.securityService.getPermissionManager().addPermission(permission2);
        this.role = this.roleManager.getRoleInstance("ANOTHERSECRETARY");
        this.role = this.roleManager.addRole(this.role);
        this.modelManager.grant(this.role, permission);
        this.modelManager.grant(this.role, permission2);
        this.role = this.roleManager.getRoleById(this.role.getId());
        PermissionSet permissions = ((TurbineRole)this.role).getPermissions();
        Assertions.assertEquals((int)2, (int)permissions.size());
        this.modelManager.revoke(this.role, permission);
        this.role = this.roleManager.getRoleById(this.role.getId());
        permissions = ((TurbineRole)this.role).getPermissions();
        Assertions.assertEquals((int)1, (int)permissions.size());
        Assertions.assertFalse((boolean)((TurbineRole)this.role).getPermissions().contains((Object)permission));
        Assertions.assertTrue((boolean)((TurbineRole)this.role).getPermissions().contains((Object)permission2));
        this.modelManager.revoke(this.role, permission2);
        Assertions.assertFalse((boolean)((TurbineRole)this.role).getPermissions().contains((Object)permission2));
    }

    @Test
    public void testRevokeAllRole() throws Exception {
        Permission permission = this.securityService.getPermissionManager().getPermissionInstance();
        Permission permission2 = this.securityService.getPermissionManager().getPermissionInstance();
        permission.setName("SEND_SPAM");
        permission2.setName("ANSWER_EMAIL");
        this.securityService.getPermissionManager().addPermission(permission);
        this.securityService.getPermissionManager().addPermission(permission2);
        this.role = this.roleManager.getRoleInstance("HELPER");
        this.roleManager.addRole(this.role);
        this.modelManager.grant(this.role, permission);
        this.modelManager.grant(this.role, permission2);
        this.role = this.roleManager.getRoleById(this.role.getId());
        PermissionSet permissions = ((TurbineRole)this.role).getPermissions();
        Assertions.assertEquals((int)2, (int)permissions.size());
        this.modelManager.revokeAll(this.role);
        this.role = this.roleManager.getRoleById(this.role.getId());
        permissions = ((TurbineRole)this.role).getPermissions();
        Assertions.assertEquals((int)0, (int)permissions.size());
    }

    @Test
    public void testRevokeAllUser() throws Exception {
        Group group = this.securityService.getGroupManager().getGroupInstance();
        group.setName("TEST_REVOKEALLUSER_GROUP");
        this.securityService.getGroupManager().addGroup(group);
        Role role = this.securityService.getRoleManager().getRoleInstance();
        role.setName("TEST_REVOKEALLUSER_ROLE");
        role = this.securityService.getRoleManager().addRole(role);
        Group group2 = this.securityService.getGroupManager().getGroupInstance();
        group2.setName("TEST_REVOKEALLUSER_GROUP2");
        this.securityService.getGroupManager().addGroup(group2);
        Role role2 = this.securityService.getRoleManager().getRoleInstance();
        role2.setName("TEST_REVOKEALLUSER_ROLE2");
        role2 = this.securityService.getRoleManager().addRole(role2);
        String username = "calvin";
        User user = this.userManager.getUserInstance(username);
        user = this.userManager.addUser(user, username);
        this.modelManager.grant(user, group, role);
        this.modelManager.grant(user, group2, role2);
        Set userGroupRoleSet = ((TurbineUser)user).getUserGroupRoleSet();
        Assertions.assertEquals((int)2, (int)userGroupRoleSet.size());
        Set userGroupRoleSet1 = ((TurbineRole)role).getUserGroupRoleSet();
        Assertions.assertEquals((int)1, (int)userGroupRoleSet1.size());
        Set userGroupRoleSet2 = ((TurbineGroup)group).getUserGroupRoleSet();
        Assertions.assertEquals((int)1, (int)userGroupRoleSet2.size());
        group = this.groupManager.getGroupById(group.getId());
        user = this.userManager.getUser(username);
        role = this.roleManager.getRoleById(role.getId());
        UserSet userSet = this.userManager.getAllUsers();
        User user2 = this.userManager.getUserById(user.getId());
        Assertions.assertEquals((Object)user, (Object)user2);
        userGroupRoleSet = ((TurbineUser)user).getUserGroupRoleSet();
        Assertions.assertEquals((int)2, (int)userGroupRoleSet.size());
        userGroupRoleSet1 = ((TurbineRole)role).getUserGroupRoleSet();
        Assertions.assertEquals((int)1, (int)userGroupRoleSet1.size());
        userGroupRoleSet2 = ((TurbineGroup)group).getUserGroupRoleSet();
        Assertions.assertEquals((int)1, (int)userGroupRoleSet2.size());
        this.modelManager.revokeAll(user);
        group = this.groupManager.getGroupById(group.getId());
        Assertions.assertEquals((int)0, (int)((TurbineGroup)group).getUserGroupRoleSet().size());
        role = this.securityService.getRoleManager().getRoleByName("TEST_REVOKEALLUSER_ROLE");
        Assertions.assertEquals((int)0, (int)((TurbineRole)role).getUserGroupRoleSet().size());
        Assertions.assertTrue((boolean)((TurbineRole)role).getUserGroupRoleSet().isEmpty());
        this.modelManager.grant(user, group, role);
        Assertions.assertEquals((int)1, (int)((TurbineRole)role).getUserGroupRoleSet().size());
        Assertions.assertTrue((boolean)((TurbineUserGroupRole)((TurbineRole)role).getUserGroupRoleSet().iterator().next()).getGroup().equals(group));
    }

    @Test
    public void testGrantUserGroupRole() throws Exception {
        Group group = this.securityService.getGroupManager().getGroupInstance();
        group.setName("TEST_GROUP");
        this.securityService.getGroupManager().addGroup(group);
        Role role = this.roleManager.getRoleInstance();
        role.setName("TEST_Role");
        this.roleManager.addRole(role);
        User user = this.userManager.getUserInstance("Clint");
        this.userManager.addUser(user, "clint");
        this.modelManager.grant(user, group, role);
        boolean ugrFound = false;
        TurbineUserGroupRole ugrTest = null;
        for (TurbineUserGroupRole ugr : ((TurbineUser)user).getUserGroupRoleSet()) {
            if (!ugr.getUser().equals(user) || !ugr.getGroup().equals(group) || !ugr.getRole().equals(role)) continue;
            ugrFound = true;
            ugrTest = ugr;
            break;
        }
        Assertions.assertTrue((boolean)ugrFound);
        Assertions.assertTrue((boolean)ugrTest.getGroup().equals(group));
        Assertions.assertTrue((boolean)ugrTest.getUser().equals(user));
    }

    @Test
    public void testRevokeUserGroupRole() throws Exception {
        Group group = this.securityService.getGroupManager().getGroupInstance();
        group.setName("TEST_REVOKE");
        this.securityService.getGroupManager().addGroup(group);
        User user = this.userManager.getUserInstance("Lima");
        this.userManager.addUser(user, "pet");
        Role role = this.roleManager.getRoleInstance();
        role.setName("TEST_REVOKE_ROLE");
        this.roleManager.addRole(role);
        this.modelManager.grant(user, group, role);
        this.modelManager.revoke(user, group, role);
        boolean ugrFound = false;
        for (TurbineUserGroupRole ugr : ((TurbineUser)user).getUserGroupRoleSet()) {
            if (!ugr.getUser().equals(user) || !ugr.getGroup().equals(group) || !ugr.getRole().equals(role)) continue;
            ugrFound = true;
            break;
        }
        Assertions.assertFalse((boolean)ugrFound);
    }

    @Test
    public void testUserGroupGrantRolePermission() throws Exception {
        Permission permission = this.permissionManager.getPermissionInstance();
        permission.setName("ANSWER_PHONE__");
        this.permissionManager.addPermission(permission);
        Permission permission2 = this.permissionManager.getPermissionInstance();
        permission2.setName("ANSWER_PHONE__2");
        this.permissionManager.addPermission(permission2);
        this.role = this.roleManager.getRoleInstance("RECEPTIONIST__");
        this.roleManager.addRole(this.role);
        Group group = this.securityService.getGroupManager().getGroupInstance();
        group.setName("TEST_GROUP__");
        this.securityService.getGroupManager().addGroup(group);
        Role role = this.roleManager.getRoleInstance();
        role.setName("TEST_Role__");
        this.roleManager.addRole(role);
        User user = this.userManager.getUserInstance("Clint__");
        this.userManager.addUser(user, "clint");
        this.modelManager.grant(user, group, role);
        this.modelManager.grant(role, permission);
        this.modelManager.grant(role, permission2);
        role = this.roleManager.getRoleById(role.getId());
        PermissionSet permissions = ((TurbineRole)role).getPermissions();
        Assertions.assertEquals((int)2, (int)permissions.size());
        Assertions.assertTrue((boolean)((TurbineRole)role).getPermissions().contains((Object)permission));
        Assertions.assertTrue((boolean)((TurbineRole)role).getPermissions().contains((Object)permission2));
        this.modelManager.revoke(role, permission2);
        permissions = ((TurbineRole)role).getPermissions();
        Assertions.assertEquals((int)1, (int)permissions.size());
        Assertions.assertTrue((boolean)((TurbineRole)role).getPermissions().contains((Object)permission));
        this.modelManager.revoke(role, permission);
        permissions = ((TurbineRole)role).getPermissions();
        Assertions.assertEquals((int)0, (int)permissions.size());
        Assertions.assertFalse((boolean)((TurbineRole)role).getPermissions().contains((Object)permission));
    }

    @Test
    public void testReplaceUserGroupRole() throws Exception {
        Group global = this.modelManager.getGlobalGroup();
        Role role = this.roleManager.getRoleInstance();
        role.setName("TEST_REPLACE_ROLE");
        if (!this.roleManager.checkExists(role)) {
            this.roleManager.addRole(role);
        }
        Role newRole = this.roleManager.getRoleInstance();
        newRole.setName("TEST_NEW_ROLE");
        this.roleManager.addRole(newRole);
        User user = this.userManager.getUserInstance("Dave");
        this.userManager.addUser(user, "dave");
        this.modelManager.grant(user, global, role);
        this.modelManager.replace(user, role, newRole);
        boolean ugrFound = false;
        boolean ugrNotFound = true;
        TurbineUserGroupRole ugrTest = null;
        for (TurbineUserGroupRole ugr : ((TurbineUser)user).getUserGroupRoleSet()) {
            if (ugr.getUser().equals(user) && ugr.getGroup().equals(global) && ugr.getRole().equals(newRole)) {
                ugrFound = true;
                ugrTest = ugr;
            }
            if (!ugr.getUser().equals(user) || !ugr.getGroup().equals(global) || !ugr.getRole().equals(role)) continue;
            ugrNotFound = false;
            ugrTest = ugr;
        }
        Assertions.assertTrue((boolean)ugrFound);
        Assertions.assertTrue((boolean)ugrNotFound);
        Assertions.assertTrue((boolean)ugrTest.getGroup().equals(global));
        Assertions.assertTrue((boolean)ugrTest.getUser().equals(user));
    }
}

