/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fulcrum.security.memory;

import java.util.ArrayList;
import java.util.List;
import org.apache.fulcrum.security.entity.Role;
import org.apache.fulcrum.security.memory.MemoryHelper;
import org.apache.fulcrum.security.spi.AbstractRoleManager;
import org.apache.fulcrum.security.util.DataBackendException;
import org.apache.fulcrum.security.util.RoleSet;
import org.apache.fulcrum.security.util.UnknownEntityException;

public class MemoryRoleManagerImpl
extends AbstractRoleManager {
    private static List<Role> roles = new ArrayList<Role>();

    public MemoryRoleManagerImpl() {
        roles.clear();
    }

    public synchronized void renameRole(Role role, String name) throws DataBackendException, UnknownEntityException {
        boolean roleExists = false;
        try {
            roleExists = this.checkExists(role);
            if (roleExists) {
                roles.remove(role);
                role.setName(name);
                roles.add(role);
                return;
            }
        }
        catch (DataBackendException e) {
            throw new DataBackendException("renameRole(Role,String)", (Throwable)e);
        }
        throw new UnknownEntityException("Unknown role '" + role + "'");
    }

    public boolean checkExists(String roleName) {
        return MemoryHelper.checkExists(roles, roleName);
    }

    public RoleSet getAllRoles() throws DataBackendException {
        return new RoleSet(roles);
    }

    protected synchronized <T extends Role> T persistNewRole(T role) throws DataBackendException {
        role.setId((Object)MemoryHelper.getUniqueId());
        roles.add(role);
        this.getAllRoles().add(role);
        return role;
    }

    public synchronized void removeRole(Role role) throws DataBackendException, UnknownEntityException {
        boolean roleExists = false;
        try {
            roleExists = this.checkExists(role);
            if (roleExists) {
                roles.remove(role);
                this.getAllRoles().remove((Object)role);
                return;
            }
        }
        catch (DataBackendException e) {
            throw new DataBackendException("removeRole(Role)", (Throwable)e);
        }
        throw new UnknownEntityException("Unknown role '" + role + "'");
    }
}

