/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomee.myfaces;

import jakarta.servlet.ServletContainerInitializer;
import jakarta.servlet.ServletContext;
import jakarta.servlet.ServletException;
import java.lang.reflect.Field;
import java.net.URL;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.logging.Filter;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.catalina.Container;
import org.apache.catalina.Context;
import org.apache.catalina.Wrapper;
import org.apache.catalina.core.ApplicationContext;
import org.apache.catalina.core.ApplicationContextFacade;
import org.apache.catalina.core.StandardContext;
import org.apache.myfaces.ee.MyFacesContainerInitializer;
import org.apache.myfaces.webapp.AbstractFacesInitializer;
import org.apache.myfaces.webapp.StartupServletContextListener;
import org.apache.openejb.loader.SystemInstance;
import org.apache.openejb.log.RemoveLogMessage;
import org.apache.openejb.util.URLs;
import org.apache.tomee.myfaces.TomEEFacesConfigResourceProvider;

public class TomEEMyFacesContainerInitializer
implements ServletContainerInitializer {
    public static final String OPENEJB_JSF_SKIP = "openejb.jsf.skip";
    private final MyFacesContainerInitializer delegate = new MyFacesContainerInitializer();

    public void onStartup(Set<Class<?>> classes, ServletContext ctx) throws ServletException {
        if ("true".equalsIgnoreCase(ctx.getInitParameter("org.apache.myfaces.INITIALIZE_ALWAYS_STANDALONE")) || "true".equals(SystemInstance.get().getProperty(OPENEJB_JSF_SKIP, "false"))) {
            return;
        }
        try {
            ctx.getClassLoader().loadClass("com.sun.faces.context.SessionMap");
            return;
        }
        catch (ClassNotFoundException | NoClassDefFoundError throwable) {
            Logger abstractInitializerLogger = Logger.getLogger(AbstractFacesInitializer.class.getName());
            abstractInitializerLogger.setFilter((Filter)new RemoveLogMessage((Filter)new RemoveLogMessage(abstractInitializerLogger.getFilter(), Level.WARNING, "No mappings of FacesServlet found. Abort initializing MyFaces."), Level.WARNING, "No mappings of FacesServlet found. Abort destroy MyFaces."));
            boolean facesServletPresent = this.isFacesServletPresent(ctx);
            if (facesServletPresent || this.isFacesConfigPresent(ctx)) {
                Set<Class<?>> passedClasses = classes;
                if (passedClasses == null) {
                    passedClasses = new HashSet();
                }
                if (passedClasses.isEmpty()) {
                    passedClasses.add(TomEEMyFacesContainerInitializer.class);
                }
                if (ctx instanceof ApplicationContextFacade) {
                    try {
                        ApplicationContext appCtx = (ApplicationContext)TomEEMyFacesContainerInitializer.get(ApplicationContextFacade.class, ctx);
                        Context tomcatCtx = (Context)TomEEMyFacesContainerInitializer.get(ApplicationContext.class, appCtx);
                        if (!Arrays.asList(tomcatCtx.findApplicationListeners()).contains(StartupServletContextListener.class.getName())) {
                            this.addListener(ctx);
                        }
                    }
                    catch (Exception e) {
                        this.addListener(ctx);
                    }
                }
                if (!facesServletPresent) {
                    this.delegate.onStartup(classes, ctx);
                }
            }
            return;
        }
    }

    private boolean isFacesServletPresent(ServletContext ctx) {
        if (ctx instanceof ApplicationContextFacade) {
            try {
                Container[] servlets;
                ApplicationContext appCtx = (ApplicationContext)TomEEMyFacesContainerInitializer.get(ApplicationContextFacade.class, ctx);
                Context tomcatCtx = (Context)TomEEMyFacesContainerInitializer.get(ApplicationContext.class, appCtx);
                if (tomcatCtx instanceof StandardContext && (servlets = tomcatCtx.findChildren()) != null) {
                    for (Container s : servlets) {
                        if (!(s instanceof Wrapper) || !"jakarta.faces.webapp.FacesServlet".equals(((Wrapper)s).getServletClass()) && !"Faces Servlet".equals(s.getName())) continue;
                        return true;
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return false;
    }

    private void addListener(ServletContext ctx) {
        Logger logger = Logger.getLogger(AbstractFacesInitializer.class.getName());
        logger.log(Level.INFO, "Installing <listener>" + StartupServletContextListener.class.getName() + "</listener>");
        ctx.addListener(StartupServletContextListener.class);
    }

    private boolean isFacesConfigPresent(ServletContext servletContext) {
        try {
            Collection<URL> metaInfFacesConfigUrls;
            if (servletContext.getResource("/WEB-INF/faces-config.xml") != null) {
                return true;
            }
            String configFilesAttrValue = servletContext.getInitParameter("jakarta.faces.CONFIG_FILES");
            if (configFilesAttrValue != null) {
                String[] configFiles;
                for (String file : configFiles = configFilesAttrValue.split(",")) {
                    if (servletContext.getResource(file.trim()) == null) continue;
                    return true;
                }
            }
            if ((metaInfFacesConfigUrls = new TomEEFacesConfigResourceProvider().getMetaInfConfigurationResources(null)) == null) {
                return false;
            }
            Iterator<URL> it = metaInfFacesConfigUrls.iterator();
            while (it.hasNext()) {
                URL next = it.next();
                if (!TomEEMyFacesContainerInitializer.isOwb(next)) continue;
                it.remove();
            }
            return !metaInfFacesConfigUrls.isEmpty();
        }
        catch (Exception e) {
            return false;
        }
    }

    public static boolean isOwb(URL url) {
        String jar = URLs.toFile((URL)url).getName();
        return jar.startsWith("openwebbeans-jsf-") || jar.startsWith("openwebbeans-el22-");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Object get(Class<?> clazz, Object facade) throws Exception {
        Field field = clazz.getDeclaredField("context");
        boolean acc = field.isAccessible();
        field.setAccessible(true);
        try {
            Object object = field.get(facade);
            return object;
        }
        finally {
            field.setAccessible(acc);
        }
    }
}

