/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.ra;

import jakarta.jms.BytesMessage;
import jakarta.jms.Destination;
import jakarta.jms.IllegalStateException;
import jakarta.jms.JMSException;
import jakarta.jms.MapMessage;
import jakarta.jms.Message;
import jakarta.jms.MessageConsumer;
import jakarta.jms.MessageListener;
import jakarta.jms.MessageProducer;
import jakarta.jms.ObjectMessage;
import jakarta.jms.Queue;
import jakarta.jms.QueueBrowser;
import jakarta.jms.QueueReceiver;
import jakarta.jms.QueueSender;
import jakarta.jms.QueueSession;
import jakarta.jms.Session;
import jakarta.jms.StreamMessage;
import jakarta.jms.TemporaryQueue;
import jakarta.jms.TemporaryTopic;
import jakarta.jms.TextMessage;
import jakarta.jms.Topic;
import jakarta.jms.TopicPublisher;
import jakarta.jms.TopicSession;
import jakarta.jms.TopicSubscriber;
import java.io.Serializable;
import org.apache.activemq.ActiveMQSession;
import org.apache.activemq.ra.ManagedConnectionProxy;
import org.apache.activemq.ra.ManagedTransactionContext;

public class ManagedSessionProxy
implements Session,
QueueSession,
TopicSession {
    private final ActiveMQSession session;
    private boolean closed;
    private ManagedConnectionProxy connectionProxy;

    public ManagedSessionProxy(ActiveMQSession session, ManagedConnectionProxy connectionProxy) {
        this.session = session;
        this.connectionProxy = connectionProxy;
    }

    public void setUseSharedTxContext(boolean enable) throws JMSException {
        if (this.session.getTransactionContext() != null) {
            ((ManagedTransactionContext)this.session.getTransactionContext()).setUseSharedTxContext(enable);
        }
    }

    public void close() throws JMSException {
        if (this.closed) {
            return;
        }
        this.cleanup();
        this.connectionProxy.sessionClosed(this);
    }

    public void cleanup() throws JMSException {
        this.closed = true;
        this.session.close();
    }

    private Session getSession() throws JMSException {
        if (this.closed) {
            throw new IllegalStateException("The Session is closed");
        }
        return this.session;
    }

    public void commit() throws JMSException {
        this.getSession().commit();
    }

    public QueueBrowser createBrowser(Queue queue) throws JMSException {
        return this.getSession().createBrowser(queue);
    }

    public QueueBrowser createBrowser(Queue queue, String messageSelector) throws JMSException {
        return this.getSession().createBrowser(queue, messageSelector);
    }

    public BytesMessage createBytesMessage() throws JMSException {
        return this.getSession().createBytesMessage();
    }

    public MessageConsumer createConsumer(Destination destination) throws JMSException {
        return this.getSession().createConsumer(destination);
    }

    public MessageConsumer createConsumer(Destination destination, String messageSelector) throws JMSException {
        return this.getSession().createConsumer(destination, messageSelector);
    }

    public MessageConsumer createConsumer(Destination destination, String messageSelector, boolean noLocal) throws JMSException {
        return this.getSession().createConsumer(destination, messageSelector, noLocal);
    }

    public TopicSubscriber createDurableSubscriber(Topic topic, String name) throws JMSException {
        return this.getSession().createDurableSubscriber(topic, name);
    }

    public TopicSubscriber createDurableSubscriber(Topic topic, String name, String messageSelector, boolean noLocal) throws JMSException {
        return this.getSession().createDurableSubscriber(topic, name, messageSelector, noLocal);
    }

    public MapMessage createMapMessage() throws JMSException {
        return this.getSession().createMapMessage();
    }

    public Message createMessage() throws JMSException {
        return this.getSession().createMessage();
    }

    public ObjectMessage createObjectMessage() throws JMSException {
        return this.getSession().createObjectMessage();
    }

    public ObjectMessage createObjectMessage(Serializable object) throws JMSException {
        return this.getSession().createObjectMessage(object);
    }

    public MessageProducer createProducer(Destination destination) throws JMSException {
        return this.getSession().createProducer(destination);
    }

    public Queue createQueue(String queueName) throws JMSException {
        return this.getSession().createQueue(queueName);
    }

    public StreamMessage createStreamMessage() throws JMSException {
        return this.getSession().createStreamMessage();
    }

    public TemporaryQueue createTemporaryQueue() throws JMSException {
        return this.getSession().createTemporaryQueue();
    }

    public TemporaryTopic createTemporaryTopic() throws JMSException {
        return this.getSession().createTemporaryTopic();
    }

    public TextMessage createTextMessage() throws JMSException {
        return this.getSession().createTextMessage();
    }

    public TextMessage createTextMessage(String text) throws JMSException {
        return this.getSession().createTextMessage(text);
    }

    public Topic createTopic(String topicName) throws JMSException {
        return this.getSession().createTopic(topicName);
    }

    public int getAcknowledgeMode() throws JMSException {
        return this.getSession().getAcknowledgeMode();
    }

    public MessageListener getMessageListener() throws JMSException {
        return this.getSession().getMessageListener();
    }

    public boolean getTransacted() throws JMSException {
        return this.getSession().getTransacted();
    }

    public void recover() throws JMSException {
        this.getSession().recover();
    }

    public void rollback() throws JMSException {
        this.getSession().rollback();
    }

    public void setMessageListener(MessageListener listener) throws JMSException {
        this.getSession().setMessageListener(listener);
    }

    public void unsubscribe(String name) throws JMSException {
        this.getSession().unsubscribe(name);
    }

    public QueueReceiver createReceiver(Queue queue) throws JMSException {
        return ((QueueSession)this.getSession()).createReceiver(queue);
    }

    public QueueReceiver createReceiver(Queue queue, String messageSelector) throws JMSException {
        return ((QueueSession)this.getSession()).createReceiver(queue, messageSelector);
    }

    public QueueSender createSender(Queue queue) throws JMSException {
        return ((QueueSession)this.getSession()).createSender(queue);
    }

    public TopicPublisher createPublisher(Topic topic) throws JMSException {
        return ((TopicSession)this.getSession()).createPublisher(topic);
    }

    public TopicSubscriber createSubscriber(Topic topic) throws JMSException {
        return ((TopicSession)this.getSession()).createSubscriber(topic);
    }

    public TopicSubscriber createSubscriber(Topic topic, String messageSelector, boolean noLocal) throws JMSException {
        return ((TopicSession)this.getSession()).createSubscriber(topic, messageSelector, noLocal);
    }

    public void run() {
        throw new RuntimeException("Operation not supported.");
    }

    public MessageConsumer createSharedConsumer(Topic topic, String sharedSubscriptionName) throws JMSException {
        throw new UnsupportedOperationException("createSharedConsumer(Topic, sharedSubscriptionName) is not supported");
    }

    public MessageConsumer createSharedConsumer(Topic topic, String sharedSubscriptionName, String messageSelector) throws JMSException {
        throw new UnsupportedOperationException("createSharedConsumer(Topic, sharedSubscriptionName, messageSelector) is not supported");
    }

    public MessageConsumer createDurableConsumer(Topic topic, String name) throws JMSException {
        throw new UnsupportedOperationException("createDurableConsumer(Topic, name) is not supported");
    }

    public MessageConsumer createDurableConsumer(Topic topic, String name, String messageSelector, boolean noLocal) throws JMSException {
        throw new UnsupportedOperationException("createDurableConsumer(Topic, name, messageSelector, noLocal) is not supported");
    }

    public MessageConsumer createSharedDurableConsumer(Topic topic, String name) throws JMSException {
        throw new UnsupportedOperationException("createSharedDurableConsumer(Topic, name) is not supported");
    }

    public MessageConsumer createSharedDurableConsumer(Topic topic, String name, String messageSelector) throws JMSException {
        throw new UnsupportedOperationException("createSharedDurableConsumer(Topic, name, messageSelector) is not supported");
    }

    public String toString() {
        return "ManagedSessionProxy { " + this.session + " }";
    }
}

