/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.renderkit.html_basic;

import com.sun.faces.renderkit.Attribute;
import com.sun.faces.renderkit.AttributeManager;
import com.sun.faces.renderkit.RenderKitUtils;
import com.sun.faces.renderkit.html_basic.HtmlBasicRenderer;
import jakarta.faces.application.FacesMessage;
import jakarta.faces.component.UIComponent;
import jakarta.faces.component.UIMessages;
import jakarta.faces.context.FacesContext;
import jakarta.faces.context.ResponseWriter;
import java.io.IOException;
import java.util.Iterator;

public class MessagesRenderer
extends HtmlBasicRenderer {
    private static final Attribute[] ATTRIBUTES = AttributeManager.getAttributes(AttributeManager.Key.MESSAGESMESSAGES);

    @Override
    public void encodeBegin(FacesContext context, UIComponent component) throws IOException {
        this.rendererParamsNotNull(context, component);
    }

    @Override
    public void encodeEnd(FacesContext context, UIComponent component) throws IOException {
        this.rendererParamsNotNull(context, component);
        if (!this.shouldEncode(component)) {
            return;
        }
        boolean mustRender = this.shouldWriteIdAttribute(component);
        UIMessages messages = (UIMessages)component;
        ResponseWriter writer = context.getResponseWriter();
        assert (writer != null);
        String clientId = ((UIMessages)component).getFor();
        if (clientId == null && messages.isGlobalOnly()) {
            clientId = "";
        }
        Iterator messageIter = this.getMessageIter(context, clientId, component);
        assert (messageIter != null);
        if (!messageIter.hasNext()) {
            if (mustRender) {
                if ("jakarta_faces_developmentstage_messages".equals(component.getId())) {
                    return;
                }
                writer.startElement("div", component);
                this.writeIdAttributeIfNecessary(context, writer, component);
                writer.endElement("div");
            }
            return;
        }
        String layout = (String)component.getAttributes().get("layout");
        boolean showSummary = messages.isShowSummary();
        boolean showDetail = messages.isShowDetail();
        String styleClass = (String)component.getAttributes().get("styleClass");
        boolean wroteTable = false;
        if (layout != null && layout.equals("table")) {
            writer.startElement("table", component);
            wroteTable = true;
        } else {
            writer.startElement("ul", component);
        }
        this.writeIdAttributeIfNecessary(context, writer, component);
        if (null != styleClass) {
            writer.writeAttribute("class", styleClass, "styleClass");
        }
        RenderKitUtils.renderPassThruAttributes(context, writer, component, ATTRIBUTES);
        while (messageIter.hasNext()) {
            Object val;
            FacesMessage curMessage = (FacesMessage)messageIter.next();
            if (curMessage.isRendered() && !messages.isRedisplay()) continue;
            curMessage.rendered();
            String severityStyle = null;
            String severityStyleClass = null;
            String summary = curMessage.getSummary();
            summary = null != summary ? summary : "";
            String detail = curMessage.getDetail();
            String string = detail = null != detail ? detail : summary;
            if (curMessage.getSeverity() == FacesMessage.SEVERITY_INFO) {
                severityStyle = (String)component.getAttributes().get("infoStyle");
                severityStyleClass = (String)component.getAttributes().get("infoClass");
            } else if (curMessage.getSeverity() == FacesMessage.SEVERITY_WARN) {
                severityStyle = (String)component.getAttributes().get("warnStyle");
                severityStyleClass = (String)component.getAttributes().get("warnClass");
            } else if (curMessage.getSeverity() == FacesMessage.SEVERITY_ERROR) {
                severityStyle = (String)component.getAttributes().get("errorStyle");
                severityStyleClass = (String)component.getAttributes().get("errorClass");
            } else if (curMessage.getSeverity() == FacesMessage.SEVERITY_FATAL) {
                severityStyle = (String)component.getAttributes().get("fatalStyle");
                severityStyleClass = (String)component.getAttributes().get("fatalClass");
            }
            if (wroteTable) {
                writer.startElement("tr", component);
            } else {
                writer.startElement("li", component);
            }
            if (severityStyle != null) {
                writer.writeAttribute("style", severityStyle, "style");
            }
            if (severityStyleClass != null) {
                styleClass = severityStyleClass;
                writer.writeAttribute("class", styleClass, "styleClass");
            }
            if (wroteTable) {
                writer.startElement("td", component);
            }
            boolean isTooltip = (val = component.getAttributes().get("tooltip")) != null && Boolean.valueOf(val.toString()) != false;
            boolean wroteTooltip = false;
            if (isTooltip) {
                writer.startElement("span", component);
                String title = (String)component.getAttributes().get("title");
                if (title == null || title.length() == 0) {
                    writer.writeAttribute("title", detail, "title");
                }
                writer.flush();
                writer.writeText("\t", component, null);
                wroteTooltip = true;
            }
            if (showSummary) {
                writer.writeText("\t", component, null);
                writer.writeText(summary, component, null);
                writer.writeText(" ", component, null);
            }
            if (showDetail) {
                writer.writeText(detail, component, null);
            }
            if (wroteTooltip) {
                writer.endElement("span");
            }
            if (wroteTable) {
                writer.endElement("td");
                writer.endElement("tr");
                continue;
            }
            writer.endElement("li");
        }
        if (wroteTable) {
            writer.endElement("table");
        } else {
            writer.endElement("ul");
        }
    }
}

