/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.application;

import com.sun.faces.config.WebConfiguration;
import com.sun.faces.flow.FlowDiscoveryCDIExtension;
import com.sun.faces.util.FacesLogger;
import com.sun.faces.util.Util;
import jakarta.enterprise.context.spi.Contextual;
import jakarta.enterprise.context.spi.CreationalContext;
import jakarta.enterprise.inject.spi.Bean;
import jakarta.enterprise.inject.spi.BeanManager;
import jakarta.enterprise.inject.spi.Producer;
import jakarta.faces.context.FacesContext;
import jakarta.faces.flow.Flow;
import jakarta.faces.flow.FlowHandler;
import jakarta.faces.flow.builder.FlowDefinition;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

class JavaFlowLoaderHelper {
    private static final Logger LOGGER = FacesLogger.APPLICATION.getLogger();

    JavaFlowLoaderHelper() {
    }

    synchronized void loadFlows(FacesContext context, FlowHandler flowHandler) throws IOException {
        BeanManager beanManager = Util.getCdiBeanManager(context);
        Bean extensionImpl = beanManager.resolve(beanManager.getBeans(FlowDiscoveryCDIExtension.class, new Annotation[0]));
        if (extensionImpl == null) {
            if (LOGGER.isLoggable(Level.SEVERE)) {
                LOGGER.log(Level.SEVERE, "Unable to obtain {0} from CDI implementation.  Flows described with {1} are unavailable.", new String[]{FlowDiscoveryCDIExtension.class.getName(), FlowDefinition.class.getName()});
            }
            return;
        }
        CreationalContext creationalContext = beanManager.createCreationalContext((Contextual)extensionImpl);
        FlowDiscoveryCDIExtension myExtension = (FlowDiscoveryCDIExtension)beanManager.getReference(extensionImpl, FlowDiscoveryCDIExtension.class, creationalContext);
        List<Producer<Flow>> flowProducers = myExtension.getFlowProducers();
        WebConfiguration config = WebConfiguration.getInstance();
        if (!flowProducers.isEmpty()) {
            this.enableClientWindowModeIfNecessary(context);
        }
        for (Producer<Flow> flowProducer : flowProducers) {
            Flow toAdd = (Flow)flowProducer.produce(beanManager.createCreationalContext(null));
            if (null == toAdd) {
                LOGGER.log(Level.SEVERE, "Flow producer method {0}() returned null.  Ignoring.", flowProducer.toString());
                continue;
            }
            flowHandler.addFlow(context, toAdd);
            config.setHasFlows(true);
        }
    }

    private void enableClientWindowModeIfNecessary(FacesContext context) {
        WebConfiguration config = WebConfiguration.getInstance(context.getExternalContext());
        String optionValue = config.getOptionValue(WebConfiguration.WebContextInitParameter.ClientWindowMode);
        boolean clientWindowNeedsEnabling = false;
        if ("none".equals(optionValue)) {
            clientWindowNeedsEnabling = true;
            LOGGER.log(Level.WARNING, "{0} was set to none, but Faces Flows requires {0} is enabled.  Setting to ''url''.", new Object[]{WebConfiguration.WebContextInitParameter.ClientWindowMode.getQualifiedName()});
        } else if (optionValue == null) {
            clientWindowNeedsEnabling = true;
        }
        if (clientWindowNeedsEnabling) {
            config.setOptionValue(WebConfiguration.WebContextInitParameter.ClientWindowMode, "url");
        }
    }
}

