/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jandex;

import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationValue;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.ClassType;
import org.jboss.jandex.DotName;
import org.jboss.jandex.Interned;
import org.jboss.jandex.ParameterizedType;
import org.jboss.jandex.Type;
import org.jboss.jandex.TypeVariable;
import org.jboss.jandex.Utils;

final class MethodInternal
implements Interned {
    static final MethodInternal[] EMPTY_ARRAY = new MethodInternal[0];
    static final NameAndParameterComponentComparator NAME_AND_PARAMETER_COMPONENT_COMPARATOR = new NameAndParameterComponentComparator();
    static final byte[][] EMPTY_PARAMETER_NAMES = new byte[0][];
    private byte[] name;
    private byte[][] parameterNames;
    private Type[] parameterTypes;
    private Type returnType;
    private Type[] exceptions;
    private Type receiverType;
    private Type[] typeParameters;
    private AnnotationInstance[] annotations;
    private AnnotationValue defaultValue;
    private short flags;
    private final Type[] descriptorParameterTypes;

    MethodInternal(byte[] name, byte[][] parameterNames, Type[] parameterTypes, Type returnType, short flags) {
        this(name, parameterNames, parameterTypes, returnType, flags, Type.EMPTY_ARRAY, Type.EMPTY_ARRAY);
    }

    MethodInternal(byte[] name, byte[][] parameterNames, Type[] parameterTypes, Type returnType, short flags, Type[] typeParameters, Type[] exceptions) {
        this(name, parameterNames, parameterTypes, returnType, flags, null, typeParameters, exceptions, AnnotationInstance.EMPTY_ARRAY, null);
    }

    MethodInternal(byte[] name, byte[][] parameterNames, Type[] parameterTypes, Type returnType, short flags, Type receiverType, Type[] typeParameters, Type[] exceptions, AnnotationInstance[] annotations, AnnotationValue defaultValue) {
        this.name = name;
        this.parameterNames = parameterNames;
        this.parameterTypes = parameterTypes.length == 0 ? Type.EMPTY_ARRAY : parameterTypes;
        this.returnType = returnType;
        this.flags = flags;
        this.annotations = annotations;
        this.exceptions = exceptions;
        this.typeParameters = typeParameters;
        this.receiverType = receiverType;
        this.defaultValue = defaultValue;
        this.descriptorParameterTypes = this.parameterTypes;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MethodInternal methodInternal = (MethodInternal)o;
        if (this.flags != methodInternal.flags) {
            return false;
        }
        if (!Arrays.equals(this.annotations, methodInternal.annotations)) {
            return false;
        }
        if (!Arrays.equals(this.exceptions, methodInternal.exceptions)) {
            return false;
        }
        if (!Arrays.equals(this.name, methodInternal.name)) {
            return false;
        }
        if (!Arrays.deepEquals((Object[])this.parameterNames, (Object[])methodInternal.parameterNames)) {
            return false;
        }
        if (!Arrays.equals(this.parameterTypes, methodInternal.parameterTypes)) {
            return false;
        }
        if (!Arrays.equals(this.descriptorParameterTypes, methodInternal.descriptorParameterTypes)) {
            return false;
        }
        if (this.receiverType != null ? !this.receiverType.equals(methodInternal.receiverType) : methodInternal.receiverType != null) {
            return false;
        }
        if (!this.returnType.equals(methodInternal.returnType)) {
            return false;
        }
        if (this.defaultValue != null ? !this.defaultValue.equals(methodInternal.defaultValue) : methodInternal.defaultValue != null) {
            return false;
        }
        return Arrays.equals(this.typeParameters, methodInternal.typeParameters);
    }

    public int hashCode() {
        int result = Arrays.hashCode(this.name);
        result = 31 * result + Arrays.deepHashCode((Object[])this.parameterNames);
        result = 31 * result + Arrays.hashCode(this.parameterTypes);
        result = 31 * result + Arrays.hashCode(this.descriptorParameterTypes);
        result = 31 * result + this.returnType.hashCode();
        result = 31 * result + Arrays.hashCode(this.exceptions);
        result = 31 * result + (this.receiverType != null ? this.receiverType.hashCode() : 0);
        result = 31 * result + Arrays.hashCode(this.typeParameters);
        result = 31 * result + Arrays.hashCode(this.annotations);
        result = 31 * result + this.flags;
        result = 31 * result + (this.defaultValue != null ? this.defaultValue.hashCode() : 0);
        return result;
    }

    @Override
    public boolean internEquals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MethodInternal methodInternal = (MethodInternal)o;
        if (this.flags != methodInternal.flags) {
            return false;
        }
        if (!Arrays.equals(this.annotations, methodInternal.annotations)) {
            return false;
        }
        if (!Interned.arrayEquals(this.exceptions, methodInternal.exceptions)) {
            return false;
        }
        if (!Arrays.equals(this.name, methodInternal.name)) {
            return false;
        }
        if (!Arrays.deepEquals((Object[])this.parameterNames, (Object[])methodInternal.parameterNames)) {
            return false;
        }
        if (!Interned.arrayEquals(this.parameterTypes, methodInternal.parameterTypes)) {
            return false;
        }
        if (!Interned.arrayEquals(this.descriptorParameterTypes, methodInternal.descriptorParameterTypes)) {
            return false;
        }
        if (this.receiverType != null ? !this.receiverType.internEquals(methodInternal.receiverType) : methodInternal.receiverType != null) {
            return false;
        }
        if (!this.returnType.internEquals(methodInternal.returnType)) {
            return false;
        }
        if (this.defaultValue != null ? !this.defaultValue.equals(methodInternal.defaultValue) : methodInternal.defaultValue != null) {
            return false;
        }
        return Interned.arrayEquals(this.typeParameters, methodInternal.typeParameters);
    }

    @Override
    public int internHashCode() {
        int result = Arrays.hashCode(this.name);
        result = 31 * result + Arrays.deepHashCode((Object[])this.parameterNames);
        result = 31 * result + Interned.arrayHashCode(this.parameterTypes);
        result = 31 * result + Interned.arrayHashCode(this.descriptorParameterTypes);
        result = 31 * result + this.returnType.internHashCode();
        result = 31 * result + Interned.arrayHashCode(this.exceptions);
        result = 31 * result + (this.receiverType != null ? this.receiverType.internHashCode() : 0);
        result = 31 * result + Interned.arrayHashCode(this.typeParameters);
        result = 31 * result + Arrays.hashCode(this.annotations);
        result = 31 * result + this.flags;
        result = 31 * result + (this.defaultValue != null ? this.defaultValue.hashCode() : 0);
        return result;
    }

    final String name() {
        return Utils.fromUTF8(this.name);
    }

    final int parametersCount() {
        return this.parameterTypes.length;
    }

    final String parameterName(int i) {
        if (i >= this.parameterNames.length) {
            return null;
        }
        return Utils.fromUTF8(this.parameterNames[i]);
    }

    final byte[] nameBytes() {
        return this.name;
    }

    final byte[][] parameterNamesBytes() {
        return this.parameterNames;
    }

    final Type[] copyParameterTypes() {
        return (Type[])this.parameterTypes.clone();
    }

    final Type[] parameterTypesArray() {
        return this.parameterTypes;
    }

    final Type[] copyExceptions() {
        return (Type[])this.exceptions.clone();
    }

    final List<Type> parameterTypes() {
        return Collections.unmodifiableList(Arrays.asList(this.parameterTypes));
    }

    final List<Type> descriptorParameterTypes() {
        return Collections.unmodifiableList(Arrays.asList(this.descriptorParameterTypes));
    }

    final Type[] descriptorParameterTypesArray() {
        return this.descriptorParameterTypes;
    }

    final Type returnType() {
        return this.returnType;
    }

    final Type receiverType(ClassInfo clazz) {
        if (this.receiverType != null) {
            return this.receiverType;
        }
        if (clazz.typeParameterArray().length > 0) {
            Type[] classTypeParameters = clazz.typeParameterArray();
            Type[] receiverTypeArguments = new Type[classTypeParameters.length];
            for (int i = 0; i < classTypeParameters.length; ++i) {
                receiverTypeArguments[i] = classTypeParameters[i].copyType(AnnotationInstance.EMPTY_ARRAY);
            }
            return new ParameterizedType(clazz.name(), receiverTypeArguments, null);
        }
        return new ClassType(clazz.name());
    }

    final Type receiverTypeField() {
        return this.receiverType;
    }

    final List<Type> exceptions() {
        return Collections.unmodifiableList(Arrays.asList(this.exceptions));
    }

    final Type[] exceptionArray() {
        return this.exceptions;
    }

    final List<TypeVariable> typeParameters() {
        List<Type> list = Arrays.asList(this.typeParameters);
        return Collections.unmodifiableList(list);
    }

    final List<AnnotationInstance> annotations() {
        return Collections.unmodifiableList(Arrays.asList(this.annotations));
    }

    final AnnotationInstance[] annotationArray() {
        return this.annotations;
    }

    final AnnotationInstance annotation(DotName name) {
        return AnnotationInstance.binarySearch(this.annotations, name);
    }

    final boolean hasAnnotation(DotName name) {
        return this.annotation(name) != null;
    }

    final Type[] typeParameterArray() {
        return this.typeParameters;
    }

    final AnnotationValue defaultValue() {
        return this.defaultValue;
    }

    final short flags() {
        return this.flags;
    }

    public String toString() {
        int i;
        StringBuilder builder = new StringBuilder();
        String name = this.name();
        builder.append(this.returnType.toString(true)).append(' ').append(name).append('(');
        if (this.receiverType != null) {
            builder.append(this.receiverType.toString(true)).append(" this");
            if (this.parameterTypes.length > 0) {
                builder.append(", ");
            }
        }
        for (i = 0; i < this.parameterTypes.length; ++i) {
            builder.append(this.parameterTypes[i].toString(true));
            String parameterName = this.parameterName(i);
            if (parameterName != null) {
                builder.append(' ');
                builder.append(parameterName);
            }
            if (i + 1 >= this.parameterTypes.length) continue;
            builder.append(", ");
        }
        builder.append(')');
        if (this.exceptions.length > 0) {
            builder.append(" throws ");
            for (i = 0; i < this.exceptions.length; ++i) {
                builder.append(this.exceptions[i].toString(true));
                if (i >= this.exceptions.length - 1) continue;
                builder.append(", ");
            }
        }
        return builder.toString();
    }

    void setTypeParameters(Type[] typeParameters) {
        if (typeParameters.length > 0) {
            this.typeParameters = typeParameters;
        }
    }

    void setParameterNames(byte[][] parameterNames) {
        this.parameterNames = parameterNames;
    }

    void setParameterTypes(Type[] parameterTypes) {
        this.parameterTypes = parameterTypes.length == 0 ? Type.EMPTY_ARRAY : parameterTypes;
    }

    void setReturnType(Type returnType) {
        this.returnType = returnType;
    }

    void setExceptions(Type[] exceptions) {
        this.exceptions = exceptions.length == 0 ? Type.EMPTY_ARRAY : exceptions;
    }

    void setReceiverType(Type receiverType) {
        this.receiverType = receiverType;
    }

    void setAnnotations(List<AnnotationInstance> annotations) {
        if (annotations.size() > 0) {
            this.annotations = annotations.toArray(new AnnotationInstance[annotations.size()]);
            Arrays.sort(this.annotations, AnnotationInstance.NAME_COMPARATOR);
        }
    }

    void setDefaultValue(AnnotationValue defaultValue) {
        this.defaultValue = defaultValue;
    }

    static class NameAndParameterComponentComparator
    implements Comparator<MethodInternal> {
        NameAndParameterComponentComparator() {
        }

        @Override
        private int compare(byte[] left, byte[] right) {
            int i = 0;
            for (int j = 0; i < left.length && j < right.length; ++i, ++j) {
                int a = left[i] & 0xFF;
                int b = right[j] & 0xFF;
                if (a == b) continue;
                return a - b;
            }
            return left.length - right.length;
        }

        @Override
        public int compare(MethodInternal instance, MethodInternal instance2) {
            int x = this.compare(instance.name, instance2.name);
            if (x != 0) {
                return x;
            }
            int min = Math.min(instance.parameterTypes.length, instance2.parameterTypes.length);
            for (int i = 0; i < min; ++i) {
                Type t1 = instance.parameterTypes[i];
                Type t2 = instance2.parameterTypes[i];
                x = t1.name().compareTo(t2.name());
                if (x == 0) continue;
                return x;
            }
            x = instance.parameterTypes.length - instance2.parameterTypes.length;
            if (x != 0) {
                return x;
            }
            return (instance.flags & 0x1040) - (instance2.flags & 0x1040);
        }
    }
}

