/*
 * Decompiled with CFR 0.152.
 */
package org.apache.yoko.rmi.util;

import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import org.apache.yoko.rmi.util.GenericMap;

public class DynamicHashMap
extends GenericMap
implements Map {
    private Entry[] table;
    private int range;
    private float ratio;

    private int index(int hash) {
        return (hash & 0x7FFFFFF) % this.range;
    }

    public DynamicHashMap() {
        this.clear();
    }

    public void clear() {
        this.range = 3;
        this.size = 0;
        this.ratio = 0.75f;
        this.table = new Entry[this.range];
    }

    public Object get(Object key) {
        int hash = this.keyHash(key);
        return this.get(hash, key);
    }

    public Object get(int hash, Object key) {
        int idx = this.index(hash);
        Entry ent = this.table[idx];
        while (ent != null) {
            if (ent.sameKey(hash, key)) {
                return ent.value;
            }
            ent = ent.next;
        }
        return null;
    }

    public boolean containsKey(Object key) {
        int hash = this.keyHash(key);
        return this.containsKey(hash, key);
    }

    public boolean containsKey(int hash, Object key) {
        int idx = this.index(hash);
        Entry ent = this.table[idx];
        while (ent != null) {
            if (ent.sameKey(hash, key)) {
                return true;
            }
            ent = ent.next;
        }
        return false;
    }

    public Object put(Object key, Object value) {
        int hash = this.keyHash(key);
        return this.put(hash, key, value);
    }

    public Object put(int hash, Object key, Object value) {
        int idx = this.index(hash);
        Entry ent = this.table[idx];
        while (ent != null) {
            if (ent.sameKey(hash, key)) {
                return ent.setValue(value);
            }
            ent = ent.next;
        }
        if (1.0f * (float)this.size / (float)this.range > this.ratio) {
            this.grow();
            idx = this.index(hash);
        }
        this.table[idx] = new Entry(hash, key, value, this.table[idx]);
        ++this.size;
        return null;
    }

    public Object remove(Object key) {
        int hash = this.keyHash(key);
        return this.remove(hash, key);
    }

    public Object remove(int hash, Object key) {
        int idx = this.index(hash);
        Entry entry = this.table[idx];
        if (entry != null) {
            if (entry.sameKey(hash, key)) {
                this.table[idx] = entry.next;
                --this.size;
                return entry.getValue();
            }
            Entry ahead = entry.next;
            while (ahead != null) {
                if (ahead.sameKey(hash, key)) {
                    entry.next = ahead.next;
                    --this.size;
                    return ahead.getValue();
                }
                entry = ahead;
                ahead = ahead.next;
            }
        }
        return null;
    }

    private void grow() {
        int old_range = this.range;
        Entry[] old_table = this.table;
        this.range = old_range * 2 + 1;
        this.table = new Entry[this.range];
        for (int i = 0; i < old_range; ++i) {
            Entry entry = old_table[i];
            while (entry != null) {
                Entry ahead = entry.next;
                int idx = this.index(entry.hash);
                entry.next = this.table[idx];
                this.table[idx] = entry;
                entry = ahead;
            }
        }
    }

    protected Iterator entryIterator() {
        return new EntryIterator();
    }

    final class EntryIterator
    implements Iterator {
        int idx = 0;
        Entry entry;

        EntryIterator() {
            this.entry = DynamicHashMap.this.table[0];
            this.locateNext();
        }

        private void locateNext() {
            while (this.entry == null) {
                ++this.idx;
                if (this.idx == DynamicHashMap.this.range) {
                    return;
                }
                this.entry = DynamicHashMap.this.table[this.idx];
            }
        }

        public boolean hasNext() {
            return this.entry != null;
        }

        public Object next() {
            Entry result = this.entry;
            if (result == null) {
                throw new NoSuchElementException();
            }
            this.entry = this.entry.next;
            this.locateNext();
            return result;
        }

        public void remove() {
            Entry remove = this.entry;
            this.entry = this.entry.next;
            this.locateNext();
            DynamicHashMap.this.remove(remove.key);
        }
    }

    class Entry
    extends GenericMap.Entry {
        Entry next;
        int hash;
        Object key;
        Object value;

        Entry(int hash, Object key, Object value, Entry next) {
            super(DynamicHashMap.this);
            this.hash = hash;
            this.key = key;
            this.value = value;
            this.next = next;
        }

        public Object getKey() {
            return this.key;
        }

        public Object getValue() {
            return this.value;
        }

        public Object setValue(Object value) {
            Object result = this.value;
            this.value = value;
            return result;
        }

        boolean sameKey(int hash, Object key) {
            return this.hash == hash && DynamicHashMap.this.keyEquals(this.key, key);
        }
    }
}

