/*
 * Decompiled with CFR 0.152.
 */
package org.apache.yoko.rmi.impl;

import java.io.Externalizable;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.util.Date;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.rmi.CORBA.ClassDesc;
import org.apache.yoko.rmi.impl.AbstractObjectDescriptor;
import org.apache.yoko.rmi.impl.AnyDescriptor;
import org.apache.yoko.rmi.impl.ArrayDescriptor;
import org.apache.yoko.rmi.impl.BooleanDescriptor;
import org.apache.yoko.rmi.impl.ByteDescriptor;
import org.apache.yoko.rmi.impl.CharDescriptor;
import org.apache.yoko.rmi.impl.ClassDescriptor;
import org.apache.yoko.rmi.impl.DateValueDescriptor;
import org.apache.yoko.rmi.impl.DoubleDescriptor;
import org.apache.yoko.rmi.impl.ExceptionDescriptor;
import org.apache.yoko.rmi.impl.FVDValueDescriptor;
import org.apache.yoko.rmi.impl.FloatDescriptor;
import org.apache.yoko.rmi.impl.IDLEntityDescriptor;
import org.apache.yoko.rmi.impl.IntegerDescriptor;
import org.apache.yoko.rmi.impl.LongDescriptor;
import org.apache.yoko.rmi.impl.RemoteClassDescriptor;
import org.apache.yoko.rmi.impl.RemoteDescriptor;
import org.apache.yoko.rmi.impl.RemoteInterfaceDescriptor;
import org.apache.yoko.rmi.impl.ShortDescriptor;
import org.apache.yoko.rmi.impl.SimpleDescriptor;
import org.apache.yoko.rmi.impl.StringDescriptor;
import org.apache.yoko.rmi.impl.TypeDescriptor;
import org.apache.yoko.rmi.impl.ValueDescriptor;
import org.apache.yoko.rmi.impl.VoidDescriptor;
import org.apache.yoko.rmi.util.ByteBuffer;
import org.apache.yoko.rmi.util.ByteString;
import org.omg.CORBA.MARSHAL;
import org.omg.CORBA.ORB;
import org.omg.CORBA.Object;
import org.omg.CORBA.ValueDefPackage.FullValueDescription;
import org.omg.CORBA.portable.IDLEntity;
import org.omg.SendingContext.CodeBase;
import org.omg.SendingContext.CodeBaseHelper;
import org.omg.SendingContext.RunTime;

public class TypeRepository {
    static final Logger logger;
    ORB orb;
    Map<Class, TypeDescriptor> classMap = new ConcurrentHashMap<Class, TypeDescriptor>();
    Map<String, TypeDescriptor> repidMap = new ConcurrentHashMap<String, TypeDescriptor>();
    SimpleDescriptor boolean_descriptor = new BooleanDescriptor(this);
    SimpleDescriptor byte_descriptor = new ByteDescriptor(this);
    SimpleDescriptor char_descriptor = new CharDescriptor(this);
    SimpleDescriptor short_descriptor = new ShortDescriptor(this);
    SimpleDescriptor int_descriptor = new IntegerDescriptor(this);
    SimpleDescriptor long_descriptor = new LongDescriptor(this);
    SimpleDescriptor float_descriptor = new FloatDescriptor(this);
    SimpleDescriptor double_descriptor = new DoubleDescriptor(this);
    SimpleDescriptor void_descriptor = new VoidDescriptor(this);
    static final Class REMOTE_EXCEPTION;
    static final Set<ByteString> keyWords;
    static final ByteString[] reservedPostfixes;

    public TypeRepository(ORB orb) {
        this.orb = orb;
        TypeDescriptor desc = new AnyDescriptor(java.lang.Object.class, this);
        this.classMap.put(java.lang.Object.class, desc);
        desc.init();
        this.repidMap.put(desc.getRepositoryID(), desc);
        desc = new AnyDescriptor(java.lang.Object.class, this);
        this.classMap.put(java.lang.Object.class, desc);
        desc.init();
        this.repidMap.put(desc.getRepositoryID(), desc);
        desc = new StringDescriptor(this);
        this.classMap.put(String.class, desc);
        desc.init();
        this.repidMap.put(desc.getRepositoryID(), desc);
        desc = new ClassDescriptor(this);
        this.classMap.put(Class.class, desc);
        this.classMap.put(ClassDesc.class, desc);
        desc.init();
        this.repidMap.put(desc.getRepositoryID(), desc);
        desc = new DateValueDescriptor(this);
        this.classMap.put(Date.class, desc);
        desc.init();
        this.repidMap.put(desc.getRepositoryID(), desc);
        desc = new AnyDescriptor(Externalizable.class, this);
        this.classMap.put(Externalizable.class, desc);
        desc.init();
        this.repidMap.put(desc.getRepositoryID(), desc);
        desc = new AnyDescriptor(Serializable.class, this);
        this.classMap.put(Serializable.class, desc);
        desc.init();
        this.repidMap.put(desc.getRepositoryID(), desc);
        desc = new AnyDescriptor(Remote.class, this);
        this.classMap.put(Remote.class, desc);
        desc.init();
        this.repidMap.put(desc.getRepositoryID(), desc);
    }

    ORB getORB() {
        return this.orb;
    }

    public String getRepositoryID(Class type) {
        return this.getDescriptor(type).getRepositoryID();
    }

    public RemoteInterfaceDescriptor getRemoteDescriptor(Class type) {
        TypeDescriptor td = this.getDescriptor(type);
        RemoteInterfaceDescriptor result = td.getRemoteInterface();
        if (result != null) {
            return result;
        }
        if (!Remote.class.isAssignableFrom(type)) {
            throw new IllegalArgumentException("class " + type.toString() + " does not implement" + " java.rmi.Remote");
        }
        RemoteDescriptor desc = type.isInterface() ? new RemoteInterfaceDescriptor(type, this) : new RemoteClassDescriptor(type, this);
        desc.init();
        result = desc.getRemoteInterface();
        td.setRemoteInterface(result);
        return result;
    }

    public TypeDescriptor getDescriptor(Class type) {
        logger.fine("Requesting type descriptor for class " + type.getName());
        TypeDescriptor desc = this.classMap.get(type);
        if (desc != null) {
            return desc.getSelf();
        }
        if (IDLEntity.class.isAssignableFrom(type) && this.isIDLEntity(type)) {
            IDLEntityDescriptor idlDesc = new IDLEntityDescriptor(type, this);
            desc = idlDesc;
            this.classMap.put(type, desc);
            idlDesc.initIDL();
        } else if (Throwable.class.isAssignableFrom(type)) {
            desc = new ExceptionDescriptor(type, this);
            this.classMap.put(type, desc);
            desc.init();
            this.repidMap.put(desc.getRepositoryID(), desc);
        } else if (type.isArray()) {
            desc = ArrayDescriptor.get(type, this);
            this.classMap.put(type, desc);
            desc.init();
            this.repidMap.put(desc.getRepositoryID(), desc);
        } else if (!type.isInterface() && Serializable.class.isAssignableFrom(type)) {
            desc = new ValueDescriptor(type, this);
            this.classMap.put(type, desc);
            desc.init();
            this.repidMap.put(desc.getRepositoryID(), desc);
        } else if (Remote.class.isAssignableFrom(type)) {
            desc = type.isInterface() ? new RemoteInterfaceDescriptor(type, this) : new RemoteClassDescriptor(type, this);
            this.classMap.put(type, desc);
            desc.init();
            this.repidMap.put(desc.getRepositoryID(), desc);
        } else if (type.isPrimitive()) {
            desc = this.getSimpleDescriptor(type);
            this.classMap.put(type, desc);
            this.repidMap.put(desc.getRepositoryID(), desc);
        } else if (java.lang.Object.class.isAssignableFrom(type)) {
            if (this.isAbstractInterface(type)) {
                logger.finer("encoding " + type + " as abstract interface");
                desc = new AbstractObjectDescriptor(type, this);
            } else {
                logger.finer("encoding " + type + " as a abstract value");
                desc = new ValueDescriptor(type, this);
            }
            this.classMap.put(type, desc);
            desc.init();
            this.repidMap.put(desc.getRepositoryID(), desc);
        } else {
            throw new RuntimeException("cannot handle class " + type.getName());
        }
        logger.fine("Class " + type.getName() + " resolves to " + desc.getClass().getName());
        return desc;
    }

    private boolean isIDLEntity(Class type) {
        Class<?>[] supers = type.getInterfaces();
        for (int i = 0; supers != null && i < supers.length; ++i) {
            if (!supers[i].equals(IDLEntity.class)) continue;
            return true;
        }
        return false;
    }

    SimpleDescriptor getSimpleDescriptor(Class type) {
        if (type == Boolean.TYPE) {
            return this.boolean_descriptor;
        }
        if (type == Byte.TYPE) {
            return this.byte_descriptor;
        }
        if (type == Short.TYPE) {
            return this.short_descriptor;
        }
        if (type == Character.TYPE) {
            return this.char_descriptor;
        }
        if (type == Integer.TYPE) {
            return this.int_descriptor;
        }
        if (type == Long.TYPE) {
            return this.long_descriptor;
        }
        if (type == Float.TYPE) {
            return this.float_descriptor;
        }
        if (type == Double.TYPE) {
            return this.double_descriptor;
        }
        if (type == Void.TYPE) {
            return this.void_descriptor;
        }
        if (!type.isPrimitive()) {
            throw new IllegalArgumentException("Cannot resolve simple descriptor for primitive types");
        }
        throw new RuntimeException("internal error: " + type);
    }

    boolean isAbstractInterface(Class type) {
        Method[] methods;
        Class<?>[] interfaces;
        if (!type.isInterface()) {
            return false;
        }
        for (Class<?> anInterface : interfaces = type.getInterfaces()) {
            if (this.isAbstractInterface(anInterface)) continue;
            return false;
        }
        for (Method method : methods = type.getDeclaredMethods()) {
            if (this.isRemoteMethod(method)) continue;
            return false;
        }
        return true;
    }

    boolean isRemoteMethod(Method m) {
        Class<?>[] ex;
        for (Class<?> anEx : ex = m.getExceptionTypes()) {
            if (!anEx.isAssignableFrom(REMOTE_EXCEPTION)) continue;
            return true;
        }
        return false;
    }

    public ValueDescriptor getDescriptor(Class clz, String repid, RunTime runtime) throws ClassNotFoundException {
        if (repid == null) {
            return (ValueDescriptor)this.getDescriptor(clz);
        }
        ValueDescriptor clzdesc = (ValueDescriptor)this.repidMap.get(repid);
        if (clzdesc != null) {
            return clzdesc;
        }
        if (clz != null) {
            logger.fine("Requesting type descriptor for class " + clz.getName() + " with repid " + repid);
            if (clz.isArray()) {
                ArrayDescriptor desc = ArrayDescriptor.get(clz, this);
                this.classMap.put(clz, desc);
                desc.init();
                this.repidMap.put(((ValueDescriptor)desc).getRepositoryID(), desc);
                return desc;
            }
            clzdesc = (ValueDescriptor)this.getDescriptor(clz);
            String localID = clzdesc.getRepositoryID();
            if (repid.equals(localID)) {
                return clzdesc;
            }
        }
        logger.fine("Requesting type descriptor for repid " + repid);
        CodeBase codebase = CodeBaseHelper.narrow((Object)runtime);
        if (codebase == null) {
            throw new MARSHAL("cannot locate RunTime CodeBase");
        }
        FullValueDescription fvd = codebase.meta(repid);
        ValueDescriptor super_desc = null;
        if (!"".equals(fvd.base_value)) {
            super_desc = this.getDescriptor(clz == null ? null : clz.getSuperclass(), fvd.base_value, (RunTime)codebase);
        }
        clzdesc = new FVDValueDescriptor(fvd, clz, this, repid, super_desc);
        this.repidMap.put(repid, clzdesc);
        return clzdesc;
    }

    public static String idToClass(String repid) {
        logger.finer("idToClass " + repid);
        if (repid.startsWith("IDL:")) {
            ByteString id = new ByteString(repid);
            try {
                int end = id.lastIndexOf(':');
                ByteString s = end < 0 ? id.substring(4) : id.substring(4, end);
                ByteBuffer bb = new ByteBuffer();
                int firstSlash = s.indexOf('/');
                if (firstSlash > 0) {
                    ByteString prefix = s.substring(0, firstSlash);
                    ByteString[] elems = prefix.split('.');
                    for (int i = elems.length - 1; i >= 0; --i) {
                        bb.append(TypeRepository.fixName(elems[i]));
                        bb.append('.');
                    }
                    s = s.substring(firstSlash + 1);
                }
                ByteString[] elems = s.split('/');
                for (int i = 0; i < elems.length; ++i) {
                    bb.append(TypeRepository.fixName(elems[i]));
                    if (i == elems.length - 1) continue;
                    bb.append('.');
                }
                String result = bb.toString();
                logger.finer("idToClassName " + repid + " => " + result);
                return result;
            }
            catch (IndexOutOfBoundsException ex) {
                logger.log(Level.FINE, "idToClass " + ex.getMessage(), ex);
                return null;
            }
        }
        if (repid.startsWith("RMI:")) {
            int end = repid.indexOf(58, 4);
            return end < 0 ? repid.substring(4) : repid.substring(4, end);
        }
        return null;
    }

    static String fixName(String name) {
        return new ByteString(name).toString();
    }

    static ByteString fixName(ByteString name) {
        if (keyWords.contains(name)) {
            ByteBuffer buf = new ByteBuffer();
            buf.append('_');
            buf.append(name);
            return buf.toByteString();
        }
        ByteString result = name;
        ByteString current = name;
        boolean match = true;
        block0: while (match) {
            int len = current.length();
            match = false;
            for (ByteString reservedPostfixe : reservedPostfixes) {
                if (!current.endsWith(reservedPostfixe)) continue;
                ByteBuffer buf = new ByteBuffer();
                buf.append('_');
                buf.append(result);
                result = buf.toByteString();
                int resultLen = reservedPostfixe.length();
                current = len > resultLen ? current.substring(0, len - resultLen) : new ByteString("");
                match = true;
                continue block0;
            }
        }
        return name;
    }

    static {
        String[] words;
        logger = Logger.getLogger(TypeRepository.class.getName());
        REMOTE_EXCEPTION = RemoteException.class;
        keyWords = new HashSet<ByteString>();
        reservedPostfixes = new ByteString[]{new ByteString("Helper"), new ByteString("Holder"), new ByteString("Operations"), new ByteString("POA"), new ByteString("POATie"), new ByteString("Package"), new ByteString("ValueFactory")};
        for (String word : words = new String[]{"abstract", "boolean", "break", "byte", "case", "catch", "char", "class", "clone", "const", "continue", "default", "do", "double", "else", "equals", "extends", "false", "final", "finalize", "finally", "float", "for", "getClass", "goto", "hashCode", "if", "implements", "import", "instanceof", "int", "interface", "long", "native", "new", "notify", "notifyAll", "null", "package", "private", "protected", "public", "return", "short", "static", "super", "switch", "synchronized", "this", "throw", "throws", "toString", "transient", "true", "try", "void", "volatile", "wait", "while"}) {
            keyWords.add(new ByteString(word));
        }
    }
}

