/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bcel.generic;

import java.io.DataOutputStream;
import java.io.IOException;
import org.apache.bcel.ExceptionConstants;
import org.apache.bcel.classfile.Constant;
import org.apache.bcel.classfile.ConstantFloat;
import org.apache.bcel.classfile.ConstantInteger;
import org.apache.bcel.classfile.ConstantString;
import org.apache.bcel.classfile.ConstantUtf8;
import org.apache.bcel.generic.CPInstruction;
import org.apache.bcel.generic.ConstantPoolGen;
import org.apache.bcel.generic.ExceptionThrower;
import org.apache.bcel.generic.PushInstruction;
import org.apache.bcel.generic.Type;
import org.apache.bcel.generic.TypedInstruction;
import org.apache.bcel.generic.Visitor;
import org.apache.bcel.util.ByteSequence;

public class LDC
extends CPInstruction
implements PushInstruction,
ExceptionThrower,
TypedInstruction {
    LDC() {
    }

    public LDC(int index) {
        super((short)19, index);
        this.setSize();
    }

    protected final void setSize() {
        if (this.index <= 255) {
            this.opcode = (short)18;
            this.length = (short)2;
        } else {
            this.opcode = (short)19;
            this.length = (short)3;
        }
    }

    public void dump(DataOutputStream out) throws IOException {
        out.writeByte(this.opcode);
        if (this.length == 2) {
            out.writeByte(this.index);
        } else {
            out.writeShort(this.index);
        }
    }

    public final void setIndex(int index) {
        super.setIndex(index);
        this.setSize();
    }

    protected void initFromFile(ByteSequence bytes, boolean wide) throws IOException {
        this.length = (short)2;
        this.index = bytes.readUnsignedByte();
    }

    public Object getValue(ConstantPoolGen cpg) {
        Constant c = cpg.getConstantPool().getConstant(this.index);
        switch (c.getTag()) {
            case 8: {
                int i = ((ConstantString)c).getStringIndex();
                c = cpg.getConstantPool().getConstant(i);
                return ((ConstantUtf8)c).getBytes();
            }
            case 4: {
                return new Float(((ConstantFloat)c).getBytes());
            }
            case 3: {
                return new Integer(((ConstantInteger)c).getBytes());
            }
            case 7: {
                return c;
            }
        }
        throw new RuntimeException("Unknown or invalid constant type at " + this.index);
    }

    public Type getType(ConstantPoolGen cpg) {
        switch (cpg.getConstantPool().getConstant(this.index).getTag()) {
            case 8: {
                return Type.STRING;
            }
            case 4: {
                return Type.FLOAT;
            }
            case 3: {
                return Type.INT;
            }
            case 7: {
                return Type.CLASS;
            }
        }
        throw new RuntimeException("Unknown or invalid constant type at " + this.index);
    }

    public Class[] getExceptions() {
        return ExceptionConstants.EXCS_STRING_RESOLUTION;
    }

    public void accept(Visitor v) {
        v.visitStackProducer(this);
        v.visitPushInstruction(this);
        v.visitExceptionThrower(this);
        v.visitTypedInstruction(this);
        v.visitCPInstruction(this);
        v.visitLDC(this);
    }
}

