/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.config.configprovider;

import com.sun.faces.config.WebConfiguration;
import com.sun.faces.spi.ConfigurationResourceProvider;
import com.sun.faces.util.FacesLogger;
import com.sun.faces.util.Util;
import jakarta.faces.FacesException;
import jakarta.servlet.ServletContext;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class BaseWebConfigResourceProvider
implements ConfigurationResourceProvider {
    private static final Logger LOGGER = FacesLogger.CONFIG.getLogger();

    @Override
    public Collection<URI> getResources(ServletContext context) {
        WebConfiguration webConfig = WebConfiguration.getInstance(context);
        String paths = webConfig.getOptionValue(this.getParameter());
        LinkedHashSet<URI> urls = new LinkedHashSet<URI>(6);
        if (paths != null) {
            for (String token : Util.split(context, paths.trim(), this.getSeparatorRegex())) {
                String path = token.trim();
                if (this.isExcluded(path) || path.length() == 0) continue;
                URI u = this.getContextURLForPath(context, path);
                if (u != null) {
                    urls.add(u);
                    continue;
                }
                if (!LOGGER.isLoggable(Level.WARNING)) continue;
                LOGGER.log(Level.WARNING, "jsf.config.web_resource_not_found", new Object[]{path, WebConfiguration.WebContextInitParameter.JakartaFacesConfigFiles.getQualifiedName()});
            }
        }
        return urls;
    }

    protected abstract WebConfiguration.WebContextInitParameter getParameter();

    protected abstract String[] getExcludedResources();

    protected abstract String getSeparatorRegex();

    protected URI getContextURLForPath(ServletContext context, String path) {
        try {
            URL url = context.getResource(path);
            if (url != null) {
                return new URI(url.toExternalForm().replaceAll(" ", "%20"));
            }
        }
        catch (MalformedURLException | URISyntaxException mue) {
            throw new FacesException(mue);
        }
        return null;
    }

    protected boolean isExcluded(String path) {
        return Arrays.binarySearch(this.getExcludedResources(), path) >= 0;
    }
}

