/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.health;

import io.smallrye.common.annotation.Experimental;
import io.smallrye.config.SmallRyeConfig;
import io.smallrye.health.AsyncHealthCheckFactory;
import io.smallrye.health.HealthLogging;
import io.smallrye.health.SmallRyeHealth;
import io.smallrye.health.api.AsyncHealthCheck;
import io.smallrye.health.api.HealthGroup;
import io.smallrye.health.api.HealthType;
import io.smallrye.health.api.Wellness;
import io.smallrye.health.registry.HealthRegistries;
import io.smallrye.health.registry.HealthRegistryImpl;
import io.smallrye.mutiny.Uni;
import jakarta.annotation.PostConstruct;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.enterprise.context.spi.Contextual;
import jakarta.enterprise.inject.Any;
import jakarta.enterprise.inject.Instance;
import jakarta.enterprise.inject.spi.Bean;
import jakarta.enterprise.inject.spi.BeanManager;
import jakarta.inject.Inject;
import jakarta.json.JsonArray;
import jakarta.json.JsonArrayBuilder;
import jakarta.json.JsonObject;
import jakarta.json.JsonObjectBuilder;
import jakarta.json.JsonValue;
import jakarta.json.JsonWriter;
import jakarta.json.JsonWriterFactory;
import jakarta.json.spi.JsonProvider;
import java.io.OutputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import org.eclipse.microprofile.config.Config;
import org.eclipse.microprofile.config.ConfigProvider;
import org.eclipse.microprofile.health.HealthCheck;
import org.eclipse.microprofile.health.HealthCheckResponse;
import org.eclipse.microprofile.health.Liveness;
import org.eclipse.microprofile.health.Readiness;
import org.eclipse.microprofile.health.Startup;

@ApplicationScoped
public class SmallRyeHealthReporter {
    private static final Map<String, ?> JSON_CONFIG = Collections.singletonMap("jakarta.json.stream.JsonGenerator.prettyPrinting", true);
    @Inject
    @Liveness
    Instance<HealthCheck> livenessChecks;
    @Inject
    @Readiness
    Instance<HealthCheck> readinessChecks;
    @Inject
    @Wellness
    Instance<HealthCheck> wellnessChecks;
    @Inject
    @Startup
    Instance<HealthCheck> startupChecks;
    @Inject
    @Any
    Instance<HealthCheck> allHealthChecks;
    @Inject
    @Liveness
    Instance<AsyncHealthCheck> asyncLivenessChecks;
    @Inject
    @Readiness
    Instance<AsyncHealthCheck> asyncReadinessChecks;
    @Inject
    @Wellness
    Instance<AsyncHealthCheck> asyncWellnessChecks;
    @Inject
    @Startup
    Instance<AsyncHealthCheck> asyncStartupChecks;
    @Inject
    @Any
    Instance<AsyncHealthCheck> allAsyncHealthChecks;
    @Inject
    BeanManager beanManager;
    HealthRegistryImpl livenessHealthRegistry = (HealthRegistryImpl)HealthRegistries.getRegistry(HealthType.LIVENESS);
    HealthRegistryImpl readinessHealthRegistry = (HealthRegistryImpl)HealthRegistries.getRegistry(HealthType.READINESS);
    HealthRegistryImpl wellnessHealthRegistry = (HealthRegistryImpl)HealthRegistries.getRegistry(HealthType.WELLNESS);
    HealthRegistryImpl startupHealthRegistry = (HealthRegistryImpl)HealthRegistries.getRegistry(HealthType.STARTUP);
    boolean contextPropagated = false;
    String emptyChecksOutcome = "UP";
    int timeoutSeconds = 60;
    Map<String, String> additionalProperties = new ConcurrentHashMap<String, String>();
    Map<String, Boolean> healthChecksConfigs = new ConcurrentHashMap<String, Boolean>();
    boolean delayHealthCheckInit = false;
    String defaultHealthGroup = null;
    @Inject
    AsyncHealthCheckFactory asyncHealthCheckFactory;
    private final Map<String, Uni<HealthCheckResponse>> additionalChecks = new HashMap<String, Uni<HealthCheckResponse>>();
    private final JsonProvider jsonProvider = JsonProvider.provider();
    private boolean checksInitialized = false;
    private Uni<SmallRyeHealth> smallRyeHealthUni = null;
    private Uni<SmallRyeHealth> smallRyeLivenessUni = null;
    private Uni<SmallRyeHealth> smallRyeReadinessUni = null;
    private Uni<SmallRyeHealth> smallryeWellnessUni = null;
    private Uni<SmallRyeHealth> smallryeStartupUni = null;
    private boolean additionalListsChanged = false;
    private List<Uni<HealthCheckResponse>> livenessUnis = new CopyOnWriteArrayList<Uni<HealthCheckResponse>>();
    private List<Uni<HealthCheckResponse>> readinessUnis = new CopyOnWriteArrayList<Uni<HealthCheckResponse>>();
    private List<Uni<HealthCheckResponse>> wellnessUnis = new CopyOnWriteArrayList<Uni<HealthCheckResponse>>();
    private List<Uni<HealthCheckResponse>> startupUnis = new CopyOnWriteArrayList<Uni<HealthCheckResponse>>();

    public SmallRyeHealthReporter() {
        try {
            Config config = ConfigProvider.getConfig();
            this.contextPropagated = config.getOptionalValue("io.smallrye.health.context.propagation", Boolean.class).orElse(false);
            this.emptyChecksOutcome = config.getOptionalValue("io.smallrye.health.emptyChecksOutcome", String.class).orElse("UP");
            this.timeoutSeconds = config.getOptionalValue("io.smallrye.health.timeout.seconds", Integer.class).orElse(60);
            this.additionalProperties = ((SmallRyeConfig)config).getOptionalValues("io.smallrye.health.additional.property", String.class, String.class).orElse(new ConcurrentHashMap());
            this.delayHealthCheckInit = config.getOptionalValue("io.smallrye.health.delayChecksInitializations", Boolean.class).orElse(false);
            this.defaultHealthGroup = config.getOptionalValue("io.smallrye.health.defaultHealthGroup", String.class).orElse(null);
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        if (this.asyncHealthCheckFactory == null) {
            this.asyncHealthCheckFactory = new AsyncHealthCheckFactory();
        }
    }

    @PostConstruct
    public void postConstruct() {
        if (!this.delayHealthCheckInit) {
            this.initChecks();
        }
    }

    private void initChecks() {
        this.initUnis(this.livenessUnis, (Iterable<HealthCheck>)this.livenessChecks, (Iterable<AsyncHealthCheck>)this.asyncLivenessChecks);
        this.initUnis(this.readinessUnis, (Iterable<HealthCheck>)this.readinessChecks, (Iterable<AsyncHealthCheck>)this.asyncReadinessChecks);
        this.initUnis(this.wellnessUnis, (Iterable<HealthCheck>)this.wellnessChecks, (Iterable<AsyncHealthCheck>)this.asyncWellnessChecks);
        this.initUnis(this.startupUnis, (Iterable<HealthCheck>)this.startupChecks, (Iterable<AsyncHealthCheck>)this.asyncStartupChecks);
        this.checksInitialized = true;
    }

    private void initUnis(List<Uni<HealthCheckResponse>> list, Iterable<HealthCheck> checks, Iterable<AsyncHealthCheck> asyncChecks) {
        if (checks != null) {
            for (HealthCheck check : checks) {
                if (check == null || !this.isHealthCheckEnabled(check)) continue;
                list.add(this.asyncHealthCheckFactory.callSync(check));
            }
        }
        if (asyncChecks != null) {
            for (AsyncHealthCheck asyncCheck : asyncChecks) {
                if (asyncCheck == null || !this.isHealthCheckEnabled(asyncCheck)) continue;
                list.add(this.asyncHealthCheckFactory.callAsync(asyncCheck));
            }
        }
    }

    public void reportHealth(OutputStream out, SmallRyeHealth health) {
        if (health.isDown() && HealthLogging.logger.isInfoEnabled()) {
            HealthLogging.logger.healthDownStatus(health.getPayload().toString());
        }
        JsonWriterFactory factory = this.jsonProvider.createWriterFactory(JSON_CONFIG);
        JsonWriter writer = factory.createWriter(out);
        writer.writeObject(health.getPayload());
        writer.close();
    }

    public SmallRyeHealth getHealth() {
        return (SmallRyeHealth)this.getHealthAsync().await().atMost(Duration.ofSeconds(this.timeoutSeconds));
    }

    public SmallRyeHealth getLiveness() {
        return (SmallRyeHealth)this.getLivenessAsync().await().atMost(Duration.ofSeconds(this.timeoutSeconds));
    }

    public SmallRyeHealth getReadiness() {
        return (SmallRyeHealth)this.getReadinessAsync().await().atMost(Duration.ofSeconds(this.timeoutSeconds));
    }

    public SmallRyeHealth getStartup() {
        return (SmallRyeHealth)this.getStartupAsync().await().atMost(Duration.ofSeconds(this.timeoutSeconds));
    }

    @Experimental(value="Wellness experimental checks")
    public SmallRyeHealth getWellness() {
        return (SmallRyeHealth)this.getWellnessAsync().await().atMost(Duration.ofSeconds(this.timeoutSeconds));
    }

    public SmallRyeHealth getHealthGroup(String groupName) {
        return (SmallRyeHealth)this.getHealthGroupAsync(groupName).await().atMost(Duration.ofSeconds(this.timeoutSeconds));
    }

    public SmallRyeHealth getHealthGroups() {
        return (SmallRyeHealth)this.getHealthGroupsAsync().await().atMost(Duration.ofSeconds(this.timeoutSeconds));
    }

    @Experimental(value="Asynchronous Health Check procedures")
    public Uni<SmallRyeHealth> getHealthAsync() {
        this.smallRyeHealthUni = this.getHealthAsync(this.smallRyeHealthUni, HealthType.LIVENESS, HealthType.READINESS, HealthType.WELLNESS, HealthType.STARTUP);
        return this.smallRyeHealthUni;
    }

    @Experimental(value="Asynchronous Health Check procedures")
    public Uni<SmallRyeHealth> getLivenessAsync() {
        this.smallRyeLivenessUni = this.getHealthAsync(this.smallRyeLivenessUni, HealthType.LIVENESS);
        return this.smallRyeLivenessUni;
    }

    @Experimental(value="Asynchronous Health Check procedures")
    public Uni<SmallRyeHealth> getReadinessAsync() {
        this.smallRyeReadinessUni = this.getHealthAsync(this.smallRyeReadinessUni, HealthType.READINESS);
        return this.smallRyeReadinessUni;
    }

    @Experimental(value="Asynchronous Health Check procedures")
    public Uni<SmallRyeHealth> getStartupAsync() {
        this.smallryeStartupUni = this.getHealthAsync(this.smallryeStartupUni, HealthType.STARTUP);
        return this.smallryeStartupUni;
    }

    @Experimental(value="Asynchronous Health Check procedures & wellness experimental checks")
    public Uni<SmallRyeHealth> getWellnessAsync() {
        this.smallryeWellnessUni = this.getHealthAsync(this.smallryeWellnessUni, HealthType.WELLNESS);
        return this.smallryeWellnessUni;
    }

    @Experimental(value="Asynchronous Health Check procedures and Health Groups")
    public Uni<SmallRyeHealth> getHealthGroupAsync(String groupName) {
        ArrayList<Uni<HealthCheckResponse>> checks = new ArrayList<Uni<HealthCheckResponse>>();
        if (this.allHealthChecks != null && this.allAsyncHealthChecks != null) {
            if (groupName.equals(this.defaultHealthGroup)) {
                this.initUnis(checks, this.getHealthChecksWithoutHealthGroup(HealthCheck.class), this.getHealthChecksWithoutHealthGroup(AsyncHealthCheck.class));
            }
            this.initUnis(checks, (Iterable<HealthCheck>)this.allHealthChecks.select(new Annotation[]{HealthGroup.Literal.of((String)groupName)}), (Iterable<AsyncHealthCheck>)this.allAsyncHealthChecks.select(new Annotation[]{HealthGroup.Literal.of((String)groupName)}));
        }
        checks.addAll(((HealthRegistryImpl)HealthRegistries.getHealthGroupRegistry(groupName)).getChecks(this.healthChecksConfigs));
        return this.getHealthAsync(checks);
    }

    @Experimental(value="Asynchronous Health Check procedures and Health Groups")
    public Uni<SmallRyeHealth> getHealthGroupsAsync() {
        ArrayList<Uni<HealthCheckResponse>> checks = new ArrayList<Uni<HealthCheckResponse>>();
        if (this.defaultHealthGroup != null) {
            this.initUnis((List<Uni<HealthCheckResponse>>)checks, (Iterable<HealthCheck>)this.allHealthChecks, (Iterable<AsyncHealthCheck>)this.allAsyncHealthChecks);
        } else {
            if (this.beanManager != null) {
                this.initUnis(checks, this.getHealthGroupsChecks(HealthCheck.class), this.getHealthGroupsChecks(AsyncHealthCheck.class));
            }
            HealthRegistries.getHealthGroupRegistries().forEach(healthRegistry -> checks.addAll(((HealthRegistryImpl)healthRegistry).getChecks(this.healthChecksConfigs)));
        }
        return this.getHealthAsync(checks);
    }

    public void addHealthCheck(HealthCheck check) {
        if (check != null) {
            this.additionalChecks.put(check.getClass().getName(), this.asyncHealthCheckFactory.callSync(check));
            this.additionalListsChanged = true;
        }
    }

    public void addHealthCheck(AsyncHealthCheck check) {
        if (check != null) {
            this.additionalChecks.put(check.getClass().getName(), this.asyncHealthCheckFactory.callAsync(check));
            this.additionalListsChanged = true;
        }
    }

    public void removeHealthCheck(HealthCheck check) {
        this.additionalChecks.remove(check.getClass().getName());
        this.additionalListsChanged = true;
    }

    public void removeHealthCheck(AsyncHealthCheck check) {
        this.additionalChecks.remove(check.getClass().getName());
        this.additionalListsChanged = true;
    }

    public void setContextPropagated(boolean contextPropagated) {
        this.contextPropagated = contextPropagated;
    }

    public void setEmptyChecksOutcome(String emptyChecksOutcome) {
        Objects.requireNonNull(emptyChecksOutcome);
        this.emptyChecksOutcome = emptyChecksOutcome;
    }

    public void setTimeoutSeconds(int timeoutSeconds) {
        if (timeoutSeconds < 0) {
            throw new IllegalArgumentException("Timeout cannot be negative.");
        }
        this.timeoutSeconds = timeoutSeconds;
    }

    public void setAdditionalProperties(Map<String, String> additionalProperties) {
        Objects.requireNonNull(additionalProperties);
        this.additionalProperties = new ConcurrentHashMap<String, String>(additionalProperties);
    }

    public void setHealthChecksConfigs(Map<String, Boolean> healthChecksConfigs) {
        Objects.requireNonNull(healthChecksConfigs);
        this.healthChecksConfigs = new ConcurrentHashMap<String, Boolean>(healthChecksConfigs);
        this.checksInitialized = false;
    }

    private <T> List<T> getHealthGroupsChecks(Class<T> checkClass) {
        Iterator iterator = this.beanManager.getBeans(checkClass, new Annotation[]{Any.Literal.INSTANCE}).iterator();
        ArrayList<Object> groupHealthChecks = new ArrayList<Object>();
        while (iterator.hasNext()) {
            Bean bean = (Bean)iterator.next();
            if (!bean.getQualifiers().stream().anyMatch(annotation -> annotation.annotationType().equals(HealthGroup.class))) continue;
            groupHealthChecks.add(this.beanManager.getReference(bean, (Type)bean.getBeanClass(), this.beanManager.createCreationalContext((Contextual)bean)));
        }
        return groupHealthChecks;
    }

    private <T> List<T> getHealthChecksWithoutHealthGroup(Class<T> checkClass) {
        Iterator iterator = this.beanManager.getBeans(checkClass, new Annotation[]{Any.Literal.INSTANCE}).iterator();
        ArrayList<Object> healthChecks = new ArrayList<Object>();
        while (iterator.hasNext()) {
            Bean bean = (Bean)iterator.next();
            if (!bean.getQualifiers().stream().noneMatch(annotation -> annotation.annotationType().equals(HealthGroup.class))) continue;
            healthChecks.add(this.beanManager.getReference(bean, (Type)bean.getBeanClass(), this.beanManager.createCreationalContext((Contextual)bean)));
        }
        return healthChecks;
    }

    private Uni<SmallRyeHealth> getHealthAsync(Uni<SmallRyeHealth> cachedHealth, HealthType ... types) {
        if (!this.checksInitialized) {
            this.initChecks();
        }
        if (this.contextPropagated) {
            this.recreateCheckUnis();
            return this.computeHealth(types);
        }
        if (this.additionalListsChanged(types) || this.additionalListsChanged || cachedHealth == null) {
            this.additionalListsChanged = false;
            cachedHealth = this.computeHealth(types);
        }
        return cachedHealth;
    }

    private void recreateCheckUnis() {
        this.livenessUnis.clear();
        this.readinessUnis.clear();
        this.wellnessUnis.clear();
        this.startupUnis.clear();
        this.initChecks();
    }

    private boolean additionalListsChanged(HealthType ... types) {
        boolean needRecompute = false;
        block6: for (HealthType type : types) {
            switch (type) {
                case LIVENESS: {
                    if (!this.livenessHealthRegistry.checksChanged()) continue block6;
                    needRecompute = true;
                    continue block6;
                }
                case READINESS: {
                    if (!this.readinessHealthRegistry.checksChanged()) continue block6;
                    needRecompute = true;
                    continue block6;
                }
                case WELLNESS: {
                    if (!this.wellnessHealthRegistry.checksChanged()) continue block6;
                    needRecompute = true;
                    continue block6;
                }
                case STARTUP: {
                    if (!this.startupHealthRegistry.checksChanged()) continue block6;
                    needRecompute = true;
                }
            }
        }
        return needRecompute;
    }

    private Uni<SmallRyeHealth> computeHealth(HealthType[] types) {
        ArrayList<Uni<HealthCheckResponse>> checks = new ArrayList<Uni<HealthCheckResponse>>();
        block6: for (HealthType type : types) {
            switch (type) {
                case LIVENESS: {
                    checks.addAll(this.livenessUnis);
                    checks.addAll(this.livenessHealthRegistry.getChecks(this.healthChecksConfigs));
                    continue block6;
                }
                case READINESS: {
                    checks.addAll(this.readinessUnis);
                    checks.addAll(this.readinessHealthRegistry.getChecks(this.healthChecksConfigs));
                    continue block6;
                }
                case WELLNESS: {
                    checks.addAll(this.wellnessUnis);
                    checks.addAll(this.wellnessHealthRegistry.getChecks(this.healthChecksConfigs));
                    continue block6;
                }
                case STARTUP: {
                    checks.addAll(this.startupUnis);
                    checks.addAll(this.startupHealthRegistry.getChecks(this.healthChecksConfigs));
                }
            }
        }
        return this.getHealthAsync(checks);
    }

    private Uni<SmallRyeHealth> getHealthAsync(Collection<Uni<HealthCheckResponse>> checks) {
        ArrayList<Uni<HealthCheckResponse>> healthCheckUnis = new ArrayList<Uni<HealthCheckResponse>>();
        if (checks != null) {
            healthCheckUnis.addAll(checks);
        }
        if (!this.additionalChecks.isEmpty()) {
            healthCheckUnis.addAll(this.additionalChecks.values());
        }
        if (healthCheckUnis.isEmpty()) {
            return Uni.createFrom().item((Object)this.createEmptySmallRyeHealth(this.emptyChecksOutcome));
        }
        return Uni.combine().all().unis(healthCheckUnis).combinedWith(responses -> {
            JsonArrayBuilder results = this.jsonProvider.createArrayBuilder();
            HealthCheckResponse.Status status = HealthCheckResponse.Status.UP;
            for (Object o : responses) {
                HealthCheckResponse response = (HealthCheckResponse)o;
                status = this.handleResponse(response, results, status);
            }
            return this.createSmallRyeHealth(results, status, this.emptyChecksOutcome);
        });
    }

    private SmallRyeHealth createEmptySmallRyeHealth(String emptyOutcome) {
        return this.createSmallRyeHealth(this.jsonProvider.createArrayBuilder(), null, emptyOutcome);
    }

    private SmallRyeHealth createSmallRyeHealth(JsonArrayBuilder results, HealthCheckResponse.Status status, String emptyOutcome) {
        JsonObjectBuilder builder = this.jsonProvider.createObjectBuilder();
        JsonArray checkResults = results.build();
        builder.add("status", checkResults.isEmpty() ? emptyOutcome : status.toString());
        builder.add("checks", (JsonValue)checkResults);
        if (!this.additionalProperties.isEmpty()) {
            this.additionalProperties.forEach((arg_0, arg_1) -> ((JsonObjectBuilder)builder).add(arg_0, arg_1));
        }
        return new SmallRyeHealth(builder.build());
    }

    private HealthCheckResponse.Status handleResponse(HealthCheckResponse response, JsonArrayBuilder results, HealthCheckResponse.Status globalOutcome) {
        String status;
        JsonObject responseJson = this.jsonObject(response);
        results.add((JsonValue)responseJson);
        if (globalOutcome == HealthCheckResponse.Status.UP && (status = responseJson.getString("status")).equals("DOWN")) {
            return HealthCheckResponse.Status.DOWN;
        }
        return globalOutcome;
    }

    private JsonObject jsonObject(HealthCheckResponse response) {
        JsonObjectBuilder builder = this.jsonProvider.createObjectBuilder();
        builder.add("name", response.getName());
        builder.add("status", response.getStatus().toString());
        response.getData().ifPresent(d -> {
            JsonObjectBuilder data = this.jsonProvider.createObjectBuilder();
            for (Map.Entry entry : d.entrySet()) {
                Object value = entry.getValue();
                if (value instanceof String) {
                    data.add((String)entry.getKey(), (String)value);
                    continue;
                }
                if (value instanceof Long) {
                    data.add((String)entry.getKey(), ((Long)value).longValue());
                    continue;
                }
                if (!(value instanceof Boolean)) continue;
                data.add((String)entry.getKey(), ((Boolean)value).booleanValue());
            }
            builder.add("data", (JsonValue)data.build());
        });
        return builder.build();
    }

    private boolean isHealthCheckEnabled(HealthCheck healthCheck) {
        return this.isEnabled(healthCheck.getClass().getName()) && this.isEnabled(healthCheck.getClass().getSuperclass().getName());
    }

    private boolean isHealthCheckEnabled(AsyncHealthCheck asyncHealthCheck) {
        return this.isEnabled(asyncHealthCheck.getClass().getName()) && this.isEnabled(asyncHealthCheck.getClass().getSuperclass().getName());
    }

    private boolean isEnabled(String checkClassName) {
        return this.healthChecksConfigs.computeIfAbsent(checkClassName, s -> {
            try {
                return ConfigProvider.getConfig().getOptionalValue("io.smallrye.health.check." + checkClassName + ".enabled", Boolean.class).orElse(true);
            }
            catch (IllegalStateException illegalStateException) {
                return true;
            }
        });
    }
}

