/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.jdbc;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.Serializable;
import java.io.StringWriter;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.BatchUpdateException;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.Date;
import java.sql.NClob;
import java.sql.ParameterMetaData;
import java.sql.PreparedStatement;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLType;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Calendar;
import java.util.UUID;
import org.hsqldb.HsqlException;
import org.hsqldb.SessionInterface;
import org.hsqldb.jdbc.JDBCArray;
import org.hsqldb.jdbc.JDBCBlob;
import org.hsqldb.jdbc.JDBCBlobClient;
import org.hsqldb.jdbc.JDBCClob;
import org.hsqldb.jdbc.JDBCClobClient;
import org.hsqldb.jdbc.JDBCConnection;
import org.hsqldb.jdbc.JDBCParameterMetaData;
import org.hsqldb.jdbc.JDBCResultSet;
import org.hsqldb.jdbc.JDBCResultSetMetaData;
import org.hsqldb.jdbc.JDBCStatementBase;
import org.hsqldb.jdbc.JDBCUtil;
import org.hsqldb.lib.CharArrayWriter;
import org.hsqldb.lib.CountdownInputStream;
import org.hsqldb.lib.HsqlByteArrayOutputStream;
import org.hsqldb.lib.StringConverter;
import org.hsqldb.navigator.RowSetNavigator;
import org.hsqldb.result.Result;
import org.hsqldb.result.ResultLob;
import org.hsqldb.result.ResultMetaData;
import org.hsqldb.result.ResultProperties;
import org.hsqldb.types.BinaryData;
import org.hsqldb.types.BinaryUUIDType;
import org.hsqldb.types.BlobDataID;
import org.hsqldb.types.BlobInputStream;
import org.hsqldb.types.ClobDataID;
import org.hsqldb.types.ClobInputStream;
import org.hsqldb.types.DateTimeType;
import org.hsqldb.types.JavaObjectData;
import org.hsqldb.types.JavaObjectDataInternal;
import org.hsqldb.types.LobData;
import org.hsqldb.types.Type;

public class JDBCPreparedStatement
extends JDBCStatementBase
implements PreparedStatement {
    boolean poolable = true;
    protected Object[] parameterValues;
    protected boolean[] parameterSet;
    protected Type[] parameterTypes;
    protected byte[] parameterModes;
    protected long[] streamLengths;
    protected boolean hasLOBs;
    protected boolean isBatch;
    protected ResultMetaData resultMetaData;
    protected ResultMetaData parameterMetaData;
    protected JDBCResultSetMetaData resultSetMetaData;
    protected ParameterMetaData pmd;
    protected String sql;
    protected long statementID;
    protected int statementRetType;
    protected final boolean isResult;
    protected SessionInterface session;

    @Override
    public synchronized ResultSet executeQuery() throws SQLException {
        if (this.statementRetType != 2) {
            this.checkStatementType(2);
        }
        this.fetchResult();
        return this.getResultSet();
    }

    @Override
    public synchronized int executeUpdate() throws SQLException {
        if (this.statementRetType != 1) {
            this.checkStatementType(1);
        }
        this.fetchResult();
        return this.resultIn.getUpdateCount();
    }

    @Override
    public synchronized void setNull(int n, int n2) throws SQLException {
        this.setParameter(n, null);
    }

    @Override
    public synchronized void setBoolean(int n, boolean bl) throws SQLException {
        Boolean bl2 = bl ? Boolean.TRUE : Boolean.FALSE;
        this.setParameter(n, bl2);
    }

    @Override
    public synchronized void setByte(int n, byte by) throws SQLException {
        this.setIntParameter(n, by);
    }

    @Override
    public synchronized void setShort(int n, short s) throws SQLException {
        if (this.isClosed || this.connection.isClosed) {
            this.checkClosed();
        }
        this.setIntParameter(n, s);
    }

    @Override
    public synchronized void setInt(int n, int n2) throws SQLException {
        if (this.isClosed || this.connection.isClosed) {
            this.checkClosed();
        }
        this.setIntParameter(n, n2);
    }

    @Override
    public synchronized void setLong(int n, long l) throws SQLException {
        if (this.isClosed || this.connection.isClosed) {
            this.checkClosed();
        }
        this.setLongParameter(n, l);
    }

    @Override
    public synchronized void setFloat(int n, float f) throws SQLException {
        this.setDouble(n, f);
    }

    @Override
    public synchronized void setDouble(int n, double d) throws SQLException {
        Double d2 = d;
        this.setParameter(n, d2);
    }

    @Override
    public synchronized void setBigDecimal(int n, BigDecimal bigDecimal) throws SQLException {
        this.setParameter(n, bigDecimal);
    }

    @Override
    public synchronized void setString(int n, String string) throws SQLException {
        this.setParameter(n, string);
    }

    @Override
    public synchronized void setBytes(int n, byte[] byArray) throws SQLException {
        this.setParameter(n, byArray);
    }

    @Override
    public synchronized void setDate(int n, Date date) throws SQLException {
        this.setDate(n, date, null);
    }

    @Override
    public synchronized void setTime(int n, Time time) throws SQLException {
        this.setTime(n, time, null);
    }

    @Override
    public synchronized void setTimestamp(int n, Timestamp timestamp) throws SQLException {
        this.setTimestamp(n, timestamp, null);
    }

    @Override
    public synchronized void setAsciiStream(int n, InputStream inputStream, int n2) throws SQLException {
        this.setAsciiStream(n, inputStream, (long)n2);
    }

    @Override
    @Deprecated
    public synchronized void setUnicodeStream(int n, InputStream inputStream, int n2) throws SQLException {
        this.checkSetParameterIndex(n);
        if (inputStream == null) {
            throw JDBCUtil.nullArgument("x");
        }
        String string = "UTF8";
        StringWriter stringWriter = new StringWriter();
        try {
            int n3;
            CountdownInputStream countdownInputStream = new CountdownInputStream(inputStream);
            InputStreamReader inputStreamReader = new InputStreamReader((InputStream)countdownInputStream, string);
            char[] cArray = new char[1024];
            countdownInputStream.setCount(n2);
            while (-1 != (n3 = inputStreamReader.read(cArray))) {
                stringWriter.write(cArray, 0, n3);
            }
        }
        catch (IOException iOException) {
            throw JDBCUtil.sqlException(401, iOException.toString(), iOException);
        }
        this.setParameter(n, stringWriter.toString());
    }

    @Override
    public synchronized void setBinaryStream(int n, InputStream inputStream, int n2) throws SQLException {
        this.setBinaryStream(n, inputStream, (long)n2);
    }

    @Override
    public synchronized void clearParameters() throws SQLException {
        if (this.isClosed || this.connection.isClosed) {
            this.checkClosed();
        }
        Arrays.fill(this.parameterValues, null);
        Arrays.fill(this.parameterSet, false);
        Arrays.fill(this.streamLengths, 0, this.streamLengths.length, 0L);
    }

    @Override
    public synchronized void setObject(int n, Object object, int n2, int n3) throws SQLException {
        if (object instanceof InputStream) {
            this.setBinaryStream(n, (InputStream)object, n3);
        } else if (object instanceof Reader) {
            this.setCharacterStream(n, (Reader)object, n3);
        } else {
            this.setObject(n, object);
        }
    }

    @Override
    public synchronized void setObject(int n, Object object, int n2) throws SQLException {
        this.setObject(n, object);
    }

    @Override
    public synchronized void setObject(int n, Object object) throws SQLException {
        this.setParameter(n, object);
    }

    @Override
    public synchronized boolean execute() throws SQLException {
        this.fetchResult();
        return this.statementRetType == 2;
    }

    @Override
    public synchronized void addBatch() throws SQLException {
        if (this.isClosed || this.connection.isClosed) {
            this.checkClosed();
        }
        this.checkParametersSet();
        if (!this.isBatch) {
            this.resultOut.setBatchedPreparedExecuteRequest();
            this.isBatch = true;
        }
        try {
            this.performPreExecute();
        }
        catch (HsqlException hsqlException) {
            throw JDBCUtil.sqlException(hsqlException);
        }
        int n = this.parameterValues.length;
        Object[] objectArray = new Object[n];
        System.arraycopy(this.parameterValues, 0, objectArray, 0, n);
        this.resultOut.addBatchedPreparedExecuteRequest(objectArray);
    }

    @Override
    public synchronized void setCharacterStream(int n, Reader reader, int n2) throws SQLException {
        this.setCharacterStream(n, reader, (long)n2);
    }

    @Override
    public void setRef(int n, Ref ref) throws SQLException {
        throw JDBCUtil.notSupported();
    }

    @Override
    public synchronized void setBlob(int n, Blob blob) throws SQLException {
        this.checkSetParameterIndex(n);
        Type type = this.parameterTypes[n - 1];
        switch (type.typeCode) {
            case 60: 
            case 61: {
                this.setBlobForBinaryParameter(n, blob);
                return;
            }
            case 30: {
                this.setBlobParameter(n, blob);
                break;
            }
            default: {
                throw JDBCUtil.invalidArgument();
            }
        }
    }

    private void setBlobForBinaryParameter(int n, Blob blob) throws SQLException {
        if (blob instanceof JDBCBlob) {
            this.setParameter(n, ((JDBCBlob)blob).data());
            return;
        }
        if (blob == null) {
            this.setParameter(n, null);
            return;
        }
        long l = blob.length();
        if (l > Integer.MAX_VALUE) {
            String string = "Maximum Blob input octet length exceeded: " + l;
            throw JDBCUtil.sqlException(422, string);
        }
        try {
            InputStream inputStream = blob.getBinaryStream();
            HsqlByteArrayOutputStream hsqlByteArrayOutputStream = new HsqlByteArrayOutputStream(inputStream, (int)l);
            this.setParameter(n, hsqlByteArrayOutputStream.toByteArray());
            hsqlByteArrayOutputStream.close();
        }
        catch (Throwable throwable) {
            throw JDBCUtil.sqlException(422, throwable.toString(), throwable);
        }
    }

    @Override
    public synchronized void setClob(int n, Clob clob) throws SQLException {
        this.checkSetParameterIndex(n);
        Type type = this.parameterTypes[n - 1];
        switch (type.typeCode) {
            case 1: 
            case 12: {
                this.setClobForStringParameter(n, clob);
                return;
            }
            case 40: {
                this.setClobParameter(n, clob);
                return;
            }
        }
        throw JDBCUtil.invalidArgument();
    }

    private void setClobForStringParameter(int n, Clob clob) throws SQLException {
        if (clob instanceof JDBCClob) {
            this.setParameter(n, ((JDBCClob)clob).getData());
            return;
        }
        if (clob == null) {
            this.setParameter(n, null);
            return;
        }
        long l = clob.length();
        if (l > Integer.MAX_VALUE) {
            String string = "Max Clob input character length exceeded: " + l;
            throw JDBCUtil.sqlException(422, string);
        }
        try {
            Reader reader = clob.getCharacterStream();
            CharArrayWriter charArrayWriter = new CharArrayWriter(reader, (int)l);
            this.setParameter(n, charArrayWriter.toString());
        }
        catch (Throwable throwable) {
            throw JDBCUtil.sqlException(401, throwable.toString(), throwable);
        }
    }

    @Override
    public synchronized void setArray(int n, Array array) throws SQLException {
        this.checkParameterIndex(n);
        int n2 = n - 1;
        Type type = this.parameterMetaData.columnTypes[n2];
        if (!type.isArrayType()) {
            throw JDBCUtil.sqlException(5561);
        }
        if (array == null) {
            this.parameterValues[n2] = null;
            this.parameterSet[n2] = true;
            return;
        }
        Object[] objectArray = null;
        if (array instanceof JDBCArray) {
            Type type2 = type.collectionBaseType();
            Object[] objectArray2 = ((JDBCArray)array).getArrayInternal();
            Type type3 = ((JDBCArray)array).arrayType;
            objectArray = (Object[])type.convertToType(this.session, objectArray2, type3);
        } else {
            Object object = array.getArray();
            if (object instanceof Object[]) {
                Type type4 = type.collectionBaseType();
                Object[] objectArray3 = (Object[])object;
                objectArray = new Object[objectArray3.length];
                for (int i = 0; i < objectArray.length; ++i) {
                    objectArray[i] = type4.convertJavaToSQL(this.session, objectArray3[i]);
                }
            } else {
                throw JDBCUtil.notSupported();
            }
        }
        this.parameterValues[n2] = objectArray;
        this.parameterSet[n2] = true;
    }

    @Override
    public synchronized ResultSetMetaData getMetaData() throws SQLException {
        if (this.isClosed || this.connection.isClosed) {
            this.checkClosed();
        }
        if (this.statementRetType != 2) {
            return null;
        }
        if (this.resultSetMetaData == null) {
            boolean bl = ResultProperties.isUpdatable(this.rsProperties);
            boolean bl2 = bl;
            if (bl2) {
                for (int i = 0; i < this.resultMetaData.colIndexes.length; ++i) {
                    if (this.resultMetaData.colIndexes[i] >= 0) continue;
                    bl2 = false;
                    break;
                }
            }
            this.resultSetMetaData = new JDBCResultSetMetaData(this.resultMetaData, bl, bl2, this.connection);
        }
        return this.resultSetMetaData;
    }

    @Override
    public synchronized void setDate(int n, Date date, Calendar calendar) throws SQLException {
        Object object;
        this.checkSetParameterIndex(n);
        int n2 = n - 1;
        if (date == null) {
            this.parameterValues[n2] = null;
            this.parameterSet[n2] = true;
            return;
        }
        Type type = this.parameterTypes[n2];
        switch (type.typeCode) {
            case 91: 
            case 93: 
            case 95: {
                object = ((DateTimeType)type).convertJavaToSQL(this.session, date, calendar);
                break;
            }
            case 1: 
            case 12: {
                object = Type.SQL_DATE.convertJavaToSQL(this.session, date);
                object = type.castToType(this.session, object, Type.SQL_DATE);
                break;
            }
            default: {
                throw JDBCUtil.sqlException(5561);
            }
        }
        this.parameterValues[n2] = object;
        this.parameterSet[n2] = true;
    }

    @Override
    public synchronized void setTime(int n, Time time, Calendar calendar) throws SQLException {
        Object object;
        this.checkSetParameterIndex(n);
        int n2 = n - 1;
        if (time == null) {
            this.parameterValues[n2] = null;
            this.parameterSet[n2] = true;
            return;
        }
        Type type = this.parameterTypes[n2];
        switch (type.typeCode) {
            case 92: 
            case 93: 
            case 94: 
            case 95: {
                object = ((DateTimeType)type).convertJavaToSQL(this.session, time, calendar);
                break;
            }
            case 1: 
            case 12: {
                object = Type.SQL_TIME_WITH_TIME_ZONE_MAX.convertJavaToSQL(this.session, time);
                object = type.castToType(this.session, object, Type.SQL_TIME_WITH_TIME_ZONE_MAX);
                break;
            }
            default: {
                throw JDBCUtil.sqlException(5561);
            }
        }
        this.parameterValues[n2] = object;
        this.parameterSet[n2] = true;
    }

    @Override
    public synchronized void setTimestamp(int n, Timestamp timestamp, Calendar calendar) throws SQLException {
        Object object;
        this.checkSetParameterIndex(n);
        int n2 = n - 1;
        if (timestamp == null) {
            this.parameterValues[n2] = null;
            this.parameterSet[n2] = true;
            return;
        }
        Type type = this.parameterTypes[n2];
        switch (type.typeCode) {
            case 91: 
            case 92: 
            case 93: 
            case 94: 
            case 95: {
                object = ((DateTimeType)type).convertJavaToSQL(this.session, timestamp, calendar);
                break;
            }
            case 1: 
            case 12: {
                object = Type.SQL_TIMESTAMP_WITH_TIME_ZONE_MAX.convertJavaToSQL(this.session, timestamp);
                object = type.castToType(this.session, object, Type.SQL_TIMESTAMP_WITH_TIME_ZONE_MAX);
                break;
            }
            default: {
                throw JDBCUtil.sqlException(5561);
            }
        }
        this.parameterValues[n2] = object;
        this.parameterSet[n2] = true;
    }

    @Override
    public synchronized void setNull(int n, int n2, String string) throws SQLException {
        this.setParameter(n, null);
    }

    @Override
    public synchronized int[] executeBatch() throws SQLException {
        if (this.isClosed || this.connection.isClosed) {
            this.checkClosed();
        }
        this.checkStatementType(1);
        if (!this.isBatch) {
            if (this.connection.isAllowEmptyBatch) {
                return new int[0];
            }
            throw JDBCUtil.sqlExceptionSQL(1256);
        }
        this.generatedResult = null;
        int n = this.resultOut.getNavigator().getSize();
        this.resultIn = null;
        try {
            this.resultIn = this.session.execute(this.resultOut);
        }
        catch (HsqlException hsqlException) {
            throw JDBCUtil.sqlException(hsqlException);
        }
        finally {
            this.performPostExecute();
            this.resultOut.getNavigator().clear();
            this.isBatch = false;
        }
        if (this.resultIn.mode == 2) {
            throw JDBCUtil.sqlException(this.resultIn);
        }
        RowSetNavigator rowSetNavigator = this.resultIn.getNavigator();
        int[] nArray = new int[rowSetNavigator.getSize()];
        int n2 = 0;
        while (rowSetNavigator.next()) {
            Object[] objectArray = rowSetNavigator.getCurrent();
            nArray[n2] = (Integer)objectArray[0];
            ++n2;
        }
        if (nArray.length != n) {
            if (this.errorResult == null) {
                throw new BatchUpdateException(nArray);
            }
            throw new BatchUpdateException(this.errorResult.getMainString(), this.errorResult.getSubString(), this.errorResult.getErrorCode(), nArray);
        }
        return nArray;
    }

    @Override
    public void setEscapeProcessing(boolean bl) throws SQLException {
        this.checkClosed();
    }

    @Override
    public void addBatch(String string) throws SQLException {
        throw JDBCUtil.notSupported();
    }

    @Override
    public synchronized ResultSet executeQuery(String string) throws SQLException {
        throw JDBCUtil.notSupported();
    }

    @Override
    public boolean execute(String string) throws SQLException {
        throw JDBCUtil.notSupported();
    }

    @Override
    public int executeUpdate(String string) throws SQLException {
        throw JDBCUtil.notSupported();
    }

    @Override
    public synchronized void close() throws SQLException {
        if (this.isClosed()) {
            return;
        }
        this.closeResultData();
        HsqlException hsqlException = null;
        try {
            if (!this.connection.isClosed) {
                this.session.execute(Result.newFreeStmtRequest(this.statementID));
            }
        }
        catch (HsqlException hsqlException2) {
            hsqlException = hsqlException2;
        }
        this.parameterValues = null;
        this.parameterSet = null;
        this.parameterTypes = null;
        this.parameterModes = null;
        this.resultMetaData = null;
        this.parameterMetaData = null;
        this.resultSetMetaData = null;
        this.pmd = null;
        this.connection = null;
        this.session = null;
        this.resultIn = null;
        this.resultOut = null;
        this.isClosed = true;
        if (hsqlException != null) {
            throw JDBCUtil.sqlException(hsqlException);
        }
    }

    public synchronized String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(super.toString());
        String string = this.sql;
        Object[] objectArray = this.parameterValues;
        if (string == null || objectArray == null) {
            stringBuilder.append("[closed]");
            return stringBuilder.toString();
        }
        stringBuilder.append("[sql=[").append(string).append("]");
        if (objectArray.length > 0) {
            stringBuilder.append(", parameters=[");
            for (int i = 0; i < objectArray.length; ++i) {
                stringBuilder.append('[');
                stringBuilder.append(objectArray[i]);
                stringBuilder.append("], ");
            }
            stringBuilder.setLength(stringBuilder.length() - 2);
            stringBuilder.append(']');
        }
        stringBuilder.append(']');
        return stringBuilder.toString();
    }

    @Override
    public void setURL(int n, URL uRL) throws SQLException {
        throw JDBCUtil.notSupported();
    }

    @Override
    public synchronized ParameterMetaData getParameterMetaData() throws SQLException {
        this.checkClosed();
        if (this.pmd == null) {
            this.pmd = new JDBCParameterMetaData(this.connection, this.parameterMetaData);
        }
        return this.pmd;
    }

    @Override
    public int executeUpdate(String string, int n) throws SQLException {
        throw JDBCUtil.notSupported();
    }

    @Override
    public boolean execute(String string, int n) throws SQLException {
        throw JDBCUtil.notSupported();
    }

    @Override
    public int executeUpdate(String string, int[] nArray) throws SQLException {
        throw JDBCUtil.notSupported();
    }

    @Override
    public boolean execute(String string, int[] nArray) throws SQLException {
        throw JDBCUtil.notSupported();
    }

    @Override
    public int executeUpdate(String string, String[] stringArray) throws SQLException {
        throw JDBCUtil.notSupported();
    }

    @Override
    public boolean execute(String string, String[] stringArray) throws SQLException {
        throw JDBCUtil.notSupported();
    }

    @Override
    public synchronized boolean getMoreResults(int n) throws SQLException {
        return super.getMoreResults(n);
    }

    @Override
    public synchronized ResultSet getGeneratedKeys() throws SQLException {
        return this.getGeneratedResultSet();
    }

    @Override
    public synchronized int getResultSetHoldability() throws SQLException {
        if (this.isClosed || this.connection.isClosed) {
            this.checkClosed();
        }
        return ResultProperties.getJDBCHoldability(this.rsProperties);
    }

    @Override
    public synchronized boolean isClosed() {
        return this.isClosed;
    }

    @Override
    public void setRowId(int n, RowId rowId) throws SQLException {
        throw JDBCUtil.notSupported();
    }

    @Override
    public synchronized void setNString(int n, String string) throws SQLException {
        this.setString(n, string);
    }

    @Override
    public synchronized void setNCharacterStream(int n, Reader reader, long l) throws SQLException {
        this.setCharacterStream(n, reader, l);
    }

    @Override
    public synchronized void setNClob(int n, NClob nClob) throws SQLException {
        this.setClob(n, nClob);
    }

    @Override
    public synchronized void setClob(int n, Reader reader, long l) throws SQLException {
        this.setCharacterStream(n, reader, l);
    }

    @Override
    public synchronized void setBlob(int n, InputStream inputStream, long l) throws SQLException {
        this.setBinaryStream(n, inputStream, l);
    }

    @Override
    public synchronized void setNClob(int n, Reader reader, long l) throws SQLException {
        this.setClob(n, reader, l);
    }

    @Override
    public void setSQLXML(int n, SQLXML sQLXML) throws SQLException {
        throw JDBCUtil.notSupported();
    }

    @Override
    public synchronized void setAsciiStream(int n, InputStream inputStream, long l) throws SQLException {
        if (l < 0L) {
            throw JDBCUtil.sqlException(423, "length: " + l);
        }
        this.setAscStream(n, inputStream, l);
    }

    void setAscStream(int n, InputStream inputStream, long l) throws SQLException {
        if (l > Integer.MAX_VALUE) {
            throw JDBCUtil.sqlException(3401);
        }
        if (inputStream == null) {
            throw JDBCUtil.nullArgument("x");
        }
        try {
            String string = StringConverter.inputStreamToString(inputStream, "US-ASCII");
            if (l >= 0L && (long)string.length() > l) {
                string = string.substring(0, (int)l);
            }
            this.setParameter(n, string);
        }
        catch (IOException iOException) {
            throw JDBCUtil.sqlException(422, null, iOException);
        }
    }

    @Override
    public synchronized void setBinaryStream(int n, InputStream inputStream, long l) throws SQLException {
        if (this.isClosed || this.connection.isClosed) {
            this.checkClosed();
        }
        if (l < 0L) {
            throw JDBCUtil.sqlException(423, "length: " + l);
        }
        if (l > this.parameterTypes[n - 1].precision) {
            throw JDBCUtil.sqlException(3401, "length: " + l);
        }
        this.setBinStream(n, inputStream, -1L);
    }

    private void setBinStream(int n, InputStream inputStream, long l) throws SQLException {
        if (this.isClosed || this.connection.isClosed) {
            this.checkClosed();
        }
        if (this.parameterTypes[n - 1].typeCode == 30) {
            this.setBlobParameter(n, inputStream, l);
            return;
        }
        if (l > Integer.MAX_VALUE) {
            String string = "Maximum Blob input length exceeded: " + l;
            throw JDBCUtil.sqlException(422, string);
        }
        try {
            HsqlByteArrayOutputStream hsqlByteArrayOutputStream = l < 0L ? new HsqlByteArrayOutputStream(inputStream) : new HsqlByteArrayOutputStream(inputStream, (int)l);
            this.setParameter(n, hsqlByteArrayOutputStream.toByteArray());
        }
        catch (Throwable throwable) {
            throw JDBCUtil.sqlException(422, throwable.toString(), throwable);
        }
    }

    @Override
    public synchronized void setCharacterStream(int n, Reader reader, long l) throws SQLException {
        if (this.isClosed || this.connection.isClosed) {
            this.checkClosed();
        }
        if (l < 0L) {
            throw JDBCUtil.sqlException(423, "length: " + l);
        }
        if (l > this.parameterTypes[n - 1].precision) {
            throw JDBCUtil.sqlException(3401, "length: " + l);
        }
        this.setCharStream(n, reader, -1L);
    }

    private void setCharStream(int n, Reader reader, long l) throws SQLException {
        this.checkSetParameterIndex(n);
        if (this.parameterTypes[n - 1].typeCode == 40) {
            this.setClobParameter(n, reader, l);
            return;
        }
        if (l > Integer.MAX_VALUE) {
            String string = "Maximum Clob input length exceeded: " + l;
            throw JDBCUtil.sqlException(422, string);
        }
        try {
            CharArrayWriter charArrayWriter = l < 0L ? new CharArrayWriter(reader) : new CharArrayWriter(reader, (int)l);
            this.setParameter(n, charArrayWriter.toString());
        }
        catch (Throwable throwable) {
            throw JDBCUtil.sqlException(422, throwable.toString(), throwable);
        }
    }

    @Override
    public synchronized void setAsciiStream(int n, InputStream inputStream) throws SQLException {
        this.setAscStream(n, inputStream, -1L);
    }

    @Override
    public synchronized void setBinaryStream(int n, InputStream inputStream) throws SQLException {
        this.setBinStream(n, inputStream, -1L);
    }

    @Override
    public synchronized void setCharacterStream(int n, Reader reader) throws SQLException {
        this.setCharStream(n, reader, -1L);
    }

    @Override
    public synchronized void setNCharacterStream(int n, Reader reader) throws SQLException {
        this.setCharStream(n, reader, -1L);
    }

    @Override
    public synchronized void setClob(int n, Reader reader) throws SQLException {
        this.setCharStream(n, reader, -1L);
    }

    @Override
    public synchronized void setBlob(int n, InputStream inputStream) throws SQLException {
        this.setBinStream(n, inputStream, -1L);
    }

    @Override
    public synchronized void setNClob(int n, Reader reader) throws SQLException {
        this.setCharStream(n, reader, -1L);
    }

    @Override
    public synchronized int getMaxFieldSize() throws SQLException {
        if (this.isClosed || this.connection.isClosed) {
            this.checkClosed();
        }
        return 0;
    }

    @Override
    public synchronized void setMaxFieldSize(int n) throws SQLException {
        if (this.isClosed || this.connection.isClosed) {
            this.checkClosed();
        }
        if (n < 0) {
            throw JDBCUtil.outOfRangeArgument();
        }
    }

    @Override
    public synchronized int getMaxRows() throws SQLException {
        if (this.isClosed || this.connection.isClosed) {
            this.checkClosed();
        }
        return this.maxRows;
    }

    @Override
    public synchronized void setMaxRows(int n) throws SQLException {
        if (this.isClosed || this.connection.isClosed) {
            this.checkClosed();
        }
        if (n < 0) {
            throw JDBCUtil.outOfRangeArgument();
        }
        this.maxRows = n;
    }

    @Override
    public synchronized int getQueryTimeout() throws SQLException {
        if (this.isClosed || this.connection.isClosed) {
            this.checkClosed();
        }
        return this.queryTimeout;
    }

    @Override
    public synchronized void setQueryTimeout(int n) throws SQLException {
        if (this.isClosed || this.connection.isClosed) {
            this.checkClosed();
        }
        if (n < 0) {
            throw JDBCUtil.outOfRangeArgument();
        }
        if (n > Short.MAX_VALUE) {
            n = Short.MAX_VALUE;
        }
        this.queryTimeout = n;
    }

    @Override
    public synchronized void cancel() throws SQLException {
        this.checkClosed();
        String string = this.resultOut.getMainString();
        int n = this.connection.sessionProxy.getRandomId();
        Result result = Result.newCancelRequest(n, -1L, string);
        try {
            Result result2 = this.connection.sessionProxy.cancel(result);
        }
        catch (HsqlException hsqlException) {
            throw JDBCUtil.sqlException(hsqlException);
        }
    }

    @Override
    public synchronized SQLWarning getWarnings() throws SQLException {
        if (this.isClosed || this.connection.isClosed) {
            this.checkClosed();
        }
        return this.rootWarning;
    }

    @Override
    public synchronized void clearWarnings() throws SQLException {
        if (this.isClosed || this.connection.isClosed) {
            this.checkClosed();
        }
        this.rootWarning = null;
    }

    @Override
    public void setCursorName(String string) throws SQLException {
        this.checkClosed();
    }

    @Override
    public synchronized ResultSet getResultSet() throws SQLException {
        return super.getResultSet();
    }

    @Override
    public synchronized int getUpdateCount() throws SQLException {
        return super.getUpdateCount();
    }

    @Override
    public synchronized boolean getMoreResults() throws SQLException {
        return this.getMoreResults(1);
    }

    @Override
    public synchronized void setFetchDirection(int n) throws SQLException {
        if (this.isClosed || this.connection.isClosed) {
            this.checkClosed();
        }
        if (n != 1000 && n != 1001 && n != 1002) {
            throw JDBCUtil.notSupported();
        }
        this.fetchDirection = n;
    }

    @Override
    public synchronized int getFetchDirection() throws SQLException {
        if (this.isClosed || this.connection.isClosed) {
            this.checkClosed();
        }
        return this.fetchDirection;
    }

    @Override
    public synchronized void setFetchSize(int n) throws SQLException {
        if (this.isClosed || this.connection.isClosed) {
            this.checkClosed();
        }
        if (n < 0) {
            throw JDBCUtil.outOfRangeArgument();
        }
        this.fetchSize = n;
    }

    @Override
    public synchronized int getFetchSize() throws SQLException {
        if (this.isClosed || this.connection.isClosed) {
            this.checkClosed();
        }
        return this.fetchSize;
    }

    @Override
    public synchronized int getResultSetConcurrency() throws SQLException {
        if (this.isClosed || this.connection.isClosed) {
            this.checkClosed();
        }
        return ResultProperties.getJDBCConcurrency(this.rsProperties);
    }

    @Override
    public synchronized int getResultSetType() throws SQLException {
        if (this.isClosed || this.connection.isClosed) {
            this.checkClosed();
        }
        return ResultProperties.getJDBCScrollability(this.rsProperties);
    }

    @Override
    public synchronized void clearBatch() throws SQLException {
        if (this.isClosed || this.connection.isClosed) {
            this.checkClosed();
        }
        if (this.isBatch) {
            this.resultOut.getNavigator().clear();
        }
    }

    @Override
    public synchronized Connection getConnection() throws SQLException {
        if (this.isClosed || this.connection.isClosed) {
            this.checkClosed();
        }
        return this.connection;
    }

    @Override
    public synchronized void setPoolable(boolean bl) throws SQLException {
        if (this.isClosed || this.connection.isClosed) {
            this.checkClosed();
        }
        this.poolable = bl;
    }

    @Override
    public synchronized boolean isPoolable() throws SQLException {
        if (this.isClosed || this.connection.isClosed) {
            this.checkClosed();
        }
        return this.poolable;
    }

    @Override
    public <T> T unwrap(Class<T> clazz) throws SQLException {
        if (this.isWrapperFor(clazz)) {
            return (T)this;
        }
        throw JDBCUtil.invalidArgument("iface: " + clazz);
    }

    @Override
    public boolean isWrapperFor(Class<?> clazz) throws SQLException {
        return clazz != null && clazz.isAssignableFrom(this.getClass());
    }

    @Override
    public synchronized long getLargeUpdateCount() throws SQLException {
        return super.getUpdateCount();
    }

    @Override
    public synchronized void setLargeMaxRows(long l) throws SQLException {
        int n = l > Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)l;
        this.setMaxRows(n);
    }

    @Override
    public synchronized long getLargeMaxRows() throws SQLException {
        return this.maxRows;
    }

    @Override
    public synchronized long[] executeLargeBatch() throws SQLException {
        int[] nArray = this.executeBatch();
        long[] lArray = new long[nArray.length];
        for (int i = 0; i < nArray.length; ++i) {
            lArray[i] = nArray[i];
        }
        return lArray;
    }

    @Override
    public synchronized void setObject(int n, Object object, SQLType sQLType, int n2) throws SQLException {
        int n3 = sQLType.getVendorTypeNumber();
        this.setObject(n, object, n3, n2);
    }

    @Override
    public synchronized void setObject(int n, Object object, SQLType sQLType) throws SQLException {
        int n2 = sQLType.getVendorTypeNumber();
        this.setObject(n, object, n2);
    }

    @Override
    public synchronized long executeLargeUpdate() throws SQLException {
        return this.executeUpdate();
    }

    JDBCPreparedStatement(JDBCConnection jDBCConnection, String string, int n, int n2, int n3, int n4, int[] nArray, String[] stringArray) throws HsqlException, SQLException {
        this.isResult = false;
        this.connection = jDBCConnection;
        this.connectionIncarnation = this.connection.incarnation;
        this.session = jDBCConnection.sessionProxy;
        string = jDBCConnection.nativeSQL(string);
        this.resultOut = Result.newPrepareStatementRequest();
        int n5 = ResultProperties.getValueForJDBC(n, n2, n3);
        this.resultOut.setPrepareOrExecuteProperties(string, 0, 0, 0, this.queryTimeout, n5, n4, nArray, stringArray);
        Result result = this.session.execute(this.resultOut);
        if (result.mode == 2) {
            throw JDBCUtil.sqlException(result);
        }
        this.rootWarning = null;
        Result result2 = result;
        while (result2.getChainedResult() != null) {
            if (!(result2 = result2.getUnlinkChainedResult()).isWarning()) continue;
            SQLWarning sQLWarning = JDBCUtil.sqlWarning(result2);
            if (this.rootWarning == null) {
                this.rootWarning = sQLWarning;
                continue;
            }
            this.rootWarning.setNextWarning(sQLWarning);
        }
        this.connection.setWarnings(this.rootWarning);
        this.statementID = result.getStatementID();
        this.statementRetType = result.getStatementType();
        this.resultMetaData = result.metaData;
        this.parameterMetaData = result.parameterMetaData;
        this.parameterTypes = this.parameterMetaData.getParameterTypes();
        this.parameterModes = this.parameterMetaData.paramModes;
        this.rsProperties = result.rsProperties;
        int n6 = this.parameterMetaData.getColumnCount();
        this.parameterValues = new Object[n6];
        this.parameterSet = new boolean[n6];
        this.streamLengths = new long[n6];
        for (int i = 0; i < n6; ++i) {
            if (!this.parameterTypes[i].isLobType()) continue;
            this.hasLOBs = true;
            break;
        }
        this.resultOut = Result.newPreparedExecuteRequest(this.parameterTypes, this.statementID);
        this.resultOut.setStatement(result.getStatement());
        this.sql = string;
    }

    JDBCPreparedStatement(JDBCConnection jDBCConnection, Result result) {
        this.isResult = true;
        this.connection = jDBCConnection;
        this.connectionIncarnation = this.connection.incarnation;
        this.session = jDBCConnection.sessionProxy;
        int n = result.metaData.getExtendedColumnCount();
        this.parameterMetaData = result.metaData;
        this.parameterTypes = result.metaData.columnTypes;
        this.parameterModes = new byte[n];
        this.parameterValues = new Object[n];
        this.parameterSet = new boolean[n];
        this.streamLengths = new long[n];
        for (int i = 0; i < n; ++i) {
            this.parameterModes[i] = 1;
            if (!this.parameterTypes[i].isLobType()) continue;
            this.hasLOBs = true;
        }
        this.resultOut = Result.newUpdateResultRequest(this.parameterTypes, result.getResultId());
    }

    protected void checkStatementType(int n) throws SQLException {
        if (n != this.statementRetType) {
            if (this.statementRetType == 1) {
                throw JDBCUtil.sqlException(1254);
            }
            throw JDBCUtil.sqlException(1253);
        }
    }

    protected void checkParameterIndex(int n) throws SQLException {
        if (this.isClosed || this.connection.isClosed) {
            this.checkClosed();
        }
        if (n < 1 || n > this.parameterValues.length) {
            String string = "parameter index out of range: " + n;
            throw JDBCUtil.outOfRangeArgument(string);
        }
    }

    protected void checkSetParameterIndex(int n) throws SQLException {
        if (this.isClosed || this.connection.isClosed) {
            this.checkClosed();
        }
        if (n < 1 || n > this.parameterValues.length) {
            String string = "parameter index out of range: " + n;
            throw JDBCUtil.outOfRangeArgument(string);
        }
        if (this.parameterModes[n - 1] == 4) {
            String string = "Not IN or INOUT mode for parameter: " + n;
            throw JDBCUtil.invalidArgument(string);
        }
    }

    protected void checkGetParameterIndex(int n) throws SQLException {
        if (this.isClosed || this.connection.isClosed) {
            this.checkClosed();
        }
        if (n < 1 || n > this.parameterValues.length) {
            String string = "parameter index out of range: " + n;
            throw JDBCUtil.outOfRangeArgument(string);
        }
        byte by = this.parameterModes[n - 1];
        switch (by) {
            case 0: 
            case 2: 
            case 4: {
                break;
            }
            default: {
                String string = "Not OUT or INOUT mode for parameter: " + n;
                throw JDBCUtil.invalidArgument(string);
            }
        }
    }

    private void checkParametersSet() throws SQLException {
        if (this.isResult) {
            return;
        }
        for (int i = 0; i < this.parameterSet.length; ++i) {
            if (this.parameterModes[i] == 4 || this.parameterSet[i]) continue;
            throw JDBCUtil.sqlException(424);
        }
    }

    void setParameter(int n, Object object) throws SQLException {
        this.checkSetParameterIndex(n);
        int n2 = n - 1;
        if (object == null) {
            this.parameterValues[n2] = null;
            this.parameterSet[n2] = true;
            return;
        }
        Type type = this.parameterTypes[n2];
        switch (type.typeCode) {
            case 1111: {
                try {
                    if (this.connection.isStoreLiveObject) {
                        object = new JavaObjectDataInternal(object);
                        break;
                    }
                    if (object instanceof Serializable) {
                        object = new JavaObjectData((Serializable)object);
                        break;
                    }
                }
                catch (HsqlException hsqlException) {
                    throw JDBCUtil.sqlException(hsqlException);
                }
                throw JDBCUtil.sqlException(5563);
            }
            case 14: 
            case 15: {
                try {
                    if (object instanceof Boolean) {
                        object = type.convertToDefaultType(this.session, object);
                        break;
                    }
                    if (object instanceof Integer) {
                        object = type.convertToDefaultType(this.session, object);
                        break;
                    }
                    if (object instanceof byte[]) {
                        object = type.convertToDefaultType(this.session, object);
                        break;
                    }
                    if (object instanceof String) {
                        object = type.convertToDefaultType(this.session, object);
                        break;
                    }
                    if (object instanceof BitSet) {
                        object = type.convertToDefaultType(this.session, object);
                        break;
                    }
                }
                catch (HsqlException hsqlException) {
                    throw JDBCUtil.sqlException(hsqlException);
                }
                throw JDBCUtil.sqlException(5563);
            }
            case -11: 
            case 60: 
            case 61: {
                if (object instanceof byte[]) {
                    object = new BinaryData((byte[])object, !this.connection.isNetConn);
                    break;
                }
                if (object instanceof UUID) {
                    object = BinaryUUIDType.getBinary((UUID)object);
                    break;
                }
                try {
                    if (object instanceof String) {
                        object = type.convertToDefaultType(this.session, object);
                        break;
                    }
                }
                catch (HsqlException hsqlException) {
                    throw JDBCUtil.sqlException(hsqlException);
                }
                throw JDBCUtil.sqlException(5563);
            }
            case 50: {
                if (object instanceof Array) {
                    this.setArray(n, (Array)object);
                    return;
                }
                if (object instanceof ArrayList) {
                    object = ((ArrayList)object).toArray();
                }
                if (object instanceof Object[]) {
                    Type type2 = type.collectionBaseType();
                    Object object2 = object;
                    Object[] objectArray = new Object[((Object[])object2).length];
                    for (int i = 0; i < objectArray.length; ++i) {
                        objectArray[i] = type2.convertJavaToSQL(this.session, object2[i]);
                    }
                    object = objectArray;
                    break;
                }
                throw JDBCUtil.sqlException(5563);
            }
            case 30: {
                this.setBlobParameter(n, object);
                return;
            }
            case 40: {
                this.setClobParameter(n, object);
                return;
            }
            case 91: 
            case 92: 
            case 93: 
            case 94: 
            case 95: {
                try {
                    if (object instanceof String) {
                        object = type.convertToType(this.session, object, Type.SQL_VARCHAR);
                        break;
                    }
                    object = type.convertJavaToSQL(this.session, object);
                    break;
                }
                catch (HsqlException hsqlException) {
                    throw JDBCUtil.sqlException(hsqlException);
                }
            }
            case -6: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 25: {
                try {
                    if (object instanceof String) {
                        object = type.convertToType(this.session, object, Type.SQL_VARCHAR);
                        break;
                    }
                    if (object instanceof Boolean) {
                        boolean bl = (Boolean)object;
                        object = bl ? Integer.valueOf(1) : Integer.valueOf(0);
                    }
                    object = type.convertToDefaultType(this.session, object);
                    break;
                }
                catch (HsqlException hsqlException) {
                    throw JDBCUtil.sqlException(hsqlException);
                }
            }
            case 12: {
                if (object instanceof String) break;
                try {
                    object = type.convertToDefaultType(this.session, object);
                    break;
                }
                catch (HsqlException hsqlException) {
                    throw JDBCUtil.sqlException(hsqlException);
                }
            }
            case 1: {
                if (object instanceof String) break;
                if (type.precision == 1L) {
                    if (object instanceof Character) {
                        object = String.valueOf(((Character)object).charValue());
                        break;
                    }
                    if (object instanceof Boolean) {
                        object = (Boolean)object != false ? "1" : "0";
                        break;
                    }
                }
                try {
                    object = type.convertToDefaultType(this.session, object);
                    break;
                }
                catch (HsqlException hsqlException) {
                    throw JDBCUtil.sqlException(hsqlException);
                }
            }
            default: {
                try {
                    if (type.isIntervalType()) {
                        object = type.convertJavaToSQL(this.session, object);
                        break;
                    }
                    object = type.convertToDefaultType(this.session, object);
                    break;
                }
                catch (HsqlException hsqlException) {
                    throw JDBCUtil.sqlException(hsqlException);
                }
            }
        }
        this.parameterValues[n2] = object;
        this.parameterSet[n2] = true;
    }

    void setClobParameter(int n, Object object) throws SQLException {
        this.setClobParameter(n, object, 0L);
    }

    void setClobParameter(int n, Object object, long l) throws SQLException {
        if (object instanceof JDBCClobClient) {
            JDBCClobClient jDBCClobClient = (JDBCClobClient)object;
            if (!jDBCClobClient.session.getDatabaseUniqueName().equals(this.session.getDatabaseUniqueName())) {
                l = jDBCClobClient.length();
                Reader reader = jDBCClobClient.getCharacterStream();
                this.parameterValues[n - 1] = reader;
                this.streamLengths[n - 1] = l;
                this.parameterSet[n - 1] = true;
                return;
            }
            this.parameterValues[n - 1] = object;
            this.parameterSet[n - 1] = Boolean.TRUE;
            return;
        }
        if (object instanceof Clob) {
            this.parameterValues[n - 1] = object;
            this.parameterSet[n - 1] = Boolean.TRUE;
            return;
        }
        if (object instanceof ClobInputStream) {
            ClobInputStream clobInputStream = (ClobInputStream)object;
            if (clobInputStream.session.getDatabaseUniqueName().equals(this.session.getDatabaseUniqueName())) {
                throw JDBCUtil.sqlException(423, "invalid Reader");
            }
            this.parameterValues[n - 1] = object;
            this.streamLengths[n - 1] = l;
            this.parameterSet[n - 1] = true;
            return;
        }
        if (object instanceof Reader) {
            this.parameterValues[n - 1] = object;
            this.streamLengths[n - 1] = l;
            this.parameterSet[n - 1] = true;
            return;
        }
        if (object instanceof String) {
            JDBCClob jDBCClob = new JDBCClob((String)object);
            this.parameterValues[n - 1] = jDBCClob;
            this.parameterSet[n - 1] = true;
            return;
        }
        throw JDBCUtil.invalidArgument();
    }

    void setBlobParameter(int n, Object object) throws SQLException {
        this.setBlobParameter(n, object, 0L);
    }

    void setBlobParameter(int n, Object object, long l) throws SQLException {
        if (object instanceof JDBCBlobClient) {
            JDBCBlobClient jDBCBlobClient = (JDBCBlobClient)object;
            if (!jDBCBlobClient.session.getDatabaseUniqueName().equals(this.session.getDatabaseUniqueName())) {
                l = jDBCBlobClient.length();
                InputStream inputStream = jDBCBlobClient.getBinaryStream();
                this.parameterValues[n - 1] = inputStream;
                this.streamLengths[n - 1] = l;
                this.parameterSet[n - 1] = true;
                return;
            }
            this.parameterValues[n - 1] = object;
            this.parameterSet[n - 1] = Boolean.TRUE;
            return;
        }
        if (object instanceof Blob) {
            this.parameterValues[n - 1] = object;
            this.parameterSet[n - 1] = true;
            return;
        }
        if (object instanceof BlobInputStream) {
            BlobInputStream blobInputStream = (BlobInputStream)object;
            if (blobInputStream.session.getDatabaseUniqueName().equals(this.session.getDatabaseUniqueName())) {
                throw JDBCUtil.sqlException(423, "invalid Reader");
            }
            this.parameterValues[n - 1] = object;
            this.streamLengths[n - 1] = l;
            this.parameterSet[n - 1] = true;
            return;
        }
        if (object instanceof InputStream) {
            this.parameterValues[n - 1] = object;
            this.streamLengths[n - 1] = l;
            this.parameterSet[n - 1] = true;
            return;
        }
        if (object instanceof byte[]) {
            JDBCBlob jDBCBlob = new JDBCBlob((byte[])object);
            this.parameterValues[n - 1] = jDBCBlob;
            this.parameterSet[n - 1] = true;
            return;
        }
        throw JDBCUtil.invalidArgument();
    }

    void setIntParameter(int n, int n2) throws SQLException {
        this.checkSetParameterIndex(n);
        int n3 = n - 1;
        int n4 = this.parameterTypes[n3].typeCode;
        switch (n4) {
            case -6: 
            case 4: 
            case 5: {
                Integer n5 = n2;
                this.parameterValues[n3] = n5;
                this.parameterSet[n3] = true;
                break;
            }
            case 25: {
                Long l = n2;
                this.parameterValues[n3] = l;
                this.parameterSet[n3] = true;
                break;
            }
            case 60: 
            case 61: 
            case 1111: {
                throw JDBCUtil.sqlException(5563);
            }
            default: {
                this.setParameter(n, n2);
            }
        }
    }

    void setLongParameter(int n, long l) throws SQLException {
        this.checkSetParameterIndex(n);
        int n2 = n - 1;
        int n3 = this.parameterTypes[n2].typeCode;
        switch (n3) {
            case 25: {
                Long l2 = l;
                this.parameterValues[n2] = l2;
                this.parameterSet[n2] = true;
                break;
            }
            case 60: 
            case 61: 
            case 1111: {
                throw JDBCUtil.sqlException(5563);
            }
            default: {
                this.setParameter(n, l);
            }
        }
    }

    private void performPreExecute() throws SQLException, HsqlException {
        if (!this.hasLOBs) {
            return;
        }
        for (int i = 0; i < this.parameterValues.length; ++i) {
            ResultLob resultLob;
            Closeable closeable;
            ResultLob resultLob2;
            Closeable closeable2;
            long l;
            long l2;
            LobData lobData;
            Object object = this.parameterValues[i];
            if (object == null) continue;
            if (this.parameterTypes[i].typeCode == 30) {
                lobData = null;
                if (object instanceof JDBCBlobClient) {
                    lobData = ((JDBCBlobClient)object).blob;
                    l2 = ((BlobDataID)lobData).getId();
                } else if (object instanceof Blob) {
                    l = ((Blob)object).length();
                    lobData = this.session.createBlob(l);
                    l2 = ((BlobDataID)lobData).getId();
                    closeable2 = ((Blob)object).getBinaryStream();
                    resultLob2 = ResultLob.newLobCreateBlobRequest(this.session.getId(), l2, (InputStream)closeable2, l);
                    this.session.allocateResultLob(resultLob2);
                    this.resultOut.addLobResult(resultLob2);
                } else if (object instanceof InputStream) {
                    l = this.streamLengths[i];
                    long l3 = l > 0L ? l : 0L;
                    lobData = this.session.createBlob(l3);
                    l2 = ((BlobDataID)lobData).getId();
                    closeable = (InputStream)object;
                    resultLob = ResultLob.newLobCreateBlobRequest(this.session.getId(), l2, closeable, l);
                    this.session.allocateResultLob(resultLob);
                    this.resultOut.addLobResult(resultLob);
                } else if (object instanceof BlobDataID) {
                    lobData = (BlobDataID)object;
                }
                this.parameterValues[i] = lobData;
                continue;
            }
            if (this.parameterTypes[i].typeCode != 40) continue;
            lobData = null;
            if (object instanceof JDBCClobClient) {
                lobData = ((JDBCClobClient)object).clob;
                l2 = ((ClobDataID)lobData).getId();
            } else if (object instanceof Clob) {
                l = ((Clob)object).length();
                closeable2 = ((Clob)object).getCharacterStream();
                lobData = this.session.createClob(l);
                l2 = ((ClobDataID)lobData).getId();
                resultLob2 = ResultLob.newLobCreateClobRequest(this.session.getId(), l2, closeable2, l);
                this.session.allocateResultLob(resultLob2);
                this.resultOut.addLobResult(resultLob2);
            } else if (object instanceof Reader) {
                l = this.streamLengths[i];
                long l4 = l > 0L ? l : 0L;
                lobData = this.session.createClob(l4);
                l2 = ((ClobDataID)lobData).getId();
                closeable = (Reader)object;
                resultLob = ResultLob.newLobCreateClobRequest(this.session.getId(), l2, (Reader)closeable, l);
                this.session.allocateResultLob(resultLob);
                this.resultOut.addLobResult(resultLob);
            } else if (object instanceof ClobDataID) {
                lobData = (ClobDataID)object;
            }
            this.parameterValues[i] = lobData;
        }
    }

    void fetchResult() throws SQLException {
        if (this.isClosed || this.connection.isClosed) {
            this.checkClosed();
        }
        this.closeResultData();
        this.checkParametersSet();
        if (this.isBatch) {
            throw JDBCUtil.sqlExceptionSQL(1255);
        }
        if (this.isResult) {
            this.resultOut.setPreparedResultUpdateProperties(this.parameterValues);
        } else {
            this.resultOut.setPreparedExecuteProperties(this.parameterValues, this.maxRows, this.fetchSize, this.rsProperties, this.queryTimeout);
        }
        try {
            this.performPreExecute();
            this.resultIn = this.session.execute(this.resultOut);
        }
        catch (HsqlException hsqlException) {
            throw JDBCUtil.sqlException(hsqlException);
        }
        finally {
            this.performPostExecute();
        }
        if (this.resultIn.mode == 2) {
            throw JDBCUtil.sqlException(this.resultIn);
        }
        if (this.resultIn.isData()) {
            this.currentResultSet = new JDBCResultSet(this.connection, this, this.resultIn, this.resultIn.metaData);
        } else if (this.statementRetType == 2) {
            this.getMoreResults();
        }
    }

    @Override
    void performPostExecute() throws SQLException {
        super.performPostExecute();
    }

    public String getSQL() {
        return this.sql;
    }

    public long getStatementID() {
        return this.statementID;
    }

    public boolean isRowCount() {
        return this.statementRetType == 1;
    }

    public JDBCResultSetMetaData getResultSetMetaData() {
        return this.resultSetMetaData;
    }

    public ResultMetaData getParameterMetaDataDirect() {
        return this.parameterMetaData;
    }
}

