/*
 * Decompiled with CFR 0.152.
 */
package org.apache.yoko.rmi.impl;

import java.io.Externalizable;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.rmi.AccessException;
import java.rmi.MarshalException;
import java.rmi.NoSuchObjectException;
import java.rmi.RMISecurityManager;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.rmi.ServerError;
import java.rmi.ServerException;
import java.rmi.server.RMIClassLoader;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.rmi.CORBA.Stub;
import javax.rmi.CORBA.Tie;
import javax.rmi.CORBA.Util;
import javax.rmi.CORBA.UtilDelegate;
import javax.rmi.CORBA.ValueHandler;
import javax.rmi.PortableRemoteObject;
import javax.transaction.InvalidTransactionException;
import javax.transaction.TransactionRequiredException;
import javax.transaction.TransactionRolledbackException;
import org.apache.yoko.osgi.ProviderLocator;
import org.apache.yoko.rmi.impl.CopyRecursionException;
import org.apache.yoko.rmi.impl.CopyState;
import org.apache.yoko.rmi.impl.PortableRemoteObjectImpl;
import org.apache.yoko.rmi.impl.RMIState;
import org.apache.yoko.rmi.impl.RMIStub;
import org.apache.yoko.rmi.impl.RemoteDescriptor;
import org.apache.yoko.rmi.impl.TypeRepository;
import org.apache.yoko.rmi.util.GetSystemPropertyAction;
import org.omg.CORBA.Any;
import org.omg.CORBA.BAD_PARAM;
import org.omg.CORBA.COMM_FAILURE;
import org.omg.CORBA.INVALID_TRANSACTION;
import org.omg.CORBA.INV_OBJREF;
import org.omg.CORBA.MARSHAL;
import org.omg.CORBA.NO_IMPLEMENT;
import org.omg.CORBA.NO_PERMISSION;
import org.omg.CORBA.OBJECT_NOT_EXIST;
import org.omg.CORBA.ORB;
import org.omg.CORBA.Object;
import org.omg.CORBA.SystemException;
import org.omg.CORBA.TRANSACTION_REQUIRED;
import org.omg.CORBA.TRANSACTION_ROLLEDBACK;
import org.omg.CORBA.TypeCode;
import org.omg.CORBA.TypeCodePackage.BadKind;
import org.omg.CORBA.portable.IDLEntity;
import org.omg.CORBA.portable.ObjectImpl;
import org.omg.CORBA.portable.UnknownException;
import org.omg.CORBA_2_3.portable.InputStream;
import org.omg.CORBA_2_3.portable.OutputStream;
import org.omg.CosTransactions.HeuristicCommit;
import org.omg.CosTransactions.HeuristicMixed;
import org.omg.CosTransactions.HeuristicRollback;
import org.omg.CosTransactions.SubtransactionsUnavailable;

public class UtilImpl
implements UtilDelegate {
    static final Logger logger;
    private static final SecMan _secman;
    static final Class JAVAX_TRANSACTION_USERTRANSACTION_CLASS;
    static boolean copy_with_corba;
    static final java.lang.Object READ_SERIALIZABLE_KEY;
    static final Class[] RMI_TO_CORBA_EXCEPTION;
    static final Class[] CORBA_TO_RMI_EXCEPTION;
    static final Map CORBA_TO_RMI_MAP;

    public RemoteException mapSystemException(SystemException theException) {
        Class<?> exclass;
        String name;
        Class exclz;
        SystemException ex = theException;
        if (ex instanceof UnknownException) {
            Throwable orig = ((UnknownException)((java.lang.Object)ex)).originalEx;
            if (orig instanceof Error) {
                return new ServerError("Error occurred in server thread", (Error)orig);
            }
            if (orig instanceof RemoteException) {
                return new ServerException("RemoteException occurred in server thread", (Exception)orig);
            }
            if (orig instanceof RuntimeException) {
                throw (RuntimeException)orig;
            }
        }
        if ((exclz = (Class)CORBA_TO_RMI_MAP.get(name = (exclass = ((java.lang.Object)((java.lang.Object)ex)).getClass()).getName())) == null) {
            exclz = RemoteException.class;
            Class<?> exc = ((java.lang.Object)((java.lang.Object)ex)).getClass();
            for (int i = 0; i < CORBA_TO_RMI_EXCEPTION.length; i += 2) {
                if (!CORBA_TO_RMI_EXCEPTION[i].isAssignableFrom(exc)) continue;
                exclz = CORBA_TO_RMI_EXCEPTION[i + 1];
                break;
            }
        }
        RemoteException rex = null;
        StringBuffer buf = new StringBuffer("CORBA ");
        String prefix = "org.omg.CORBA";
        if (name.startsWith("org.omg.CORBA")) {
            buf.append(name.substring("org.omg.CORBA".length() + 1));
        } else {
            buf.append(name);
        }
        buf.append(" ");
        buf.append(ex.minor);
        switch (ex.completed.value()) {
            case 0: {
                buf.append(" Yes");
                break;
            }
            case 1: {
                buf.append(" No");
                break;
            }
            case 2: {
                buf.append(" Maybe");
            }
        }
        String exceptionMessage = buf.toString();
        try {
            rex = (RemoteException)this.newInstance(exclz, new Class[]{String.class}, new java.lang.Object[]{exceptionMessage});
            rex.detail = ex;
        }
        catch (RuntimeException ex2) {
            rex = new RemoteException(exceptionMessage, ex2);
        }
        return rex;
    }

    static SystemException mapRemoteException(RemoteException rex) {
        if (rex.detail != null && rex.detail instanceof SystemException) {
            return (SystemException)rex.detail;
        }
        if (rex.detail != null && rex.detail instanceof RemoteException) {
            rex = (RemoteException)rex.detail;
        }
        if (rex instanceof NoSuchObjectException) {
            throw new INV_OBJREF(rex.getMessage());
        }
        if (rex instanceof AccessException) {
            throw new NO_PERMISSION(rex.getMessage());
        }
        if (rex instanceof MarshalException) {
            throw new MARSHAL(rex.getMessage());
        }
        if (rex instanceof TransactionRequiredException) {
            throw new TRANSACTION_REQUIRED(rex.getMessage());
        }
        if (rex instanceof TransactionRolledbackException) {
            throw new TRANSACTION_ROLLEDBACK(rex.getMessage());
        }
        if (rex instanceof InvalidTransactionException) {
            throw new INVALID_TRANSACTION(rex.getMessage());
        }
        throw new UnknownException((Throwable)rex);
    }

    private java.lang.Object newInstance(final Class cls, final Class[] arg_types, final java.lang.Object[] args) {
        return AccessController.doPrivileged(new PrivilegedAction(){

            public java.lang.Object run() {
                try {
                    Constructor cons = cls.getConstructor(arg_types);
                    return cons.newInstance(args);
                }
                catch (NoSuchMethodException ex) {
                    return new RuntimeException("cannot instantiate " + cls + ": " + ex.getMessage(), ex);
                }
                catch (InstantiationException ex) {
                    return new RuntimeException("cannot instantiate " + cls + ": " + ex.getMessage(), ex);
                }
                catch (IllegalAccessException ex) {
                    return new RuntimeException("cannot instantiate " + cls + ": " + ex.getMessage(), ex);
                }
                catch (IllegalArgumentException ex) {
                    return new RuntimeException("cannot instantiate " + cls + ": " + ex.getMessage(), ex);
                }
                catch (InvocationTargetException ex) {
                    return new RuntimeException("cannot instantiate " + cls + ": " + ex.getMessage(), ex);
                }
            }
        });
    }

    public void writeAny(org.omg.CORBA.portable.OutputStream out, java.lang.Object obj) throws SystemException {
        ORB orb = ORB.init();
        Any any = orb.create_any();
        if (obj == null) {
            any.insert_Value(null);
        } else if (obj instanceof String) {
            any.insert_Value((Serializable)((java.lang.Object)((String)obj)));
        } else if (obj instanceof Object) {
            any.insert_Object((Object)obj);
        } else if (obj instanceof Any) {
            any.insert_any((Any)obj);
        } else if (obj instanceof IDLEntity) {
            any.insert_Value((Serializable)obj);
        } else if (obj instanceof Remote) {
            Object corba_obj;
            Remote ro = (Remote)obj;
            try {
                corba_obj = (Object)PortableRemoteObject.toStub((Remote)ro);
            }
            catch (NoSuchObjectException ex) {
                throw (MARSHAL)new MARSHAL("object not exported " + ro).initCause((Throwable)ex);
            }
            any.insert_Object(corba_obj);
        } else if (obj instanceof Serializable || obj instanceof Externalizable) {
            any.insert_Value((Serializable)obj);
        } else {
            throw new MARSHAL("cannot write as " + obj.getClass() + " to an Any");
        }
        out.write_any(any);
    }

    public java.lang.Object readAny(org.omg.CORBA.portable.InputStream in) throws SystemException {
        Any any = in.read_any();
        TypeCode typecode = any.type();
        switch (typecode.kind().value()) {
            case 0: 
            case 1: {
                return null;
            }
            case 29: 
            case 30: {
                return any.extract_Value();
            }
            case 32: {
                InputStream in23 = (InputStream)any.create_input_stream();
                return in23.read_abstract_interface();
            }
            case 18: {
                return any.extract_string();
            }
            case 14: {
                Object ref = any.extract_Object();
                return ref;
            }
            case 11: {
                return any.extract_any();
            }
        }
        String id = "<unknown>";
        try {
            id = typecode.id();
        }
        catch (BadKind ex) {
            // empty catch block
        }
        throw new MARSHAL("cannot extract " + id + " (" + typecode.kind().value() + ") value from Any");
    }

    public void writeRemoteObject(org.omg.CORBA.portable.OutputStream out, java.lang.Object obj) throws SystemException {
        Object objref = null;
        if (obj == null) {
            out.write_Object(null);
            return;
        }
        if (obj instanceof Object) {
            objref = (Object)obj;
        } else if (obj instanceof Remote) {
            try {
                objref = (Stub)PortableRemoteObject.toStub((Remote)((Remote)obj));
            }
            catch (NoSuchObjectException ex) {
                // empty catch block
            }
            if (objref == null) {
                try {
                    PortableRemoteObject.exportObject((Remote)((Remote)obj));
                    objref = (Stub)PortableRemoteObject.toStub((Remote)((Remote)obj));
                }
                catch (RemoteException ex) {
                    throw (MARSHAL)new MARSHAL("cannot convert Remote to Object").initCause((Throwable)ex);
                }
            }
        } else {
            throw new MARSHAL("object is neither Remote nor org.omg.CORBA.Object: " + obj.getClass().getName());
        }
        out.write_Object(objref);
    }

    public void writeAbstractObject(org.omg.CORBA.portable.OutputStream out, java.lang.Object obj) {
        logger.finer("writeAbstractObject.1  out=" + out);
        if (!(obj instanceof Object) && !(obj instanceof Serializable) && obj instanceof Remote) {
            Object objref = null;
            try {
                objref = (Object)PortableRemoteObject.toStub((Remote)((Remote)obj));
            }
            catch (NoSuchObjectException ex) {
                // empty catch block
            }
            if (objref == null) {
                try {
                    PortableRemoteObject.exportObject((Remote)((Remote)obj));
                    objref = (Object)PortableRemoteObject.toStub((Remote)((Remote)obj));
                }
                catch (RemoteException ex) {
                    throw (MARSHAL)new MARSHAL("unable to export object").initCause((Throwable)ex);
                }
            }
            obj = objref;
        }
        OutputStream out_ = (OutputStream)out;
        logger.finer("writeAbstractObject.2  out=" + out);
        out_.write_abstract_interface(obj);
    }

    protected Map tie_map() {
        return RMIState.current().tie_map;
    }

    public void registerTarget(Tie tie, Remote obj) {
        if (obj == null) {
            throw new IllegalArgumentException("remote object is null");
        }
        tie.setTarget(obj);
        this.tie_map().put(obj, tie);
    }

    public Tie getTie(Remote obj) {
        if (obj == null) {
            return null;
        }
        return (Tie)this.tie_map().get(obj);
    }

    public ValueHandler createValueHandler() {
        return RMIState.current().createValueHandler();
    }

    public String getCodebase(Class clz) {
        if (clz == null) {
            return null;
        }
        if (clz.isArray()) {
            return this.getCodebase(clz.getComponentType());
        }
        if (clz.isPrimitive()) {
            return null;
        }
        ClassLoader theLoader = clz.getClassLoader();
        if (theLoader == null) {
            return null;
        }
        if (theLoader == java.lang.Object.class.getClassLoader()) {
            return null;
        }
        if (JAVAX_TRANSACTION_USERTRANSACTION_CLASS != null && theLoader == JAVAX_TRANSACTION_USERTRANSACTION_CLASS.getClassLoader()) {
            return null;
        }
        RMIState state = RMIState.current();
        ClassLoader stateLoader = state.getClassLoader();
        try {
            URL codebaseURL;
            if (clz.equals(stateLoader.loadClass(clz.getName())) && (codebaseURL = state.getCodeBase()) != null) {
                logger.finer("class " + clz.getName() + " => " + codebaseURL);
                return codebaseURL.toString();
            }
        }
        catch (ClassNotFoundException ex) {
            // empty catch block
        }
        return (String)AccessController.doPrivileged(new GetSystemPropertyAction("java.rmi.server.codebase"));
    }

    private static SecMan getSecMan() {
        try {
            return (SecMan)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public java.lang.Object run() {
                    return new SecMan();
                }
            });
        }
        catch (PrivilegedActionException e) {
            throw new RuntimeException(e);
        }
    }

    public Class loadClass(String name, String codebase, ClassLoader loader) throws ClassNotFoundException {
        try {
            return UtilImpl.loadClass0(name, codebase, loader);
        }
        catch (ClassNotFoundException ex) {
            logger.log(Level.FINER, "cannot load from " + codebase + " " + ex.getMessage(), ex);
            throw ex;
        }
    }

    public static Class loadClass0(String name, String codebase, ClassLoader loader) throws ClassNotFoundException {
        try {
            return ProviderLocator.loadClass((String)name, null, (ClassLoader)loader);
        }
        catch (ClassNotFoundException e) {
            Class<?> result = null;
            ClassLoader stackLoader = null;
            ClassLoader thisLoader = Util.class.getClassLoader();
            Class[] stack = _secman.getClassContext();
            for (int i = 1; i < stack.length; ++i) {
                ClassLoader testLoader = stack[i].getClassLoader();
                if (testLoader == null || testLoader == thisLoader) continue;
                stackLoader = thisLoader;
                break;
            }
            if (stackLoader != null) {
                try {
                    result = stackLoader.loadClass(name);
                }
                catch (ClassNotFoundException ex) {
                    // empty catch block
                }
                if (result != null) {
                    return result;
                }
            }
            if (thisLoader != null) {
                try {
                    result = thisLoader.loadClass(name);
                }
                catch (ClassNotFoundException ex) {
                    // empty catch block
                }
                if (result != null) {
                    return result;
                }
            }
            if (codebase != null && !"".equals(codebase) && !Boolean.getBoolean("java.rmi.server.useCodeBaseOnly")) {
                try {
                    logger.finer("trying RMIClassLoader");
                    URLClassLoader url_loader = new URLClassLoader(new URL[]{new URL(codebase)}, loader);
                    result = url_loader.loadClass(name);
                }
                catch (ClassNotFoundException ex) {
                    logger.log(Level.FINER, "RMIClassLoader says " + ex.getMessage(), ex);
                }
                catch (MalformedURLException ex) {
                    logger.log(Level.FINER, "RMIClassLoader says " + ex.getMessage(), ex);
                    logger.finer("FAILED class download " + name + " from " + codebase + " " + ex.getMessage());
                }
                catch (RuntimeException ex) {
                    logger.log(Level.FINER, "FAILED class download " + name + " from " + codebase + " " + ex.getMessage(), ex);
                }
                if (result != null) {
                    return result;
                }
            } else {
                codebase = (String)AccessController.doPrivileged(new GetSystemPropertyAction("java.rmi.server.codebase"));
                if (codebase != null) {
                    try {
                        result = RMIClassLoader.loadClass(codebase, name);
                    }
                    catch (ClassNotFoundException ex) {
                    }
                    catch (MalformedURLException ex) {
                        // empty catch block
                    }
                    if (result != null) {
                        return result;
                    }
                }
            }
            if (loader == null) {
                loader = UtilImpl.getContextClassLoader();
            }
            try {
                result = loader.loadClass(name);
            }
            catch (ClassNotFoundException ex) {
                logger.log(Level.FINER, "LocalLoader says " + ex.getMessage(), ex);
            }
            if (result != null) {
                return result;
            }
            throw new ClassNotFoundException(name);
        }
    }

    public boolean isLocal(Stub stub) throws RemoteException {
        try {
            if (stub instanceof RMIStub) {
                return true;
            }
            return stub._is_local();
        }
        catch (SystemException ex) {
            throw this.mapSystemException(ex);
        }
    }

    public RemoteException wrapException(Throwable ex) {
        if (ex instanceof Error) {
            return new ServerError(ex.getMessage(), (Error)ex);
        }
        if (ex instanceof RemoteException) {
            return new ServerException(ex.getMessage(), (Exception)ex);
        }
        if (ex instanceof UnknownException) {
            UnknownException uex = (UnknownException)ex;
            return new ServerError(ex.getMessage(), uex.originalEx instanceof Error ? (Error)uex.originalEx : new Error("[OTHER EXCEPTION] " + ex.getMessage()));
        }
        if (ex instanceof SystemException) {
            return this.mapSystemException((SystemException)ex);
        }
        if (ex instanceof RuntimeException) {
            throw (RuntimeException)ex;
        }
        return new RemoteException(ex.getMessage(), ex);
    }

    static ClassLoader getContextClassLoader() {
        return (ClassLoader)AccessController.doPrivileged(new PrivilegedAction(){

            public java.lang.Object run() {
                return Thread.currentThread().getContextClassLoader();
            }
        });
    }

    static ClassLoader getClassLoader(final Class clz) {
        if (System.getSecurityManager() == null) {
            return clz.getClassLoader();
        }
        return (ClassLoader)AccessController.doPrivileged(new PrivilegedAction(){

            public java.lang.Object run() {
                return clz.getClassLoader();
            }
        });
    }

    static java.lang.Object copyRMIStub(RMIStub stub) throws RemoteException {
        Class targetClass;
        ClassLoader loader = UtilImpl.getContextClassLoader();
        if (UtilImpl.getClassLoader(stub._descriptor.getJavaClass()) == loader) {
            return stub;
        }
        RemoteDescriptor desc = stub._descriptor;
        try {
            targetClass = Util.loadClass((String)desc.getJavaClass().getName(), (String)stub._get_codebase(), (ClassLoader)loader);
        }
        catch (ClassNotFoundException ex) {
            logger.log(Level.FINER, "copyRMIStub exception (current loader is: " + loader + ") " + ex.getMessage(), ex);
            throw new RemoteException("Class not found", ex);
        }
        return PortableRemoteObjectImpl.narrow1(RMIState.current(), (ObjectImpl)stub, targetClass);
    }

    public java.lang.Object copyObject(java.lang.Object obj, ORB orb) throws RemoteException {
        if (obj == null) {
            return null;
        }
        if (orb == null) {
            throw new NullPointerException();
        }
        if (obj instanceof String || obj instanceof Number) {
            return obj;
        }
        if (obj instanceof RMIStub) {
            return UtilImpl.copyRMIStub((RMIStub)((java.lang.Object)obj));
        }
        try {
            TypeRepository rep = RMIState.current().getTypeRepository();
            CopyState state = new CopyState(rep);
            return state.copy(obj);
        }
        catch (CopyRecursionException ex) {
            throw new MarshalException("unable to resolve recursion", ex);
        }
        catch (SystemException ex) {
            throw this.mapSystemException(ex);
        }
    }

    public java.lang.Object[] copyObjects(java.lang.Object[] objs, ORB orb) throws RemoteException {
        if (objs == null || orb == null) {
            throw new NullPointerException();
        }
        if (objs.length == 0) {
            return objs;
        }
        try {
            TypeRepository rep = RMIState.current().getTypeRepository();
            CopyState state = new CopyState(rep);
            try {
                return (java.lang.Object[])state.copy(objs);
            }
            catch (CopyRecursionException ex) {
                throw new MarshalException("unable to resolve recursion", ex);
            }
        }
        catch (SystemException ex) {
            throw this.mapSystemException(ex);
        }
    }

    public void unexportObject(Remote obj) throws NoSuchObjectException {
        if (obj == null) {
            return;
        }
        Map tie_map = this.tie_map();
        if (tie_map == null) {
            return;
        }
        Tie tie = (Tie)tie_map.remove(obj);
        if (tie == null) {
            logger.fine("unexporting unknown instance of " + obj.getClass().getName() + " from " + RMIState.current().getName());
            return;
        }
        logger.finer("unexporting instance of " + obj.getClass().getName() + " from " + RMIState.current().getName());
        tie.deactivate();
    }

    static {
        Class[] rmiToCorba;
        Class userTransactionClass;
        logger = Logger.getLogger(UtilImpl.class.getName());
        _secman = UtilImpl.getSecMan();
        try {
            userTransactionClass = Util.loadClass((String)"javax.transaction.userTransaction", null, null);
        }
        catch (ClassNotFoundException e) {
            logger.log(Level.FINE, "error loading transaction class", e);
            userTransactionClass = null;
        }
        JAVAX_TRANSACTION_USERTRANSACTION_CLASS = userTransactionClass;
        copy_with_corba = false;
        READ_SERIALIZABLE_KEY = new java.lang.Object();
        try {
            rmiToCorba = new Class[]{Util.loadClass((String)"javax.transaction.HeuristicMixedException", null, null), HeuristicMixed.class, Util.loadClass((String)"javax.transaction.HeuristicRollbackException", null, null), HeuristicRollback.class, Util.loadClass((String)"javax.transaction.HeuristicCommitException", null, null), HeuristicCommit.class, Util.loadClass((String)"javax.transaction.NotSupportedException", null, null), SubtransactionsUnavailable.class, Util.loadClass((String)"javax.transaction.InvalidTransactionException", null, null), INVALID_TRANSACTION.class, Util.loadClass((String)"javax.transaction.TransactionRequiredException", null, null), TRANSACTION_REQUIRED.class, Util.loadClass((String)"javax.transaction.TransactionRolledbackException", null, null), TRANSACTION_ROLLEDBACK.class, Util.loadClass((String)"javax.transaction.RollbackException", null, null), TRANSACTION_ROLLEDBACK.class};
        }
        catch (ClassNotFoundException e) {
            rmiToCorba = new Class[]{};
        }
        RMI_TO_CORBA_EXCEPTION = rmiToCorba;
        CORBA_TO_RMI_EXCEPTION = new Class[]{BAD_PARAM.class, MarshalException.class, COMM_FAILURE.class, MarshalException.class, INV_OBJREF.class, NoSuchObjectException.class, MARSHAL.class, MarshalException.class, NO_IMPLEMENT.class, NoSuchObjectException.class, NO_PERMISSION.class, AccessException.class, OBJECT_NOT_EXIST.class, NoSuchObjectException.class, TRANSACTION_REQUIRED.class, TransactionRequiredException.class, TRANSACTION_ROLLEDBACK.class, TransactionRolledbackException.class, INVALID_TRANSACTION.class, InvalidTransactionException.class};
        CORBA_TO_RMI_MAP = new HashMap();
        for (int i = 0; i < CORBA_TO_RMI_EXCEPTION.length; i += 2) {
            Class corba = CORBA_TO_RMI_EXCEPTION[i];
            Class rmi = CORBA_TO_RMI_EXCEPTION[i + 1];
            CORBA_TO_RMI_MAP.put(corba.getName(), rmi);
        }
    }

    static class SecMan
    extends RMISecurityManager {
        SecMan() {
        }

        public Class[] getClassContext() {
            return super.getClassContext();
        }
    }
}

