/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.renderkit;

import com.sun.faces.config.WebConfiguration;
import com.sun.faces.renderkit.ClientSideStateHelper;
import com.sun.faces.renderkit.RenderKitUtils;
import com.sun.faces.renderkit.ServerSideStateHelper;
import com.sun.faces.renderkit.StateHelper;
import com.sun.faces.util.RequestStateManager;
import jakarta.faces.FacesException;
import jakarta.faces.context.FacesContext;
import jakarta.faces.render.ResponseStateManager;
import java.io.IOException;

public class ResponseStateManagerImpl
extends ResponseStateManager {
    private StateHelper helper;

    public ResponseStateManagerImpl() {
        WebConfiguration webConfig = WebConfiguration.getInstance();
        String stateMode = webConfig.getOptionValue(WebConfiguration.WebContextInitParameter.StateSavingMethod);
        this.helper = "client".equalsIgnoreCase(stateMode) ? new ClientSideStateHelper() : new ServerSideStateHelper();
    }

    @Override
    public boolean isPostback(FacesContext context) {
        return context.getExternalContext().getRequestParameterMap().containsKey(RenderKitUtils.PredefinedPostbackParameter.VIEW_STATE_PARAM.getName(context));
    }

    @Override
    public String getCryptographicallyStrongTokenFromSession(FacesContext context) {
        return this.helper.getCryptographicallyStrongTokenFromSession(context);
    }

    @Override
    public Object getState(FacesContext context, String viewId) {
        Object state = RequestStateManager.get(context, "com.sun.faces.FACES_VIEW_STATE");
        if (state == null) {
            try {
                state = this.helper.getState(context, viewId);
                if (state != null) {
                    RequestStateManager.set(context, "com.sun.faces.FACES_VIEW_STATE", state);
                }
            }
            catch (IOException e) {
                throw new FacesException(e);
            }
        }
        return state;
    }

    @Override
    public void writeState(FacesContext context, Object state) throws IOException {
        this.helper.writeState(context, state, null);
    }

    @Override
    public String getViewState(FacesContext context, Object state) {
        StringBuilder sb = new StringBuilder(32);
        try {
            this.helper.writeState(context, state, sb);
        }
        catch (IOException e) {
            throw new FacesException(e);
        }
        return sb.toString();
    }

    @Override
    public Object getTreeStructureToRestore(FacesContext context, String viewId) {
        Object[] state = (Object[])this.getState(context, viewId);
        if (state != null) {
            return state[0];
        }
        return null;
    }

    @Override
    public boolean isStateless(FacesContext facesContext, String viewId) {
        return this.helper.isStateless(facesContext, viewId);
    }
}

