/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.application.resource;

import com.sun.faces.application.resource.ClientResourceInfo;
import com.sun.faces.application.resource.ContractInfo;
import com.sun.faces.application.resource.LibraryInfo;
import com.sun.faces.application.resource.ResourceHelper;
import com.sun.faces.application.resource.ResourceInfo;
import com.sun.faces.application.resource.ResourceManager;
import com.sun.faces.application.resource.ZipDirectoryEntryScanner;
import com.sun.faces.config.WebConfiguration;
import com.sun.faces.util.Util;
import jakarta.faces.application.ProjectStage;
import jakarta.faces.component.UIViewRoot;
import jakarta.faces.context.FacesContext;
import jakarta.faces.view.facelets.ResourceResolver;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

public class ClasspathResourceHelper
extends ResourceHelper {
    private static final String BASE_RESOURCE_PATH = "META-INF/resources";
    private boolean cacheTimestamp;
    private volatile ZipDirectoryEntryScanner libraryScanner;
    private boolean enableMissingResourceLibraryDetection;

    public ClasspathResourceHelper() {
        WebConfiguration webconfig = WebConfiguration.getInstance();
        this.cacheTimestamp = webconfig.isOptionEnabled(WebConfiguration.BooleanWebContextInitParameter.CacheResourceModificationTimestamp);
        this.enableMissingResourceLibraryDetection = webconfig.isOptionEnabled(WebConfiguration.BooleanWebContextInitParameter.EnableMissingResourceLibraryDetection);
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ClasspathResourceHelper other = (ClasspathResourceHelper)obj;
        if (this.cacheTimestamp != other.cacheTimestamp) {
            return false;
        }
        return this.enableMissingResourceLibraryDetection == other.enableMissingResourceLibraryDetection;
    }

    public int hashCode() {
        int hash = 5;
        hash = 67 * hash + (this.cacheTimestamp ? 1 : 0);
        hash = 67 * hash + (this.enableMissingResourceLibraryDetection ? 1 : 0);
        return hash;
    }

    @Override
    public String getBaseResourcePath() {
        return BASE_RESOURCE_PATH;
    }

    @Override
    public String getBaseContractsPath() {
        return WebConfiguration.META_INF_CONTRACTS_DIR;
    }

    @Override
    protected InputStream getNonCompressedInputStream(ResourceInfo resource, FacesContext ctx) throws IOException {
        InputStream in = null;
        if (ctx.isProjectStage(ProjectStage.Development)) {
            String path;
            ClassLoader loader = Util.getCurrentLoader(this.getClass());
            URL url = this.getResourceURL(loader, path = resource.getPath(), ctx);
            if (url != null) {
                in = url.openStream();
            }
        } else {
            ClassLoader loader = Util.getCurrentLoader(this.getClass());
            String path = resource.getPath();
            in = this.getResourceAsStream(loader, path, ctx);
        }
        return in;
    }

    @Override
    public URL getURL(ResourceInfo resource, FacesContext ctx) {
        ClassLoader loader;
        ResourceResolver nonDefaultResourceResolver = (ResourceResolver)ctx.getAttributes().get("com.sun.faces.NDRRPN");
        String path = resource.getPath();
        URL url = null;
        if (null != nonDefaultResourceResolver) {
            url = nonDefaultResourceResolver.resolveUrl(path);
        }
        if (null == url && (url = (loader = Util.getCurrentLoader(this.getClass())).getResource(path)) == null) {
            url = this.getClass().getClassLoader().getResource(resource.getPath());
        }
        return url;
    }

    @Override
    public LibraryInfo findLibrary(String libraryName, String localePrefix, String contract, FacesContext ctx) {
        ClassLoader loader = Util.getCurrentLoader(this);
        String basePath = localePrefix == null ? this.getBasePath(contract) + '/' + libraryName + '/' : this.getBasePath(contract) + '/' + localePrefix + '/' + libraryName + '/';
        URL basePathURL = loader.getResource(basePath);
        if (basePathURL == null && (basePathURL = this.getClass().getClassLoader().getResource(basePath)) == null) {
            return null;
        }
        return new LibraryInfo(libraryName, null, localePrefix, contract, this);
    }

    public LibraryInfo findLibraryWithZipDirectoryEntryScan(String libraryName, String localePrefix, String contract, FacesContext ctx, boolean forceScan) {
        ClassLoader loader = Util.getCurrentLoader(this);
        String basePath = localePrefix == null ? this.getBasePath(contract) + '/' + libraryName + '/' : this.getBasePath(contract) + '/' + localePrefix + '/' + libraryName + '/';
        URL basePathURL = loader.getResource(basePath);
        if (basePathURL == null && (basePathURL = this.getClass().getClassLoader().getResource(basePath)) == null) {
            if (null != localePrefix && libraryName.equals("jakarta.faces")) {
                return null;
            }
            if (this.enableMissingResourceLibraryDetection || forceScan) {
                if (null == this.libraryScanner) {
                    this.libraryScanner = new ZipDirectoryEntryScanner();
                }
                if (!this.libraryScanner.libraryExists(libraryName, localePrefix)) {
                    return null;
                }
            }
        }
        return new LibraryInfo(libraryName, null, localePrefix, contract, this);
    }

    @Override
    public ResourceInfo findResource(LibraryInfo library, String resourceName, String localePrefix, boolean compressable, FacesContext ctx) {
        ClientResourceInfo value;
        resourceName = this.trimLeadingSlash(resourceName);
        ContractInfo[] outContract = new ContractInfo[]{null};
        String[] outBasePath = new String[]{null};
        ClassLoader loader = Util.getCurrentLoader(this);
        URL basePathURL = this.findPathConsideringContracts(loader, library, resourceName, localePrefix, outContract, outBasePath, ctx);
        String basePath = outBasePath[0];
        if (null == basePathURL) {
            basePath = this.deriveBasePath(library, resourceName, localePrefix);
            basePathURL = loader.getResource(basePath);
        }
        if (null == basePathURL && (basePathURL = this.getClass().getClassLoader().getResource(basePath)) == null) {
            basePath = library != null ? library.getPath(null) + '/' + resourceName : this.getBaseResourcePath() + '/' + resourceName;
            basePathURL = loader.getResource(basePath);
            if (basePathURL == null && (basePathURL = this.getClass().getClassLoader().getResource(basePath)) == null) {
                return null;
            }
            localePrefix = null;
        }
        if ((value = library != null ? new ClientResourceInfo(library, outContract[0], resourceName, null, compressable, this.resourceSupportsEL(resourceName, library.getName(), ctx), ctx.isProjectStage(ProjectStage.Development), this.cacheTimestamp) : new ClientResourceInfo(outContract[0], resourceName, null, localePrefix, this, compressable, this.resourceSupportsEL(resourceName, null, ctx), ctx.isProjectStage(ProjectStage.Development), this.cacheTimestamp)).isCompressable()) {
            value = this.handleCompression(value);
        }
        return value;
    }

    private String deriveBasePath(LibraryInfo library, String resourceName, String localePrefix) {
        String basePath = null;
        basePath = library != null ? library.getPath(localePrefix) + '/' + resourceName : (localePrefix == null ? this.getBaseResourcePath() + '/' + resourceName : this.getBaseResourcePath() + '/' + localePrefix + '/' + resourceName);
        return basePath;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private URL findPathConsideringContracts(ClassLoader loader, LibraryInfo library, String resourceName, String localePrefix, ContractInfo[] outContract, String[] outBasePath, FacesContext ctx) {
        UIViewRoot root = ctx.getViewRoot();
        List<Object> contracts = null;
        URL result = null;
        if (library != null) {
            if (library.getContract() == null) {
                contracts = Collections.emptyList();
            } else {
                contracts = new ArrayList(1);
                contracts.add(library.getContract());
            }
        } else if (root == null) {
            String contractName = ctx.getExternalContext().getRequestParameterMap().get("con");
            if (null == contractName || 0 >= contractName.length() || ResourceManager.nameContainsForbiddenSequence(contractName)) return null;
            contracts = new ArrayList();
            contracts.add(contractName);
        } else {
            contracts = ctx.getResourceLibraryContracts();
        }
        String basePath = null;
        for (String string : contracts) {
            basePath = library != null ? library.getPath(localePrefix) + '/' + resourceName : (localePrefix == null ? this.getBaseContractsPath() + '/' + string + '/' + resourceName : this.getBaseContractsPath() + '/' + string + '/' + localePrefix + '/' + resourceName);
            result = loader.getResource(basePath);
            if (null != result) {
                outContract[0] = new ContractInfo(string);
                outBasePath[0] = basePath;
                return result;
            }
            basePath = null;
        }
        return result;
    }

    private InputStream getResourceAsStream(ClassLoader loader, String path, FacesContext ctx) {
        String path_;
        InputStream in = null;
        List<String> localizedPaths = this.getLocalizedPaths(path, ctx);
        Iterator<String> iterator = localizedPaths.iterator();
        while (iterator.hasNext() && (in = this.getResourceAsStream(loader, path_ = iterator.next())) == null) {
        }
        return in;
    }

    private URL getResourceURL(ClassLoader loader, String path, FacesContext ctx) {
        String path_;
        List<String> localizedPaths = this.getLocalizedPaths(path, ctx);
        URL url = null;
        Iterator<String> iterator = localizedPaths.iterator();
        while (iterator.hasNext() && (url = this.getResource_(loader, path_ = iterator.next())) == null) {
        }
        return url;
    }

    private InputStream getResourceAsStream(ClassLoader loader, String path) {
        InputStream in = loader.getResourceAsStream(path);
        if (in == null) {
            in = this.getClass().getClassLoader().getResourceAsStream(path);
        }
        return in;
    }

    private URL getResource_(ClassLoader loader, String path) {
        URL res = loader.getResource(path);
        if (res == null) {
            res = this.getClass().getClassLoader().getResource(path);
        }
        return res;
    }
}

