/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.rs.security.oauth2.grants.owner;

import org.apache.cxf.configuration.security.AuthorizationPolicy;
import org.apache.cxf.interceptor.security.JAASLoginInterceptor;
import org.apache.cxf.message.Message;
import org.apache.cxf.message.MessageImpl;
import org.apache.cxf.rs.security.oauth2.common.Client;
import org.apache.cxf.rs.security.oauth2.common.UserSubject;
import org.apache.cxf.rs.security.oauth2.grants.owner.ResourceOwnerLoginHandler;
import org.apache.cxf.rs.security.oauth2.utils.OAuthUtils;
import org.apache.cxf.security.SecurityContext;

public class JAASResourceOwnerLoginHandler
implements ResourceOwnerLoginHandler {
    private JAASLoginInterceptor jaasInterceptor = new JAASLoginInterceptor();

    @Override
    public UserSubject createSubject(Client client, String name, String password) {
        Message message = this.setupMessage(name, password);
        this.jaasInterceptor.handleMessage(message);
        return OAuthUtils.createSubject(message.get(SecurityContext.class));
    }

    public void setContextName(String name) {
        this.jaasInterceptor.setContextName(name);
    }

    public void setRoleClassifier(String value) {
        this.jaasInterceptor.setRoleClassifier(value);
    }

    public void setRoleClassifierType(String value) {
        this.jaasInterceptor.setRoleClassifierType(value);
    }

    private Message setupMessage(String name, String password) {
        AuthorizationPolicy policy = new AuthorizationPolicy();
        policy.setUserName(name);
        policy.setPassword(password);
        MessageImpl message = new MessageImpl();
        message.put(AuthorizationPolicy.class, policy);
        return message;
    }
}

