/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.config.sys;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.openejb.config.AppModule;
import org.apache.openejb.config.BeanProperties;
import org.apache.openejb.config.DeploymentModule;
import org.apache.openejb.config.EjbModule;
import org.apache.openejb.config.EnvEntriesPropertiesDeployer;
import org.apache.openejb.config.PojoConfiguration;
import org.apache.openejb.config.WebModule;
import org.apache.openejb.config.sys.BeanContextConfig;
import org.apache.openejb.config.sys.PojoConfig;
import org.apache.openejb.config.sys.PropertiesAdapter;
import org.apache.openejb.config.sys.StackHandler;
import org.apache.openejb.loader.SystemInstance;
import org.apache.openejb.util.LogCategory;
import org.apache.openejb.util.Logger;
import org.apache.openejb.util.Saxs;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class SaxAppCtxConfig {
    private static final Logger LOGGER = Logger.getInstance(LogCategory.OPENEJB_STARTUP_CONFIG, SaxAppContextConfig.class);

    public static void parse(AppModule appModule, InputSource source, EnvEntriesPropertiesDeployer envEntriesDeployer, BeanProperties beanProperties) throws SAXException, ParserConfigurationException, IOException {
        Saxs.factory().newSAXParser().parse(source, (DefaultHandler)new SaxAppContextConfig(appModule, envEntriesDeployer, beanProperties));
    }

    private static boolean acceptModule(String id, DeploymentModule ejbModule) {
        return id == null || id.equals(ejbModule.getModuleId());
    }

    private static class SaxAppContextConfig
    extends StackHandler {
        private static final Collection<String> IMPORT_ALIASES = Arrays.asList("import", "include");
        private static final Collection<String> APPLICATION_ALIASES = Arrays.asList("appcontext", "app-context", "application");
        private static final Collection<String> POJOS_ALIASES = Arrays.asList("pojocontexts", "pojo-contexts", "pojos");
        private static final Collection<String> POJO_ALIASES = Collections.singletonList("pojo");
        private static final Collection<String> BEAN_CONTEXTS_ALIASES = Arrays.asList("beancontexts", "bean-contexts", "ejbs");
        private static final Collection<String> WEBAPP_ALIASES = Arrays.asList("webapps", "webcontexts", "web-contexts", "wars");
        private static final Collection<String> MODULE_ALIASES = Arrays.asList("modulecontext", "module");
        private static final Collection<String> BEAN_CONTEXT_ALIASES = Arrays.asList("ejb", "beancontext", "bean-context");
        private static final Collection<String> CONFIGURATION_ALIASES = Arrays.asList("configuration", "properties", "settings");
        private static final Collection<String> RESOURCES_ALIASES = Collections.singletonList("resources");
        private static final Collection<String> SERVICE_ALIASES = Collections.singletonList("service");
        private static final Collection<String> RESOURCE_ALIASES = Collections.singletonList("resource");
        private static final Collection<String> ENV_ENTRIES_ALIASES = Arrays.asList("enventries", "env-entries");
        private static final Collection<String> ENV_ENTRY_ALIASES = Arrays.asList("enventry", "env-entry");
        private final AppModule module;
        private final EnvEntriesPropertiesDeployer envEntriesDeployer;
        private final BeanProperties beanPropertiesDeployer;

        public SaxAppContextConfig(AppModule appModule, EnvEntriesPropertiesDeployer envEntriesDeployer, BeanProperties beanProperties) {
            this.module = appModule;
            this.envEntriesDeployer = envEntriesDeployer;
            this.beanPropertiesDeployer = beanProperties;
        }

        @Override
        public void startDocument() throws SAXException {
            this.push(new Document());
        }

        private class EnvEntry
        extends StackHandler.Content {
            private String key;

            private EnvEntry() {
                super(SaxAppContextConfig.this);
            }

            @Override
            public void startElement(String uri, String localName, String qName, Attributes attributes) {
                if (!ENV_ENTRY_ALIASES.contains(localName.toLowerCase())) {
                    throw new IllegalStateException("Unsupported Element: " + localName);
                }
                this.key = attributes.getValue("key");
            }

            @Override
            public void setValue(String text) {
                SaxAppContextConfig.this.envEntriesDeployer.addEnvEntries(this.key, text);
            }
        }

        private class EnvEntries
        extends DefaultHandler {
            private EnvEntries() {
            }

            @Override
            public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
                if (!ENV_ENTRY_ALIASES.contains(localName.toLowerCase())) {
                    throw new IllegalStateException("Unsupported Element: " + localName);
                }
                SaxAppContextConfig.this.push(new EnvEntry());
                SaxAppContextConfig.this.get().startElement(uri, localName, qName, attributes);
            }
        }

        private class ResourcesConfig
        extends DefaultHandler {
            private ResourcesConfig() {
            }

            @Override
            public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
                String name = localName.toLowerCase();
                if (SERVICE_ALIASES.contains(name)) {
                    SaxAppContextConfig.this.push(new StackHandler.DeclaredServiceElement(SaxAppContextConfig.this, SaxAppContextConfig.this.module.getServices()));
                } else if (RESOURCE_ALIASES.contains(name)) {
                    SaxAppContextConfig.this.push(new StackHandler.ResourceElement(SaxAppContextConfig.this, SaxAppContextConfig.this.module.getResources()));
                } else {
                    throw new IllegalStateException("Unsupported Element: " + localName);
                }
                SaxAppContextConfig.this.get().startElement(uri, localName, qName, attributes);
            }
        }

        private class BeanContext
        extends Pojo {
            private final String moduleId;

            public BeanContext(String moduleId, String id, BeanContextConfig beanConfig) {
                super(id, beanConfig);
                this.moduleId = moduleId;
            }

            @Override
            public void endElement(String uri, String localName, String qName) throws SAXException {
                for (EjbModule ejbModule : SaxAppContextConfig.this.module.getEjbModules()) {
                    if (!SaxAppCtxConfig.acceptModule(this.moduleId, ejbModule) || !this.pojoConfig.hasProperties()) continue;
                    SaxAppContextConfig.this.beanPropertiesDeployer.addProperties(this.id, this.pojoConfig.getProperties());
                }
            }
        }

        private class Pojo
        extends DefaultHandler {
            protected final PojoConfig pojoConfig;
            protected final String id;

            public Pojo(String id, PojoConfig beanConfig) {
                this.id = id;
                this.pojoConfig = beanConfig;
            }

            @Override
            public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
                if (!CONFIGURATION_ALIASES.contains(localName.toLowerCase())) {
                    throw new IllegalStateException("Unsupported Element: " + localName);
                }
                SaxAppContextConfig.this.push(new Configuration("", this.pojoConfig.getProperties()));
            }

            @Override
            public void endElement(String uri, String localName, String qName) throws SAXException {
                SaxAppContextConfig.this.module.getPojoConfigurations().put(this.id, new PojoConfiguration(this.pojoConfig.getProperties()));
            }
        }

        private class BeanContexts
        extends Pojos {
            private final String id;

            public BeanContexts(String id) {
                super(BEAN_CONTEXT_ALIASES);
                this.id = id;
            }

            @Override
            protected DefaultHandler childParser(String beanId, PojoConfig beanConfig) {
                return new BeanContext(this.id, beanId, (BeanContextConfig)beanConfig);
            }

            @Override
            protected PojoConfig newItem() {
                return new BeanContextConfig();
            }

            @Override
            public void endElement(String uri, String localName, String qName) throws SAXException {
                for (PojoConfig generic : this.genericConfigs) {
                    if (!generic.hasProperties()) continue;
                    SaxAppContextConfig.this.beanPropertiesDeployer.addGlobalProperties(this.id, generic.getProperties());
                }
            }
        }

        private final class WebAppContext
        extends ModuleContext {
            private WebAppContext(String id) {
                super(id);
            }

            @Override
            protected Collection<Properties> propertiesForModule(String id) {
                ArrayList<Properties> props = new ArrayList<Properties>();
                for (WebModule m : SaxAppContextConfig.this.module.getWebModules()) {
                    if (!SaxAppCtxConfig.acceptModule(id, m)) continue;
                    props.add(m.getProperties());
                }
                return props;
            }
        }

        private class ModuleContext
        extends DefaultHandler {
            protected final String id;

            ModuleContext(String id) {
                this.id = id;
            }

            @Override
            public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
                String name = localName.toLowerCase();
                if (BEAN_CONTEXTS_ALIASES.contains(name)) {
                    SaxAppContextConfig.this.push(new BeanContexts(this.id));
                } else if (POJOS_ALIASES.contains(name)) {
                    SaxAppContextConfig.this.push(new Pojos());
                } else if (CONFIGURATION_ALIASES.contains(name)) {
                    SaxAppContextConfig.this.push(new MultipleConfiguration("", this.propertiesForModule(this.id)));
                } else {
                    throw new IllegalStateException("Unsupported Element: " + localName);
                }
            }

            protected Collection<Properties> propertiesForModule(String id) {
                ArrayList<Properties> props = new ArrayList<Properties>();
                for (DeploymentModule m : SaxAppContextConfig.this.module.getDeploymentModule()) {
                    if (!SaxAppCtxConfig.acceptModule(id, m)) continue;
                    props.add(m.getProperties());
                }
                return props;
            }
        }

        private class Pojos
        extends DefaultHandler {
            protected final List<PojoConfig> genericConfigs = new ArrayList<PojoConfig>();
            protected final Collection<String> aliases;

            private Pojos() {
                this(POJO_ALIASES);
            }

            protected Pojos(Collection<String> aliases) {
                this.aliases = aliases;
            }

            @Override
            public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
                String id;
                PojoConfig beanConfig;
                if (this.aliases.contains(localName.toLowerCase())) {
                    beanConfig = this.newItem();
                    id = attributes.getValue("id");
                    if (id == null || "*".equals(id)) {
                        this.genericConfigs.add(beanConfig);
                    }
                } else {
                    throw new IllegalStateException("Unsupported Element: " + localName);
                }
                SaxAppContextConfig.this.push(this.childParser(id, beanConfig));
            }

            protected DefaultHandler childParser(String id, PojoConfig beanConfig) {
                return new Pojo(id, beanConfig);
            }

            protected PojoConfig newItem() {
                return new PojoConfig();
            }

            @Override
            public void endElement(String uri, String localName, String qName) throws SAXException {
                for (PojoConfig generic : this.genericConfigs) {
                    for (PojoConfiguration config : SaxAppContextConfig.this.module.getPojoConfigurations().values()) {
                        for (String key : generic.getProperties().stringPropertyNames()) {
                            if (config.getProperties().containsKey(key)) continue;
                            config.getProperties().put(key, generic.getProperties().get(key));
                        }
                    }
                }
            }
        }

        private final class MultipleConfiguration
        extends StackHandler.Content {
            private final Collection<Properties> properties;
            private final String prefix;

            private MultipleConfiguration(String prefix, Collection<Properties> properties) {
                super(SaxAppContextConfig.this);
                this.properties = properties;
                this.prefix = prefix;
            }

            @Override
            public void startElement(String uri, String localName, String qName, Attributes attributes) {
                SaxAppContextConfig.this.push(new MultipleConfiguration(this.prefix + localName + ".", this.properties));
            }

            @Override
            public void setValue(String text) {
                if (this.properties == null) {
                    return;
                }
                try {
                    for (Properties p : this.properties) {
                        for (Map.Entry<Object, Object> entry : new PropertiesAdapter().unmarshal(text).entrySet()) {
                            p.put(this.prefix + entry.getKey(), entry.getValue());
                        }
                    }
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
        }

        private final class Configuration
        extends StackHandler.Content {
            private final Properties properties;
            private final String prefix;

            private Configuration(String prefix, Properties properties) {
                super(SaxAppContextConfig.this);
                this.properties = properties;
                this.prefix = prefix;
            }

            @Override
            public void startElement(String uri, String localName, String qName, Attributes attributes) {
                SaxAppContextConfig.this.push(new Configuration(this.prefix + localName + ".", this.properties));
            }

            @Override
            public void setValue(String text) {
                if (this.properties == null) {
                    return;
                }
                try {
                    for (Map.Entry<Object, Object> entry : new PropertiesAdapter().unmarshal(text).entrySet()) {
                        this.properties.put(this.prefix + entry.getKey(), entry.getValue());
                    }
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
        }

        private class Root
        extends DefaultHandler {
            private Root() {
            }

            @Override
            public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
                String name = localName.toLowerCase();
                if (CONFIGURATION_ALIASES.contains(name)) {
                    SaxAppContextConfig.this.push(new Configuration("", SaxAppContextConfig.this.module.getProperties()));
                } else if (ENV_ENTRIES_ALIASES.contains(name)) {
                    SaxAppContextConfig.this.push(new EnvEntries());
                } else if (BEAN_CONTEXTS_ALIASES.contains(name)) {
                    SaxAppContextConfig.this.push(new BeanContexts(null));
                } else if (MODULE_ALIASES.contains(name)) {
                    SaxAppContextConfig.this.push(new ModuleContext(attributes.getValue("id")));
                } else if (WEBAPP_ALIASES.contains(name)) {
                    SaxAppContextConfig.this.push(new WebAppContext(attributes.getValue("id")));
                } else if (POJOS_ALIASES.contains(name)) {
                    SaxAppContextConfig.this.push(new Pojos());
                } else if (RESOURCES_ALIASES.contains(name)) {
                    SaxAppContextConfig.this.push(new ResourcesConfig());
                } else if (IMPORT_ALIASES.contains(name)) {
                    this.importFile(attributes.getValue("path"));
                    SaxAppContextConfig.this.push(new DefaultHandler());
                } else {
                    throw new IllegalStateException("Unsupported Element: " + localName);
                }
            }

            private void importFile(String path) throws SAXException {
                block21: {
                    File file = new File(path);
                    if (file.exists()) {
                        try (FileInputStream inputStream = new FileInputStream(file);){
                            SaxAppCtxConfig.parse(SaxAppContextConfig.this.module, new InputSource(inputStream), SaxAppContextConfig.this.envEntriesDeployer, SaxAppContextConfig.this.beanPropertiesDeployer);
                            break block21;
                        }
                        catch (IOException | ParserConfigurationException e) {
                            throw new SAXException(e);
                        }
                    }
                    ClassLoader cl = SaxAppContextConfig.this.module.getClassLoader();
                    if (cl != null) {
                        try (InputStream is = cl.getResourceAsStream(path);){
                            if (is != null) {
                                try {
                                    SaxAppCtxConfig.parse(SaxAppContextConfig.this.module, new InputSource(is), SaxAppContextConfig.this.envEntriesDeployer, SaxAppContextConfig.this.beanPropertiesDeployer);
                                    break block21;
                                }
                                catch (IOException | ParserConfigurationException e) {
                                    throw new SAXException(e);
                                }
                            }
                            LOGGER.warning("Can't find " + path);
                        }
                        catch (IOException e) {
                            LOGGER.warning("Can't find " + path, e);
                        }
                    } else {
                        LOGGER.warning("Can't find " + path + ", no classloader for the module " + SaxAppContextConfig.this.module);
                    }
                }
            }
        }

        private class Document
        extends DefaultHandler {
            private Document() {
            }

            @Override
            public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
                if (!APPLICATION_ALIASES.contains(localName.toLowerCase()) && SystemInstance.get().getOptions().get("openejb.configuration.strict-tags", false)) {
                    throw new IllegalStateException("Unsupported Element: " + localName);
                }
                SaxAppContextConfig.this.push(new Root());
            }
        }
    }
}

