/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.rs.security.jose.jwe;

import java.security.PublicKey;
import javax.crypto.SecretKey;
import org.apache.cxf.common.util.StringUtils;
import org.apache.cxf.rs.security.jose.jwe.JweEncryptionProvider;
import org.apache.cxf.rs.security.jose.jwe.JweHeaders;
import org.apache.cxf.rs.security.jose.jwe.JweUtils;
import org.apache.cxf.rs.security.jose.jwk.JsonWebKey;

public class JweCompactProducer {
    private final JweHeaders headers;
    private final String data;

    public JweCompactProducer(String data) {
        this(new JweHeaders(), data);
    }

    public JweCompactProducer(JweHeaders joseHeaders, String data) {
        this.headers = joseHeaders;
        this.data = data;
    }

    public String encryptWith(JsonWebKey key) {
        JweEncryptionProvider jwe = JweUtils.createJweEncryptionProvider(key, this.headers);
        return this.encryptWith(jwe);
    }

    public String encryptWith(PublicKey key) {
        JweEncryptionProvider jwe = JweUtils.createJweEncryptionProvider(key, this.headers);
        return this.encryptWith(jwe);
    }

    public String encryptWith(SecretKey key) {
        JweEncryptionProvider jwe = JweUtils.createJweEncryptionProvider(key, this.headers);
        return this.encryptWith(jwe);
    }

    public String encryptWith(JweEncryptionProvider jwe) {
        return jwe.encrypt(StringUtils.toBytesUTF8(this.data), this.headers);
    }
}

