/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jaxrs.provider;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.util.Comparator;
import org.apache.cxf.jaxrs.utils.GenericsUtils;

public class GenericArgumentComparator
implements Comparator<Class<?>> {
    private final Class<?> genericInterface;

    public GenericArgumentComparator(Class<?> genericInterface) {
        if (genericInterface == null) {
            throw new IllegalArgumentException("Generic Interface cannot be null");
        }
        if (genericInterface.getTypeParameters().length == 0) {
            throw new IllegalArgumentException("Interface has no generic type parameters: " + genericInterface);
        }
        if (genericInterface.getTypeParameters().length > 1) {
            throw new IllegalArgumentException("Interface must have only 1 generic type parameter: " + genericInterface);
        }
        this.genericInterface = genericInterface;
    }

    @Override
    public int compare(Class<?> a, Class<?> b) {
        Type[] bTypes;
        Type[] aTypes = GenericsUtils.getTypeArgumentsFor(this.genericInterface, a);
        if (aTypes == (bTypes = GenericsUtils.getTypeArgumentsFor(this.genericInterface, b))) {
            return 0;
        }
        if (aTypes == null) {
            return 1;
        }
        if (bTypes == null) {
            return -1;
        }
        Type aType = aTypes[0];
        Type bType = bTypes[0];
        return this.compare(aType, bType);
    }

    @Override
    public int compare(Type aType, Type bType) {
        Class<?> bClass;
        if (aType == bType) {
            return 0;
        }
        Class<?> aClass = this.asClass(aType);
        if (!aClass.equals(bClass = this.asClass(bType))) {
            if (bClass.isAssignableFrom(aClass)) {
                return -1;
            }
            if (aClass.isAssignableFrom(bClass)) {
                return 1;
            }
            return 0;
        }
        Type aParam = this.getFirstParameterOrObject(aType);
        Type bParam = this.getFirstParameterOrObject(bType);
        return this.compare(aParam, bParam);
    }

    private Type getFirstParameterOrObject(Type type) {
        if (!(type instanceof ParameterizedType)) {
            return Object.class;
        }
        ParameterizedType parameterizedType = (ParameterizedType)type;
        Type[] types = parameterizedType.getActualTypeArguments();
        if (types.length == 0) {
            return Object.class;
        }
        return types[0];
    }

    private Class<?> asClass(Type aType) {
        if (aType instanceof Class) {
            return (Class)aType;
        }
        if (aType instanceof ParameterizedType) {
            ParameterizedType parameterizedType = (ParameterizedType)aType;
            return this.asClass(parameterizedType.getRawType());
        }
        if (aType instanceof TypeVariable) {
            TypeVariable typeVariable = (TypeVariable)aType;
            Type[] bounds = typeVariable.getBounds();
            if (bounds == null || bounds.length == 0) {
                return Object.class;
            }
            return this.asClass(bounds[0]);
        }
        if (aType instanceof WildcardType) {
            return Object.class;
        }
        return Object.class;
    }
}

