/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.rs.security.jose.jaxrs;

import jakarta.ws.rs.core.MultivaluedMap;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.jaxrs.utils.JAXRSUtils;
import org.apache.cxf.rs.security.jose.jaxrs.JoseJaxrsUtils;
import org.apache.cxf.rs.security.jose.jws.JwsException;
import org.apache.cxf.rs.security.jose.jws.JwsHeaders;
import org.apache.cxf.rs.security.jose.jws.JwsJsonConsumer;
import org.apache.cxf.rs.security.jose.jws.JwsJsonSignatureEntry;
import org.apache.cxf.rs.security.jose.jws.JwsSignatureVerifier;
import org.apache.cxf.rs.security.jose.jws.JwsUtils;

public class AbstractJwsJsonReaderProvider {
    protected static final Logger LOG = LogUtils.getL7dLogger(AbstractJwsJsonReaderProvider.class);
    private Set<String> protectedHttpHeaders;
    private boolean validateHttpHeaders;
    private JwsSignatureVerifier sigVerifier;
    private String defaultMediaType;
    private Map<String, Object> entryProps;
    private boolean checkEmptyStream;

    public void setSignatureVerifier(JwsSignatureVerifier signatureVerifier) {
        this.sigVerifier = signatureVerifier;
    }

    protected JwsSignatureVerifier getInitializedSigVerifier() {
        if (this.sigVerifier != null) {
            return this.sigVerifier;
        }
        return JwsUtils.loadSignatureVerifier(null, true);
    }

    public String getDefaultMediaType() {
        return this.defaultMediaType;
    }

    public void setDefaultMediaType(String defaultMediaType) {
        this.defaultMediaType = defaultMediaType;
    }

    protected void validate(JwsJsonConsumer c, JwsSignatureVerifier theSigVerifier) throws JwsException {
        List<JwsJsonSignatureEntry> remaining = c.verifyAndGetNonValidated(Collections.singletonList(theSigVerifier), this.entryProps);
        if (!remaining.isEmpty()) {
            JAXRSUtils.getCurrentMessage().put("jws.json.remaining.entries", remaining);
        }
        JAXRSUtils.getCurrentMessage().put(JwsJsonConsumer.class, c);
    }

    public Map<String, Object> getEntryProps() {
        return this.entryProps;
    }

    public void setEntryProps(Map<String, Object> entryProps) {
        this.entryProps = entryProps;
    }

    public void setValidateHttpHeaders(boolean validateHttpHeaders) {
        this.validateHttpHeaders = validateHttpHeaders;
    }

    public boolean isValidateHttpHeaders() {
        return this.validateHttpHeaders;
    }

    protected void validateHttpHeadersIfNeeded(MultivaluedMap<String, String> httpHeaders, JwsHeaders jwsHeaders) {
        JoseJaxrsUtils.validateHttpHeaders(httpHeaders, jwsHeaders, this.protectedHttpHeaders);
    }

    public void setProtectedHttpHeaders(Set<String> protectedHttpHeaders) {
        this.protectedHttpHeaders = protectedHttpHeaders;
    }

    public boolean isCheckEmptyStream() {
        return this.checkEmptyStream;
    }

    public void setCheckEmptyStream(boolean checkEmptyStream) {
        this.checkEmptyStream = checkEmptyStream;
    }
}

