/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.jee;

import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlID;
import jakarta.xml.bind.annotation.XmlTransient;
import jakarta.xml.bind.annotation.XmlType;
import jakarta.xml.bind.annotation.adapters.CollapsedStringAdapter;
import jakarta.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.openejb.jee.AroundInvoke;
import org.apache.openejb.jee.AroundTimeout;
import org.apache.openejb.jee.DataSource;
import org.apache.openejb.jee.EjbLocalRef;
import org.apache.openejb.jee.EjbRef;
import org.apache.openejb.jee.EnvEntry;
import org.apache.openejb.jee.InitMethod;
import org.apache.openejb.jee.JMSConnectionFactory;
import org.apache.openejb.jee.JMSDestination;
import org.apache.openejb.jee.JndiConsumer;
import org.apache.openejb.jee.KeyedCollection;
import org.apache.openejb.jee.LifecycleCallback;
import org.apache.openejb.jee.MessageDestinationRef;
import org.apache.openejb.jee.PersistenceContextRef;
import org.apache.openejb.jee.PersistenceUnitRef;
import org.apache.openejb.jee.RemoveMethod;
import org.apache.openejb.jee.ResourceEnvRef;
import org.apache.openejb.jee.ResourceRef;
import org.apache.openejb.jee.ServiceRef;
import org.apache.openejb.jee.Session;
import org.apache.openejb.jee.Text;
import org.apache.openejb.jee.TextMap;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="interceptorType", propOrder={"descriptions", "interceptorClass", "aroundInvoke", "aroundTimeout", "envEntry", "ejbRef", "ejbLocalRef", "serviceRef", "resourceRef", "resourceEnvRef", "messageDestinationRef", "persistenceContextRef", "persistenceUnitRef", "aroundConstruct", "postConstruct", "preDestroy", "dataSource", "jmsConnectionFactories", "jmsDestinations", "postActivate", "prePassivate", "afterBegin", "beforeCompletion", "afterCompletion"})
public class Interceptor
implements JndiConsumer,
Session {
    @XmlTransient
    protected TextMap description = new TextMap();
    @XmlElement(name="interceptor-class", required=true)
    protected String interceptorClass;
    @XmlElement(name="around-invoke", required=true)
    protected List<AroundInvoke> aroundInvoke;
    @XmlElement(name="around-timeout")
    protected List<AroundTimeout> aroundTimeout;
    @XmlElement(name="env-entry", required=true)
    protected KeyedCollection<String, EnvEntry> envEntry;
    @XmlElement(name="ejb-ref", required=true)
    protected KeyedCollection<String, EjbRef> ejbRef;
    @XmlElement(name="ejb-local-ref", required=true)
    protected KeyedCollection<String, EjbLocalRef> ejbLocalRef;
    @XmlElement(name="service-ref", required=true)
    protected KeyedCollection<String, ServiceRef> serviceRef;
    @XmlElement(name="resource-ref", required=true)
    protected KeyedCollection<String, ResourceRef> resourceRef;
    @XmlElement(name="resource-env-ref", required=true)
    protected KeyedCollection<String, ResourceEnvRef> resourceEnvRef;
    @XmlElement(name="message-destination-ref", required=true)
    protected KeyedCollection<String, MessageDestinationRef> messageDestinationRef;
    @XmlElement(name="persistence-context-ref", required=true)
    protected KeyedCollection<String, PersistenceContextRef> persistenceContextRef;
    @XmlElement(name="persistence-unit-ref", required=true)
    protected KeyedCollection<String, PersistenceUnitRef> persistenceUnitRef;
    @XmlElement(name="data-source", required=true)
    protected KeyedCollection<String, DataSource> dataSource;
    @XmlElement(name="jms-connection-factory", required=true)
    protected KeyedCollection<String, JMSConnectionFactory> jmsConnectionFactories;
    @XmlElement(name="jms-destination")
    protected KeyedCollection<String, JMSDestination> jmsDestinations;
    @XmlElement(name="around-construct", required=true)
    protected List<LifecycleCallback> aroundConstruct;
    @XmlElement(name="post-construct", required=true)
    protected List<LifecycleCallback> postConstruct;
    @XmlElement(name="pre-destroy", required=true)
    protected List<LifecycleCallback> preDestroy;
    @XmlElement(name="post-activate", required=true)
    protected List<LifecycleCallback> postActivate;
    @XmlElement(name="pre-passivate", required=true)
    protected List<LifecycleCallback> prePassivate;
    @XmlElement(name="after-begin", required=true)
    protected List<LifecycleCallback> afterBegin;
    @XmlElement(name="before-completion", required=true)
    protected List<LifecycleCallback> beforeCompletion;
    @XmlElement(name="after-completion", required=true)
    protected List<LifecycleCallback> afterCompletion;
    @XmlAttribute
    @XmlJavaTypeAdapter(value=CollapsedStringAdapter.class)
    @XmlID
    protected String id;

    public Interceptor() {
    }

    public Interceptor(Class<?> interceptorClass) {
        this.interceptorClass = interceptorClass.getName();
    }

    public Interceptor(String interceptorClass) {
        this.interceptorClass = interceptorClass;
    }

    @Override
    public String getJndiConsumerName() {
        if (this.interceptorClass == null) {
            return null;
        }
        return this.interceptorClass.replaceAll(".*\\.", "");
    }

    @XmlElement(name="description", required=true)
    public Text[] getDescriptions() {
        return this.description.toArray();
    }

    public void setDescriptions(Text[] text) {
        this.description.set(text);
    }

    public String getDescription() {
        return this.description.get();
    }

    public String getInterceptorClass() {
        return this.interceptorClass;
    }

    public void setInterceptorClass(String value) {
        this.interceptorClass = value;
    }

    @Override
    public List<AroundInvoke> getAroundInvoke() {
        if (this.aroundInvoke == null) {
            this.aroundInvoke = new ArrayList<AroundInvoke>();
        }
        return this.aroundInvoke;
    }

    @Override
    public void addAroundInvoke(String method) {
        assert (this.interceptorClass != null) : "Set the interceptorClass before calling this method";
        this.getAroundInvoke().add(new AroundInvoke(this.interceptorClass, method));
    }

    @Override
    public List<AroundTimeout> getAroundTimeout() {
        if (this.aroundTimeout == null) {
            this.aroundTimeout = new ArrayList<AroundTimeout>();
        }
        return this.aroundTimeout;
    }

    @Override
    public Collection<EnvEntry> getEnvEntry() {
        if (this.envEntry == null) {
            this.envEntry = new KeyedCollection();
        }
        return this.envEntry;
    }

    @Override
    public Map<String, EnvEntry> getEnvEntryMap() {
        if (this.envEntry == null) {
            this.envEntry = new KeyedCollection();
        }
        return this.envEntry.toMap();
    }

    @Override
    public Collection<EjbRef> getEjbRef() {
        if (this.ejbRef == null) {
            this.ejbRef = new KeyedCollection();
        }
        return this.ejbRef;
    }

    @Override
    public Map<String, EjbRef> getEjbRefMap() {
        if (this.ejbRef == null) {
            this.ejbRef = new KeyedCollection();
        }
        return this.ejbRef.toMap();
    }

    @Override
    public Collection<EjbLocalRef> getEjbLocalRef() {
        if (this.ejbLocalRef == null) {
            this.ejbLocalRef = new KeyedCollection();
        }
        return this.ejbLocalRef;
    }

    @Override
    public Map<String, EjbLocalRef> getEjbLocalRefMap() {
        if (this.ejbLocalRef == null) {
            this.ejbLocalRef = new KeyedCollection();
        }
        return this.ejbLocalRef.toMap();
    }

    @Override
    public Collection<ServiceRef> getServiceRef() {
        if (this.serviceRef == null) {
            this.serviceRef = new KeyedCollection();
        }
        return this.serviceRef;
    }

    @Override
    public Map<String, ServiceRef> getServiceRefMap() {
        if (this.serviceRef == null) {
            this.serviceRef = new KeyedCollection();
        }
        return this.serviceRef.toMap();
    }

    @Override
    public Collection<ResourceRef> getResourceRef() {
        if (this.resourceRef == null) {
            this.resourceRef = new KeyedCollection();
        }
        return this.resourceRef;
    }

    @Override
    public Map<String, ResourceRef> getResourceRefMap() {
        if (this.resourceRef == null) {
            this.resourceRef = new KeyedCollection();
        }
        return this.resourceRef.toMap();
    }

    @Override
    public Collection<ResourceEnvRef> getResourceEnvRef() {
        if (this.resourceEnvRef == null) {
            this.resourceEnvRef = new KeyedCollection();
        }
        return this.resourceEnvRef;
    }

    @Override
    public Map<String, ResourceEnvRef> getResourceEnvRefMap() {
        if (this.resourceEnvRef == null) {
            this.resourceEnvRef = new KeyedCollection();
        }
        return this.resourceEnvRef.toMap();
    }

    @Override
    public Collection<MessageDestinationRef> getMessageDestinationRef() {
        if (this.messageDestinationRef == null) {
            this.messageDestinationRef = new KeyedCollection();
        }
        return this.messageDestinationRef;
    }

    @Override
    public Map<String, MessageDestinationRef> getMessageDestinationRefMap() {
        if (this.messageDestinationRef == null) {
            this.messageDestinationRef = new KeyedCollection();
        }
        return this.messageDestinationRef.toMap();
    }

    @Override
    public Collection<PersistenceContextRef> getPersistenceContextRef() {
        if (this.persistenceContextRef == null) {
            this.persistenceContextRef = new KeyedCollection();
        }
        return this.persistenceContextRef;
    }

    @Override
    public Map<String, PersistenceContextRef> getPersistenceContextRefMap() {
        if (this.persistenceContextRef == null) {
            this.persistenceContextRef = new KeyedCollection();
        }
        return this.persistenceContextRef.toMap();
    }

    @Override
    public Collection<PersistenceUnitRef> getPersistenceUnitRef() {
        if (this.persistenceUnitRef == null) {
            this.persistenceUnitRef = new KeyedCollection();
        }
        return this.persistenceUnitRef;
    }

    @Override
    public Map<String, PersistenceUnitRef> getPersistenceUnitRefMap() {
        if (this.persistenceUnitRef == null) {
            this.persistenceUnitRef = new KeyedCollection();
        }
        return this.persistenceUnitRef.toMap();
    }

    @Override
    public Collection<DataSource> getDataSource() {
        if (this.dataSource == null) {
            this.dataSource = new KeyedCollection();
        }
        return this.dataSource;
    }

    @Override
    public Map<String, DataSource> getDataSourceMap() {
        if (this.dataSource == null) {
            this.dataSource = new KeyedCollection();
        }
        return this.dataSource.toMap();
    }

    public List<LifecycleCallback> getAroundConstruct() {
        if (this.aroundConstruct == null) {
            this.aroundConstruct = new ArrayList<LifecycleCallback>();
        }
        return this.aroundConstruct;
    }

    @Override
    public List<LifecycleCallback> getPostConstruct() {
        if (this.postConstruct == null) {
            this.postConstruct = new ArrayList<LifecycleCallback>();
        }
        return this.postConstruct;
    }

    @Override
    public void addPostConstruct(String method) {
        assert (this.interceptorClass != null) : "Set the interceptorClass before calling this method";
        this.getPostConstruct().add(new LifecycleCallback(this.interceptorClass, method));
    }

    @Override
    public List<LifecycleCallback> getPreDestroy() {
        if (this.preDestroy == null) {
            this.preDestroy = new ArrayList<LifecycleCallback>();
        }
        return this.preDestroy;
    }

    @Override
    public void addPreDestroy(String method) {
        assert (this.interceptorClass != null) : "Set the interceptorClass before calling this method";
        this.getPreDestroy().add(new LifecycleCallback(this.interceptorClass, method));
    }

    @Override
    public List<LifecycleCallback> getPostActivate() {
        if (this.postActivate == null) {
            this.postActivate = new ArrayList<LifecycleCallback>();
        }
        return this.postActivate;
    }

    @Override
    public void addPostActivate(String method) {
        assert (this.interceptorClass != null) : "Set the interceptorClass before calling this method";
        this.getPostActivate().add(new LifecycleCallback(this.interceptorClass, method));
    }

    @Override
    public List<LifecycleCallback> getPrePassivate() {
        if (this.prePassivate == null) {
            this.prePassivate = new ArrayList<LifecycleCallback>();
        }
        return this.prePassivate;
    }

    @Override
    public void addPrePassivate(String method) {
        assert (this.interceptorClass != null) : "Set the interceptorClass before calling this method";
        this.getPrePassivate().add(new LifecycleCallback(this.interceptorClass, method));
    }

    @Override
    public void addAfterBegin(String method) {
        assert (this.interceptorClass != null) : "Set the interceptorClass before calling this method";
        this.getAfterBegin().add(new LifecycleCallback(this.interceptorClass, method));
    }

    @Override
    public void addAfterCompletion(String method) {
        assert (this.interceptorClass != null) : "Set the interceptorClass before calling this method";
        this.getAfterCompletion().add(new LifecycleCallback(this.interceptorClass, method));
    }

    @Override
    public void addBeforeCompletion(String method) {
        assert (this.interceptorClass != null) : "Set the interceptorClass before calling this method";
        this.getBeforeCompletion().add(new LifecycleCallback(this.interceptorClass, method));
    }

    @Override
    public List<LifecycleCallback> getAfterBegin() {
        if (this.afterBegin == null) {
            this.afterBegin = new ArrayList<LifecycleCallback>();
        }
        return this.afterBegin;
    }

    @Override
    public List<LifecycleCallback> getAfterCompletion() {
        if (this.afterCompletion == null) {
            this.afterCompletion = new ArrayList<LifecycleCallback>();
        }
        return this.afterCompletion;
    }

    @Override
    public List<LifecycleCallback> getBeforeCompletion() {
        if (this.beforeCompletion == null) {
            this.beforeCompletion = new ArrayList<LifecycleCallback>();
        }
        return this.beforeCompletion;
    }

    @Override
    public List<InitMethod> getInitMethod() {
        return new ArrayList<InitMethod>();
    }

    @Override
    public List<RemoveMethod> getRemoveMethod() {
        return new ArrayList<RemoveMethod>();
    }

    public String getId() {
        return this.id;
    }

    public void setId(String value) {
        this.id = value;
    }

    @Override
    public void addAroundTimeout(String method) {
        assert (this.interceptorClass != null) : "Set the interceptorClass before calling this method";
        this.getAroundTimeout().add(new AroundTimeout(this.interceptorClass, method));
    }

    @Override
    public Collection<JMSConnectionFactory> getJMSConnectionFactories() {
        return this.jmsConnectionFactories == null ? (this.jmsConnectionFactories = new KeyedCollection()) : this.jmsConnectionFactories;
    }

    @Override
    public Map<String, JMSConnectionFactory> getJMSConnectionFactoriesMap() {
        return ((KeyedCollection)KeyedCollection.class.cast(this.getJMSConnectionFactories())).toMap();
    }

    @Override
    public Collection<JMSDestination> getJMSDestination() {
        return this.jmsDestinations == null ? (this.jmsDestinations = new KeyedCollection()) : this.jmsDestinations;
    }

    @Override
    public Map<String, JMSDestination> getJMSDestinationMap() {
        return ((KeyedCollection)KeyedCollection.class.cast(this.getJMSDestination())).toMap();
    }
}

