/*
 * Decompiled with CFR 0.152.
 */
package io.churchkey.asn1;

import io.churchkey.asn1.Asn1Class;
import io.churchkey.asn1.Asn1Construction;
import io.churchkey.asn1.Asn1Type;

public class Tag {
    private final Asn1Class clazz;
    private final Asn1Construction construction;
    private final Asn1Type type;

    public byte toDer() {
        int clas = this.clazz.getConstant() << 6;
        int cons = this.construction.getConstant() << 5;
        byte type = this.type.getConstant();
        return (byte)(clas | cons | type);
    }

    public static Tag fromDer(int tag) {
        int clas = (tag & 0xC0) >> 6;
        int cons = (tag & 0x20) >> 5;
        int type = tag & 0x1F;
        return new Tag(Asn1Class.fromConstant(clas), Asn1Construction.fromConstant(cons), Asn1Type.fromConstant(type));
    }

    public Tag(Asn1Class clazz, Asn1Construction construction, Asn1Type type) {
        this.clazz = clazz;
        this.construction = construction;
        this.type = type;
    }

    public Asn1Class getClazz() {
        return this.clazz;
    }

    public Asn1Construction getConstruction() {
        return this.construction;
    }

    public Asn1Type getType() {
        return this.type;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Tag)) {
            return false;
        }
        Tag other = (Tag)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Asn1Class this$clazz = this.getClazz();
        Asn1Class other$clazz = other.getClazz();
        if (this$clazz == null ? other$clazz != null : !((Object)((Object)this$clazz)).equals((Object)other$clazz)) {
            return false;
        }
        Asn1Construction this$construction = this.getConstruction();
        Asn1Construction other$construction = other.getConstruction();
        if (this$construction == null ? other$construction != null : !((Object)((Object)this$construction)).equals((Object)other$construction)) {
            return false;
        }
        Asn1Type this$type = this.getType();
        Asn1Type other$type = other.getType();
        return !(this$type == null ? other$type != null : !((Object)((Object)this$type)).equals((Object)other$type));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Tag;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Asn1Class $clazz = this.getClazz();
        result = result * 59 + ($clazz == null ? 43 : ((Object)((Object)$clazz)).hashCode());
        Asn1Construction $construction = this.getConstruction();
        result = result * 59 + ($construction == null ? 43 : ((Object)((Object)$construction)).hashCode());
        Asn1Type $type = this.getType();
        result = result * 59 + ($type == null ? 43 : ((Object)((Object)$type)).hashCode());
        return result;
    }

    public String toString() {
        return "Tag(clazz=" + (Object)((Object)this.getClazz()) + ", construction=" + (Object)((Object)this.getConstruction()) + ", type=" + (Object)((Object)this.getType()) + ")";
    }
}

