/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.faulttolerance.core.retry;

import io.smallrye.faulttolerance.core.FaultToleranceStrategy;
import io.smallrye.faulttolerance.core.InvocationContext;
import io.smallrye.faulttolerance.core.retry.AsyncDelay;
import io.smallrye.faulttolerance.core.retry.Retry;
import io.smallrye.faulttolerance.core.retry.RetryEvents;
import io.smallrye.faulttolerance.core.retry.RetryLogger;
import io.smallrye.faulttolerance.core.retry.SyncDelay;
import io.smallrye.faulttolerance.core.stopwatch.RunningStopwatch;
import io.smallrye.faulttolerance.core.stopwatch.Stopwatch;
import io.smallrye.faulttolerance.core.util.CompletionStages;
import io.smallrye.faulttolerance.core.util.ExceptionDecision;
import io.smallrye.faulttolerance.core.util.Preconditions;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Executor;
import java.util.function.Supplier;
import org.eclipse.microprofile.faulttolerance.exceptions.FaultToleranceException;

public class CompletionStageRetry<V>
extends Retry<CompletionStage<V>> {
    private final Supplier<AsyncDelay> delayBetweenRetries;

    public CompletionStageRetry(FaultToleranceStrategy<CompletionStage<V>> delegate, String description, ExceptionDecision exceptionDecision, long maxRetries, long maxTotalDurationInMillis, Supplier<AsyncDelay> delayBetweenRetries, Stopwatch stopwatch) {
        super(delegate, description, exceptionDecision, maxRetries, maxTotalDurationInMillis, SyncDelay.NONE, stopwatch);
        this.delayBetweenRetries = Preconditions.checkNotNull(delayBetweenRetries, "Delay must be set");
    }

    @Override
    public CompletionStage<V> apply(InvocationContext<CompletionStage<V>> ctx) {
        RetryLogger.LOG.trace("CompletionStageRetry started");
        try {
            CompletionStage<V> completionStage = this.doApply(ctx);
            return completionStage;
        }
        finally {
            RetryLogger.LOG.trace("CompletionStageRetry finished");
        }
    }

    private CompletionStage<V> doApply(InvocationContext<CompletionStage<V>> ctx) {
        AsyncDelay delay = this.delayBetweenRetries.get();
        RunningStopwatch runningStopwatch = this.stopwatch.start();
        return this.doRetry(ctx, 0, delay, runningStopwatch, null);
    }

    private CompletionStage<V> doRetry(InvocationContext<CompletionStage<V>> ctx, int attempt, AsyncDelay delay, RunningStopwatch stopwatch, Throwable lastFailure) {
        if (attempt == 0) {
            return this.afterDelay(ctx, attempt, delay, stopwatch, lastFailure);
        }
        if ((long)attempt <= this.maxRetries) {
            RetryLogger.LOG.debug(this.description + " invocation failed, retrying");
            ctx.fireEvent(RetryEvents.Retried.INSTANCE);
            CompletableFuture result = new CompletableFuture();
            delay.after(lastFailure, () -> CompletionStages.propagateCompletion(this.afterDelay(ctx, attempt, delay, stopwatch, lastFailure), result), ctx.get(Executor.class));
            return result;
        }
        ctx.fireEvent(RetryEvents.Finished.MAX_RETRIES_REACHED);
        if (lastFailure != null) {
            return CompletionStages.failedStage(lastFailure);
        }
        return CompletionStages.failedStage((Throwable)new FaultToleranceException(this.description + " reached max retries"));
    }

    private CompletionStage<V> afterDelay(InvocationContext<CompletionStage<V>> ctx, int attempt, AsyncDelay delay, RunningStopwatch stopwatch, Throwable lastFailure) {
        if (stopwatch.elapsedTimeInMillis() > this.maxTotalDurationInMillis) {
            ctx.fireEvent(RetryEvents.Finished.MAX_DURATION_REACHED);
            if (lastFailure != null) {
                return CompletionStages.failedStage(lastFailure);
            }
            return CompletionStages.failedStage((Throwable)new FaultToleranceException(this.description + " reached max retry duration"));
        }
        try {
            CompletableFuture result = new CompletableFuture();
            this.delegate.apply(ctx).whenComplete((value, exception) -> {
                if (exception == null) {
                    ctx.fireEvent(RetryEvents.Finished.VALUE_RETURNED);
                    result.complete(value);
                } else if (this.shouldAbortRetrying((Throwable)exception)) {
                    ctx.fireEvent(RetryEvents.Finished.EXCEPTION_NOT_RETRYABLE);
                    result.completeExceptionally((Throwable)exception);
                } else {
                    CompletionStages.propagateCompletion(this.doRetry(ctx, attempt + 1, delay, stopwatch, (Throwable)exception), result);
                }
            });
            return result;
        }
        catch (Throwable e) {
            if (this.shouldAbortRetrying(e)) {
                ctx.fireEvent(RetryEvents.Finished.EXCEPTION_NOT_RETRYABLE);
                return CompletionStages.failedStage(e);
            }
            return this.doRetry(ctx, attempt + 1, delay, stopwatch, e);
        }
    }
}

