/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.eis;

import jakarta.resource.ResourceException;
import jakarta.resource.cci.InteractionSpec;
import jakarta.resource.cci.MappedRecord;
import jakarta.resource.cci.Record;
import java.io.IOException;
import java.io.Writer;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Vector;
import org.eclipse.persistence.eis.EISAccessor;
import org.eclipse.persistence.eis.EISDOMRecord;
import org.eclipse.persistence.eis.EISException;
import org.eclipse.persistence.eis.RecordConverter;
import org.eclipse.persistence.eis.interactions.EISInteraction;
import org.eclipse.persistence.eis.interactions.QueryStringInteraction;
import org.eclipse.persistence.exceptions.QueryException;
import org.eclipse.persistence.exceptions.ValidationException;
import org.eclipse.persistence.internal.databaseaccess.DatasourceCall;
import org.eclipse.persistence.internal.databaseaccess.DatasourcePlatform;
import org.eclipse.persistence.internal.expressions.SQLStatement;
import org.eclipse.persistence.internal.helper.ClassConstants;
import org.eclipse.persistence.internal.helper.ConversionManager;
import org.eclipse.persistence.internal.oxm.XMLConversionManager;
import org.eclipse.persistence.internal.security.PrivilegedAccessHelper;
import org.eclipse.persistence.internal.sessions.AbstractRecord;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.oxm.record.DOMRecord;
import org.eclipse.persistence.queries.Call;
import org.eclipse.persistence.queries.DatabaseQuery;
import org.w3c.dom.Element;

public class EISPlatform
extends DatasourcePlatform {
    protected boolean isIndexedRecordSupported;
    protected boolean isMappedRecordSupported;
    protected boolean isDOMRecordSupported;
    protected boolean shouldConvertDataToStrings;
    protected boolean supportsLocalTransactions;
    protected boolean requiresAutoCommit;
    protected RecordConverter recordConverter;
    protected Method domMethod;
    protected XMLConversionManager xmlConversionManager;

    public EISPlatform() {
        this.setIsMappedRecordSupported(true);
        this.setIsIndexedRecordSupported(true);
        this.setIsDOMRecordSupported(false);
        this.setShouldConvertDataToStrings(false);
        this.setSupportsLocalTransactions(true);
        this.setRequiresAutoCommit(false);
    }

    public RecordConverter getRecordConverter() {
        return this.recordConverter;
    }

    public void setRecordConverter(RecordConverter recordConverter) {
        this.recordConverter = recordConverter;
    }

    public boolean requiresAutoCommit() {
        return this.requiresAutoCommit;
    }

    public void setRequiresAutoCommit(boolean requiresAutoCommit) {
        this.requiresAutoCommit = requiresAutoCommit;
    }

    public boolean supportsLocalTransactions() {
        return this.supportsLocalTransactions;
    }

    public void setSupportsLocalTransactions(boolean supportsLocalTransactions) {
        this.supportsLocalTransactions = supportsLocalTransactions;
    }

    public boolean isIndexedRecordSupported() {
        return this.isIndexedRecordSupported;
    }

    public void setIsIndexedRecordSupported(boolean isIndexedRecordSupported) {
        this.isIndexedRecordSupported = isIndexedRecordSupported;
    }

    public boolean isMappedRecordSupported() {
        return this.isMappedRecordSupported;
    }

    public void setIsMappedRecordSupported(boolean isMappedRecordSupported) {
        this.isMappedRecordSupported = isMappedRecordSupported;
    }

    public boolean isDOMRecordSupported() {
        return this.isDOMRecordSupported;
    }

    public void setIsDOMRecordSupported(boolean isDOMRecordSupported) {
        this.isDOMRecordSupported = isDOMRecordSupported;
    }

    public boolean shouldConvertDataToStrings() {
        return this.shouldConvertDataToStrings;
    }

    public void setShouldConvertDataToStrings(boolean shouldConvertDataToStrings) {
        this.shouldConvertDataToStrings = shouldConvertDataToStrings;
    }

    public InteractionSpec buildInteractionSpec(EISInteraction interaction) {
        return interaction.getInteractionSpec();
    }

    public Record createInputRecord(EISInteraction interaction, EISAccessor accessor) {
        Record input = interaction.createInputRecord(accessor);
        if (this.getRecordConverter() != null) {
            input = this.getRecordConverter().converterToAdapterRecord(input);
        }
        return input;
    }

    public Record createOutputRecord(EISInteraction interaction, AbstractRecord translationRow, EISAccessor accessor) {
        return null;
    }

    public AbstractRecord buildRow(Record record, EISInteraction interaction, EISAccessor accessor) {
        Record output = record;
        if (this.getRecordConverter() != null) {
            output = this.getRecordConverter().converterFromAdapterRecord(output);
        }
        return interaction.buildRow(output, accessor);
    }

    public Vector buildRows(Record record, EISInteraction interaction, EISAccessor accessor) {
        Record output = record;
        if (this.getRecordConverter() != null) {
            output = this.getRecordConverter().converterFromAdapterRecord(output);
        }
        return interaction.buildRows(output, accessor);
    }

    public Record createDOMRecord(String recordName, EISAccessor accessor) {
        try {
            return accessor.getRecordFactory().createMappedRecord(recordName);
        }
        catch (ResourceException exception) {
            throw EISException.resourceException(exception, accessor, null);
        }
    }

    public AbstractRecord createDatabaseRowFromDOMRecord(Record record, EISInteraction call, EISAccessor accessor) {
        return new EISDOMRecord(record);
    }

    public Object getValueFromRecord(String key, MappedRecord record, EISAccessor accessor) {
        return record.get((Object)key);
    }

    public void setDOMInRecord(Element dom, Record record, EISInteraction call, EISAccessor accessor) {
        if (this.domMethod == null) {
            Class[] argumentTypes = new Class[]{Element.class};
            try {
                this.domMethod = PrivilegedAccessHelper.callDoPrivilegedWithException(() -> PrivilegedAccessHelper.getMethod(record.getClass(), "setDom", argumentTypes, false));
            }
            catch (Exception notFound) {
                this.domMethod = PrivilegedAccessHelper.callDoPrivilegedWithException(() -> PrivilegedAccessHelper.getMethod(record.getClass(), "setDOM", argumentTypes, false), EISException::new);
            }
        }
        PrivilegedAccessHelper.callDoPrivilegedWithException(() -> PrivilegedAccessHelper.invokeMethod(this.domMethod, record, new Object[]{dom}), EISException::new);
    }

    public void setValueInRecord(String key, Object value, MappedRecord record, EISAccessor accessor) {
        Object recordValue = value;
        if (this.shouldConvertDataToStrings() && !(value instanceof Record) && !(value instanceof Collection)) {
            recordValue = this.getConversionManager().convertObject(value, ClassConstants.STRING);
        }
        record.put((Object)key, recordValue);
    }

    @Override
    public void appendParameter(Call call, Writer writer, Object parameter) {
        if (parameter instanceof Vector) {
            Vector records = (Vector)parameter;
            for (int index = 0; index < records.size(); ++index) {
                this.appendParameter(call, writer, records.elementAt(index));
            }
        } else if (parameter instanceof DOMRecord) {
            String xml = ((DOMRecord)parameter).transformToXML();
            int start = xml.indexOf(62);
            xml = xml.substring(start + 1, xml.length());
            try {
                writer.write(xml);
            }
            catch (IOException exception) {
                throw ValidationException.fileError(exception);
            }
        } else {
            super.appendParameter(call, writer, parameter);
        }
    }

    @Override
    public ConversionManager getConversionManager() {
        if (this.isDOMRecordSupported()) {
            if (this.xmlConversionManager == null) {
                this.xmlConversionManager = (XMLConversionManager)XMLConversionManager.getDefaultXMLManager().clone();
                this.xmlConversionManager.setLoader(super.getConversionManager().getLoader());
            }
            return this.xmlConversionManager;
        }
        return super.getConversionManager();
    }

    public DatasourceCall buildCallFromStatement(SQLStatement statement, DatabaseQuery query, AbstractSession session) {
        throw QueryException.noCallOrInteractionSpecified();
    }

    @Override
    public DatasourceCall buildNativeCall(String queryString) {
        return new QueryStringInteraction(queryString);
    }
}

