/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.management.interceptor;

import org.apache.cxf.interceptor.AttachmentInInterceptor;
import org.apache.cxf.interceptor.Fault;
import org.apache.cxf.management.interceptor.AbstractMessageResponseTimeInterceptor;
import org.apache.cxf.message.Exchange;
import org.apache.cxf.message.FaultMode;
import org.apache.cxf.message.Message;

public class ResponseTimeMessageInInterceptor
extends AbstractMessageResponseTimeInterceptor {
    public ResponseTimeMessageInInterceptor() {
        super("receive");
        this.addBefore(AttachmentInInterceptor.class.getName());
    }

    @Override
    public void handleMessage(Message message) throws Fault {
        Exchange ex = message.getExchange();
        boolean forceDisabled = Boolean.FALSE.equals(ex.get("org.apache.cxf.management.counter.enabled"));
        if (!forceDisabled && this.isServiceCounterEnabled(ex)) {
            if (this.isClient(message)) {
                if (!ex.isOneWay()) {
                    this.endHandlingMessage(ex);
                }
            } else {
                this.beginHandlingMessage(ex);
            }
        }
    }

    @Override
    public void handleFault(Message message) {
        Exchange ex = message.getExchange();
        if (Boolean.TRUE.equals(ex.get("org.apache.cxf.management.counter.enabled"))) {
            FaultMode mode = message.get(FaultMode.class);
            if (mode == null) {
                mode = FaultMode.UNCHECKED_APPLICATION_FAULT;
            }
            ex.put(FaultMode.class, mode);
        }
    }
}

