/*
 * Decompiled with CFR 0.152.
 */
package org.apache.webbeans.util;

import jakarta.enterprise.inject.AmbiguousResolutionException;
import jakarta.enterprise.inject.UnproxyableResolutionException;
import jakarta.enterprise.inject.UnsatisfiedResolutionException;
import jakarta.enterprise.inject.spi.Bean;
import jakarta.enterprise.inject.spi.InjectionPoint;
import java.lang.annotation.Annotation;
import java.util.Set;
import org.apache.webbeans.exception.helper.ViolationMessageBuilder;
import org.apache.webbeans.util.ClassUtil;

public class InjectionExceptionUtil {
    private InjectionExceptionUtil() {
    }

    public static UnproxyableResolutionException createUnproxyableResolutionException(ViolationMessageBuilder violationMessage) {
        return new UnproxyableResolutionException(ViolationMessageBuilder.newViolation("WebBeans with api type with normal scope must be proxyable.").addLine(violationMessage.toString()).toString());
    }

    public static void throwUnsatisfiedResolutionException(Class type, InjectionPoint injectionPoint, Annotation ... qualifiers) {
        ViolationMessageBuilder violationMessage = ViolationMessageBuilder.newViolation("Api type [", type.getName(), "] is not found with the qualifiers ");
        violationMessage.addLine(InjectionExceptionUtil.createQualifierMessage(injectionPoint, qualifiers));
        if (injectionPoint != null) {
            violationMessage.addLine("for injection into ", injectionPoint.toString());
        }
        throw new UnsatisfiedResolutionException(violationMessage.toString());
    }

    public static void throwAmbiguousResolutionExceptionForBeanName(Set<Bean<?>> beans, String beanName) {
        InjectionExceptionUtil.throwAmbiguousResolutionExceptionForBeans(beans, ViolationMessageBuilder.newViolation("There are more than one WebBeans with name : ", beanName));
    }

    public static void throwAmbiguousResolutionException(Set<Bean<?>> beans) {
        InjectionExceptionUtil.throwAmbiguousResolutionException(beans, null, null, new Annotation[0]);
    }

    public static void throwAmbiguousResolutionException(Set<Bean<?>> beans, Class type, InjectionPoint injectionPoint, Annotation ... qualifiers) {
        String classString;
        String qualifierMessage = InjectionExceptionUtil.createQualifierMessage(injectionPoint, qualifiers);
        String string = classString = type != null ? ClassUtil.getClass(type).getName() : null;
        if (classString == null && injectionPoint != null) {
            classString = ClassUtil.getClass(injectionPoint.getType()).getName();
        }
        ViolationMessageBuilder violationMessage = ViolationMessageBuilder.newViolation("There is more than one Bean ", classString != null ? "with type " + classString + " " : "", qualifierMessage);
        if (injectionPoint != null) {
            violationMessage.addLine("for injection into ", injectionPoint.toString());
        }
        InjectionExceptionUtil.throwAmbiguousResolutionExceptionForBeans(beans, violationMessage);
    }

    private static void throwAmbiguousResolutionExceptionForBeans(Set<Bean<?>> beans, ViolationMessageBuilder violationMessage) {
        violationMessage.addLine("found beans: ");
        InjectionExceptionUtil.addBeanInfo(beans, violationMessage);
        throw new AmbiguousResolutionException(violationMessage.toString());
    }

    private static void addBeanInfo(Set<Bean<?>> beans, ViolationMessageBuilder violationMessage) {
        for (Bean<?> currentBean : beans) {
            String sourcePath;
            try {
                Class beanClass = currentBean.getBeanClass();
                sourcePath = beanClass.getResource(beanClass.getSimpleName() + ".class").toExternalForm();
            }
            catch (RuntimeException e) {
                sourcePath = "unknown path";
            }
            violationMessage.addLine(currentBean.toString() + " from " + sourcePath);
        }
    }

    private static String createQualifierMessage(InjectionPoint injectionPoint, Annotation ... qualifiers) {
        if (qualifiers == null || qualifiers.length == 0) {
            if (injectionPoint != null) {
                qualifiers = injectionPoint.getQualifiers().toArray(new Annotation[injectionPoint.getQualifiers().size()]);
            } else {
                return "@Default";
            }
        }
        StringBuilder qualifierMessage = new StringBuilder("Qualifiers: [");
        int i = 0;
        for (Annotation annot : qualifiers) {
            qualifierMessage.append(annot);
            if (++i == qualifiers.length) continue;
            qualifierMessage.append(",");
        }
        qualifierMessage.append("]");
        return qualifierMessage.toString();
    }
}

