/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jaxrs.utils;

import jakarta.ws.rs.core.MediaType;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.apache.cxf.jaxrs.utils.MimeTypesIntersector;

public class AccumulatingIntersector
implements MimeTypesIntersector {
    private static final String MEDIA_TYPE_DISTANCE_PARAM = "d";
    private final Set<MediaType> supportedMimeTypeList = new LinkedHashSet<MediaType>();
    private final boolean addRequiredParamsIfPossible;
    private final boolean addDistanceParameter;

    AccumulatingIntersector(boolean addRequiredParamsIfPossible, boolean addDistanceParameter) {
        this.addRequiredParamsIfPossible = addRequiredParamsIfPossible;
        this.addDistanceParameter = addDistanceParameter;
    }

    @Override
    public boolean intersect(MediaType requiredType, MediaType userType) {
        boolean requiredTypeWildcard = requiredType.getType().equals("*");
        boolean requiredSubTypeWildcard = requiredType.getSubtype().contains("*");
        String type = requiredTypeWildcard ? userType.getType() : requiredType.getType();
        String subtype = requiredSubTypeWildcard ? userType.getSubtype() : requiredType.getSubtype();
        LinkedHashMap parameters = userType.getParameters();
        if (this.addRequiredParamsIfPossible) {
            parameters = new LinkedHashMap(parameters);
            for (Map.Entry entry : requiredType.getParameters().entrySet()) {
                if (parameters.containsKey(entry.getKey())) continue;
                parameters.put(entry.getKey(), entry.getValue());
            }
        }
        if (this.addDistanceParameter) {
            int distance = 0;
            if (requiredTypeWildcard) {
                ++distance;
            }
            if (requiredSubTypeWildcard) {
                ++distance;
            }
            parameters.put(MEDIA_TYPE_DISTANCE_PARAM, Integer.toString(distance));
        }
        this.getSupportedMimeTypeList().add(new MediaType(type, subtype, parameters));
        return true;
    }

    public Set<MediaType> getSupportedMimeTypeList() {
        return this.supportedMimeTypeList;
    }
}

