/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.context;

import jakarta.faces.application.ResourceDependency;
import jakarta.faces.component.UIComponent;
import jakarta.faces.component.UIViewRoot;
import jakarta.faces.component.visit.VisitCallback;
import jakarta.faces.component.visit.VisitContext;
import jakarta.faces.component.visit.VisitHint;
import jakarta.faces.component.visit.VisitResult;
import jakarta.faces.context.FacesContext;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.myfaces.context.RequestViewMetadata;

public class RequestViewContext {
    public static final String VIEW_CONTEXT_KEY = "oam.VIEW_CONTEXT";
    public static final String RESOURCE_DEPENDENCY_INSPECTED_CLASS = "oam.RDClass";
    private static final String SKIP_ITERATION_HINT = "jakarta.faces.visit.SKIP_ITERATION";
    private static final Set<VisitHint> VISIT_HINTS = Collections.unmodifiableSet(EnumSet.of(VisitHint.SKIP_ITERATION));
    private RequestViewMetadata requestViewMetadata = new RequestViewMetadata();
    private Map<String, Boolean> renderTargetMap = null;
    private Map<String, List<UIComponent>> renderTargetMapComponents = null;

    public RequestViewContext() {
    }

    public RequestViewContext(RequestViewMetadata rvm) {
    }

    public static RequestViewContext getCurrentInstance() {
        FacesContext ctx = FacesContext.getCurrentInstance();
        return RequestViewContext.getCurrentInstance(ctx);
    }

    public static RequestViewContext getCurrentInstance(FacesContext ctx) {
        return RequestViewContext.getCurrentInstance(ctx, ctx.getViewRoot());
    }

    public static RequestViewContext getCurrentInstance(FacesContext ctx, UIViewRoot root) {
        HashMap<UIViewRoot, RequestViewContext> map = (HashMap<UIViewRoot, RequestViewContext>)ctx.getAttributes().get(VIEW_CONTEXT_KEY);
        RequestViewContext rvc = null;
        if (map == null) {
            map = new HashMap<UIViewRoot, RequestViewContext>();
            rvc = new RequestViewContext();
            map.put(root, rvc);
            ctx.getAttributes().put(VIEW_CONTEXT_KEY, map);
            return rvc;
        }
        rvc = (RequestViewContext)map.get(root);
        if (rvc == null) {
            rvc = new RequestViewContext();
            map.put(root, rvc);
        }
        return rvc;
    }

    public static RequestViewContext getCurrentInstance(FacesContext ctx, UIViewRoot root, boolean create) {
        if (create) {
            return RequestViewContext.getCurrentInstance(ctx, root);
        }
        Map map = (Map)ctx.getAttributes().get(VIEW_CONTEXT_KEY);
        if (map != null) {
            return (RequestViewContext)map.get(root);
        }
        return null;
    }

    public static RequestViewContext newInstance(RequestViewMetadata rvm) {
        RequestViewContext clone = new RequestViewContext(rvm.cloneInstance());
        return clone;
    }

    public static void setCurrentInstance(FacesContext ctx, UIViewRoot root, RequestViewContext rvc) {
        HashMap<UIViewRoot, RequestViewContext> map = (HashMap<UIViewRoot, RequestViewContext>)ctx.getAttributes().get(VIEW_CONTEXT_KEY);
        if (map == null) {
            map = new HashMap<UIViewRoot, RequestViewContext>();
            rvc = new RequestViewContext();
            map.put(root, rvc);
            ctx.getAttributes().put(VIEW_CONTEXT_KEY, map);
        } else {
            map.put(root, rvc);
        }
    }

    public boolean isResourceDependencyAlreadyProcessed(ResourceDependency dependency) {
        return this.requestViewMetadata.isResourceDependencyAlreadyProcessed(dependency);
    }

    public void setResourceDependencyAsProcessed(ResourceDependency dependency) {
        this.requestViewMetadata.setResourceDependencyAsProcessed(dependency);
    }

    public boolean isClassAlreadyProcessed(Class<?> inspectedClass) {
        return this.requestViewMetadata.isClassAlreadyProcessed(inspectedClass);
    }

    public void setClassProcessed(Class<?> inspectedClass) {
        this.requestViewMetadata.setClassProcessed(inspectedClass);
    }

    public boolean isRenderTarget(String target) {
        if (this.renderTargetMap != null) {
            return Boolean.TRUE.equals(this.renderTargetMap.get(target));
        }
        return false;
    }

    public void setRenderTarget(String target, boolean value, UIComponent component) {
        List<UIComponent> componentList;
        if (this.renderTargetMap == null) {
            this.renderTargetMap = new HashMap<String, Boolean>(8);
        }
        this.renderTargetMap.put(target, value);
        if (this.renderTargetMapComponents == null) {
            this.renderTargetMapComponents = new HashMap<String, List<UIComponent>>(8);
        }
        if ((componentList = this.renderTargetMapComponents.get(target)) == null) {
            componentList = new ArrayList<UIComponent>(8);
            this.renderTargetMapComponents.put(target, componentList);
        }
        if (!componentList.contains(component)) {
            componentList.add(component);
        }
    }

    public List<UIComponent> getRenderTargetComponentList(String target) {
        if (this.renderTargetMapComponents == null) {
            return Collections.emptyList();
        }
        List<UIComponent> list = this.renderTargetMapComponents.get(target);
        return list != null ? list : Collections.emptyList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refreshRequestViewContext(FacesContext facesContext, UIViewRoot root) {
        for (Map.Entry entry : root.getFacets().entrySet()) {
            UIComponent facet = (UIComponent)entry.getValue();
            if (facet.getId() == null || !facet.getId().startsWith("jakarta_faces_location_")) continue;
            try {
                facesContext.getAttributes().put(SKIP_ITERATION_HINT, Boolean.TRUE);
                VisitContext visitContext = VisitContext.createVisitContext((FacesContext)facesContext, null, VISIT_HINTS);
                facet.visitTree(visitContext, (VisitCallback)new RefreshViewContext());
            }
            finally {
                facesContext.getAttributes().remove(SKIP_ITERATION_HINT);
            }
        }
    }

    public RequestViewMetadata getRequestViewMetadata() {
        return this.requestViewMetadata;
    }

    public void setRequestViewMetadata(RequestViewMetadata requestViewMetadata) {
        this.requestViewMetadata = requestViewMetadata;
    }

    private class RefreshViewContext
    implements VisitCallback {
        private RefreshViewContext() {
        }

        public VisitResult visit(VisitContext context, UIComponent target) {
            Class inspectedClass = (Class)target.getAttributes().get(RequestViewContext.RESOURCE_DEPENDENCY_INSPECTED_CLASS);
            if (inspectedClass != null) {
                RequestViewContext.this.setClassProcessed(inspectedClass);
            }
            return VisitResult.ACCEPT;
        }
    }
}

