/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.rs.security.oauth2.tokens.hawk;

import jakarta.ws.rs.core.MultivaluedMap;
import java.util.List;
import java.util.Map;
import org.apache.cxf.jaxrs.ext.MessageContext;
import org.apache.cxf.jaxrs.impl.MetadataMap;
import org.apache.cxf.rs.security.oauth2.common.AccessTokenValidation;
import org.apache.cxf.rs.security.oauth2.provider.AccessTokenValidator;
import org.apache.cxf.rs.security.oauth2.provider.OAuthServiceException;
import org.apache.cxf.rs.security.oauth2.tokens.hawk.AbstractHawkAccessTokenValidator;

public class HawkAccessTokenValidatorClient
extends AbstractHawkAccessTokenValidator {
    private AccessTokenValidator validator;

    @Override
    public AccessTokenValidation validateAccessToken(MessageContext mc, String authScheme, String authSchemeData, MultivaluedMap<String, String> extraProps) throws OAuthServiceException {
        if (this.isRemoteSignatureValidation()) {
            MetadataMap<String, String> map = new MetadataMap<String, String>();
            if (extraProps != null) {
                map.putAll((Map)extraProps);
            }
            map.putSingle("http.verb", mc.getRequest().getMethod());
            map.putSingle("http.uri", mc.getUriInfo().getRequestUri().toString());
            return this.validator.validateAccessToken(mc, authScheme, authSchemeData, map);
        }
        return super.validateAccessToken(mc, authScheme, authSchemeData, extraProps);
    }

    @Override
    protected AccessTokenValidation getAccessTokenValidation(MessageContext mc, String authScheme, String authSchemeData, MultivaluedMap<String, String> extraProps, Map<String, String> schemeParams) {
        return this.validator.validateAccessToken(mc, authScheme, authSchemeData, extraProps);
    }

    public void setValidator(AccessTokenValidator validator) {
        List<String> schemes = validator.getSupportedAuthorizationSchemes();
        if (!schemes.contains("*") && !schemes.contains("Hawk")) {
            throw new IllegalArgumentException();
        }
        this.validator = validator;
    }
}

