/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomee.microprofile.openapi;

import io.smallrye.openapi.api.OpenApiConfig;
import io.smallrye.openapi.api.OpenApiConfigImpl;
import io.smallrye.openapi.api.OpenApiDocument;
import io.smallrye.openapi.runtime.OpenApiProcessor;
import io.smallrye.openapi.runtime.OpenApiStaticFile;
import io.smallrye.openapi.runtime.io.Format;
import jakarta.servlet.ServletContainerInitializer;
import jakarta.servlet.ServletContext;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRegistration;
import java.net.URL;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Stream;
import org.apache.tomee.microprofile.openapi.MicroProfileOpenApiEndpoint;
import org.eclipse.microprofile.config.Config;
import org.eclipse.microprofile.config.ConfigProvider;
import org.eclipse.microprofile.openapi.models.OpenAPI;

public class MicroProfileOpenApiRegistration
implements ServletContainerInitializer {
    public void onStartup(Set<Class<?>> classes, ServletContext ctx) throws ServletException {
        ServletRegistration.Dynamic servletRegistration = ctx.addServlet("mp-openapi-servlet", MicroProfileOpenApiEndpoint.class);
        servletRegistration.addMapping(new String[]{"/openapi/*"});
        this.openApi(ctx);
    }

    private void openApi(ServletContext servletContext) {
        try {
            Optional staticOpenApi = Stream.of(this.readOpenApiFile(servletContext, "/META-INF/openapi.json", Format.JSON), this.readOpenApiFile(servletContext, "/META-INF/openapi.yaml", Format.YAML), this.readOpenApiFile(servletContext, "/META-INF/openapi.yml", Format.YAML)).filter(Optional::isPresent).findFirst().flatMap(file -> file);
            staticOpenApi.ifPresent(openAPI -> MicroProfileOpenApiRegistration.setOpenApi(servletContext, openAPI));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void setOpenApi(ServletContext servletContext, OpenAPI openAPI) {
        Objects.requireNonNull(servletContext);
        Objects.requireNonNull(openAPI);
        servletContext.setAttribute(MicroProfileOpenApiRegistration.class.getName() + ".OpenAPI", (Object)openAPI);
    }

    public static OpenAPI getOpenApi(ServletContext servletContext) {
        Objects.requireNonNull(servletContext);
        return (OpenAPI)servletContext.getAttribute(MicroProfileOpenApiRegistration.class.getName() + ".OpenAPI");
    }

    private Optional<OpenAPI> readOpenApiFile(ServletContext servletContext, String location, Format format) throws Exception {
        URL resource = servletContext.getResource(location);
        if (resource == null) {
            return Optional.empty();
        }
        OpenApiDocument document = OpenApiDocument.INSTANCE;
        try {
            Optional<OpenAPI> optional;
            try (OpenApiStaticFile staticFile = new OpenApiStaticFile(resource.openStream(), format);){
                Config config = ConfigProvider.getConfig();
                OpenApiConfigImpl openApiConfig = new OpenApiConfigImpl(config);
                document.reset();
                document.config((OpenApiConfig)openApiConfig);
                document.filter(OpenApiProcessor.getFilter((OpenApiConfig)openApiConfig, (ClassLoader)Thread.currentThread().getContextClassLoader()));
                document.modelFromStaticFile(OpenApiProcessor.modelFromStaticFile((OpenApiStaticFile)staticFile));
                document.initialize();
                optional = Optional.of(document.get());
            }
            return optional;
        }
        finally {
            document.reset();
        }
    }
}

