/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomee.microprofile;

import jakarta.servlet.ServletContext;
import jakarta.servlet.ServletRegistration;
import java.io.File;
import java.net.MalformedURLException;
import java.security.CodeSource;
import java.util.Collection;
import java.util.List;
import java.util.stream.Stream;
import org.apache.openejb.assembler.classic.WebAppInfo;
import org.apache.openejb.config.event.EnhanceScannableUrlsEvent;
import org.apache.openejb.loader.SystemInstance;
import org.apache.openejb.observer.Observes;
import org.apache.openejb.observer.event.BeforeEvent;
import org.apache.openejb.util.LogCategory;
import org.apache.openejb.util.Logger;
import org.apache.tomee.catalina.event.AfterApplicationCreated;
import org.apache.tomee.installer.Paths;

public class TomEEMicroProfileListener {
    private static final String[] MICROPROFILE_LIBS_IMPLS_PREFIXES = new String[]{"mp-common"};
    private static final String[] MICROPROFILE_EXTENSIONS = new String[]{"org.apache.tomee.microprofile.jwt.cdi.MPJWTCDIExtension", "org.apache.cxf.microprofile.client.cdi.RestClientExtension", "io.smallrye.config.inject.ConfigExtension", "io.smallrye.metrics.setup.MetricCdiInjectionExtension", "io.smallrye.opentracing.SmallRyeTracingDynamicFeature", "io.smallrye.opentracing.contrib.interceptor.OpenTracingInterceptor", "io.smallrye.faulttolerance.FaultToleranceExtension"};

    public void enhanceScannableUrls(@Observes EnhanceScannableUrlsEvent enhanceScannableUrlsEvent) {
        String mpScan = SystemInstance.get().getOptions().get("tomee.mp.scan", "none");
        if (mpScan.equals("none")) {
            Stream.of(MICROPROFILE_EXTENSIONS).forEach(extension -> SystemInstance.get().setProperty(extension + ".active", "false"));
            return;
        }
        List containerUrls = enhanceScannableUrlsEvent.getScannableUrls();
        for (String extension2 : MICROPROFILE_EXTENSIONS) {
            try {
                CodeSource src = Class.forName(extension2).getProtectionDomain().getCodeSource();
                if (src == null) continue;
                containerUrls.add(src.getLocation());
            }
            catch (ClassNotFoundException | IncompatibleClassChangeError | NoClassDefFoundError e) {
                Logger.getInstance((LogCategory)LogCategory.OPENEJB.createChild("tomcat"), TomEEMicroProfileListener.class).error("Can't load MicroProfile extension " + extension2, e);
            }
        }
        Paths paths = new Paths(new File(System.getProperty("openejb.home")));
        for (String prefix : MICROPROFILE_LIBS_IMPLS_PREFIXES) {
            File file = paths.findTomEELibJar(prefix);
            if (file == null) continue;
            try {
                containerUrls.add(file.toURI().toURL());
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
        }
        SystemInstance.get().setProperty("openejb.cxf-rs.cache-application", "false");
    }

    public void processApplication(@Observes BeforeEvent<AfterApplicationCreated> afterApplicationCreated) {
        ServletContext context = ((AfterApplicationCreated)afterApplicationCreated.getEvent()).getContext();
        WebAppInfo webApp = ((AfterApplicationCreated)afterApplicationCreated.getEvent()).getWeb();
        context.getServletRegistrations().values().stream().map(ServletRegistration::getMappings).flatMap(Collection::stream).filter(mapping -> mapping.equals("/*")).findFirst().ifPresent(mapping -> {});
    }
}

