/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.faulttolerance;

import io.smallrye.faulttolerance.config.FaultToleranceOperation;
import io.smallrye.faulttolerance.core.invocation.AsyncSupportRegistry;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import java.util.concurrent.Future;
import org.eclipse.microprofile.config.inject.ConfigProperty;

@Singleton
public class SpecCompatibility {
    private final boolean compatible;

    @Inject
    public SpecCompatibility(@ConfigProperty(name="smallrye.faulttolerance.mp-compatibility", defaultValue="true") boolean compatible) {
        this.compatible = compatible;
    }

    public boolean isOperationTrulyAsynchronous(FaultToleranceOperation operation) {
        boolean supported = AsyncSupportRegistry.isKnown((Class[])operation.getParameterTypes(), operation.getReturnType());
        if (this.compatible) {
            boolean hasAnnotation = operation.hasAsynchronous() || operation.hasBlocking() || operation.hasNonBlocking();
            return supported && hasAnnotation;
        }
        return supported;
    }

    public boolean isOperationPseudoAsynchronous(FaultToleranceOperation operation) {
        boolean returnTypeMatches = Future.class.equals(operation.getReturnType());
        return returnTypeMatches && operation.hasAsynchronous();
    }

    public boolean isOperationTrulyOrPseudoAsynchronous(FaultToleranceOperation operation) {
        return this.isOperationTrulyAsynchronous(operation) || this.isOperationPseudoAsynchronous(operation);
    }

    public boolean inspectExceptionCauseChain() {
        return !this.compatible;
    }
}

