/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.ra;

import jakarta.jms.Connection;
import jakarta.jms.ConnectionFactory;
import jakarta.jms.JMSException;
import jakarta.jms.QueueConnection;
import jakarta.jms.QueueConnectionFactory;
import jakarta.jms.TopicConnection;
import jakarta.jms.TopicConnectionFactory;
import jakarta.resource.Referenceable;
import jakarta.resource.ResourceException;
import jakarta.resource.spi.ConnectionManager;
import jakarta.resource.spi.ConnectionRequestInfo;
import jakarta.resource.spi.ManagedConnectionFactory;
import java.io.Serializable;
import javax.naming.Reference;
import org.apache.activemq.ra.ActiveMQConnectionRequestInfo;
import org.apache.activemq.ra.ActiveMQManagedConnectionFactory;
import org.apache.activemq.ra.InboundConnectionProxy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ActiveMQConnectionFactory
implements ConnectionFactory,
QueueConnectionFactory,
TopicConnectionFactory,
Referenceable,
Serializable {
    private static final long serialVersionUID = -5754338187296859149L;
    private static final Logger LOG = LoggerFactory.getLogger(ActiveMQConnectionFactory.class);
    private ConnectionManager manager;
    private ActiveMQManagedConnectionFactory factory;
    private Reference reference;
    private final ActiveMQConnectionRequestInfo info;

    public ActiveMQConnectionFactory(ActiveMQManagedConnectionFactory factory, ConnectionManager manager, ActiveMQConnectionRequestInfo connectionRequestInfo) {
        this.factory = factory;
        this.manager = manager;
        this.info = connectionRequestInfo;
    }

    public Connection createConnection() throws JMSException {
        return this.createConnection(this.info.copy());
    }

    public Connection createConnection(String userName, String password) throws JMSException {
        ActiveMQConnectionRequestInfo i = this.info.copy();
        i.setUserName(userName);
        i.setPassword(password);
        return this.createConnection(i);
    }

    private Connection createConnection(ActiveMQConnectionRequestInfo connectionRequestInfo) throws JMSException {
        try {
            if (connectionRequestInfo.isUseInboundSessionEnabled()) {
                return new InboundConnectionProxy();
            }
            if (this.manager == null) {
                throw new JMSException("No JCA ConnectionManager configured! Either enable UseInboundSessionEnabled or get your JCA container to configure one.");
            }
            return (Connection)this.manager.allocateConnection((ManagedConnectionFactory)this.factory, (ConnectionRequestInfo)connectionRequestInfo);
        }
        catch (ResourceException e) {
            if (e.getCause() instanceof JMSException) {
                throw (JMSException)e.getCause();
            }
            LOG.debug("Connection could not be created:", (Throwable)e);
            JMSException jmsException = new JMSException(e.getMessage());
            jmsException.setLinkedException((Exception)((Object)e));
            throw jmsException;
        }
    }

    public Reference getReference() {
        return this.reference;
    }

    public void setReference(Reference reference) {
        this.reference = reference;
    }

    public QueueConnection createQueueConnection() throws JMSException {
        return (QueueConnection)this.createConnection();
    }

    public QueueConnection createQueueConnection(String userName, String password) throws JMSException {
        return (QueueConnection)this.createConnection(userName, password);
    }

    public TopicConnection createTopicConnection() throws JMSException {
        return (TopicConnection)this.createConnection();
    }

    public TopicConnection createTopicConnection(String userName, String password) throws JMSException {
        return (TopicConnection)this.createConnection(userName, password);
    }
}

