/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.microprofile.client.proxy;

import jakarta.ws.rs.client.InvocationCallback;
import jakarta.ws.rs.core.Configuration;
import jakarta.ws.rs.core.MultivaluedHashMap;
import jakarta.ws.rs.core.MultivaluedMap;
import jakarta.ws.rs.core.Response;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.net.URI;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletionException;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ExecutorService;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.cxf.common.classloader.ClassLoaderUtils;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.common.util.ReflectionUtil;
import org.apache.cxf.helpers.CastUtils;
import org.apache.cxf.interceptor.Interceptor;
import org.apache.cxf.jaxrs.client.ClientProxyImpl;
import org.apache.cxf.jaxrs.client.ClientState;
import org.apache.cxf.jaxrs.client.JaxrsClientCallback;
import org.apache.cxf.jaxrs.client.LocalClientState;
import org.apache.cxf.jaxrs.client.spec.TLSConfiguration;
import org.apache.cxf.jaxrs.model.AbstractResourceInfo;
import org.apache.cxf.jaxrs.model.ClassResourceInfo;
import org.apache.cxf.jaxrs.model.OperationResourceInfo;
import org.apache.cxf.jaxrs.model.Parameter;
import org.apache.cxf.jaxrs.model.ParameterType;
import org.apache.cxf.jaxrs.model.ProviderInfo;
import org.apache.cxf.jaxrs.utils.HttpUtils;
import org.apache.cxf.jaxrs.utils.InjectionUtils;
import org.apache.cxf.message.Exchange;
import org.apache.cxf.message.Message;
import org.apache.cxf.microprofile.client.MPRestClientCallback;
import org.apache.cxf.microprofile.client.MicroProfileClientProviderFactory;
import org.apache.cxf.microprofile.client.cdi.CDIFacade;
import org.apache.cxf.microprofile.client.cdi.CDIInterceptorWrapper;
import org.apache.cxf.microprofile.client.cdi.Instance;
import org.apache.cxf.microprofile.client.proxy.MPAsyncInvocationInterceptorImpl;
import org.apache.cxf.microprofile.client.proxy.MPAsyncInvocationInterceptorPostAsyncImpl;
import org.apache.cxf.microprofile.client.proxy.MPAsyncInvocationInterceptorRemoveContextImpl;
import org.eclipse.microprofile.rest.client.annotation.ClientHeaderParam;
import org.eclipse.microprofile.rest.client.annotation.RegisterClientHeaders;
import org.eclipse.microprofile.rest.client.ext.ClientHeadersFactory;
import org.eclipse.microprofile.rest.client.ext.ResponseExceptionMapper;

public class MicroProfileClientProxyImpl
extends ClientProxyImpl {
    private static final Logger LOG;
    private static final InvocationCallback<Object> NO_OP_CALLBACK;
    private static final Method JAXRS_UTILS_GET_CURRENT_MESSAGE_METHOD;
    private final CDIInterceptorWrapper interceptorWrapper;
    private Object objectInstance;
    private Map<Class<ClientHeadersFactory>, ProviderInfo<ClientHeadersFactory>> clientHeaderFactories = new WeakHashMap<Class<ClientHeadersFactory>, ProviderInfo<ClientHeadersFactory>>();
    private List<Instance<?>> cdiInstances = new LinkedList();
    private final TLSConfiguration tlsConfig;

    public MicroProfileClientProxyImpl(URI baseURI, ClassLoader loader, ClassResourceInfo cri, boolean isRoot, boolean inheritHeaders, ExecutorService executorService, Configuration configuration, CDIInterceptorWrapper interceptorWrapper, TLSConfiguration tlsConfig, Object ... varValues) {
        super((ClientState)new LocalClientState(baseURI, configuration.getProperties()), loader, cri, isRoot, inheritHeaders, varValues);
        this.interceptorWrapper = interceptorWrapper;
        this.tlsConfig = tlsConfig;
        if (executorService == null) {
            throw new IllegalArgumentException("The executorService is required and must be provided");
        }
        this.init(executorService, configuration);
    }

    public MicroProfileClientProxyImpl(ClientState initialState, ClassLoader loader, ClassResourceInfo cri, boolean isRoot, boolean inheritHeaders, ExecutorService executorService, Configuration configuration, CDIInterceptorWrapper interceptorWrapper, TLSConfiguration tlsConfig, Object ... varValues) {
        super(initialState, loader, cri, isRoot, inheritHeaders, varValues);
        this.interceptorWrapper = interceptorWrapper;
        this.tlsConfig = tlsConfig;
        this.init(executorService, configuration);
    }

    private void init(ExecutorService executorService, Configuration configuration) {
        this.cfg.getRequestContext().put("executorService", executorService);
        this.cfg.getRequestContext().putAll(configuration.getProperties());
        List inboundChain = this.cfg.getInInterceptors();
        inboundChain.add(new MPAsyncInvocationInterceptorPostAsyncImpl());
        inboundChain.add(new MPAsyncInvocationInterceptorRemoveContextImpl());
    }

    protected InvocationCallback<Object> checkAsyncCallback(OperationResourceInfo ori, Map<String, Object> reqContext, Message outMessage) {
        InvocationCallback<Object> callback = (InvocationCallback<Object>)outMessage.getContent(InvocationCallback.class);
        if (callback == null && CompletionStage.class.equals(ori.getMethodToInvoke().getReturnType())) {
            callback = NO_OP_CALLBACK;
            outMessage.setContent(InvocationCallback.class, callback);
        }
        return callback;
    }

    protected boolean checkAsyncReturnType(OperationResourceInfo ori, Map<String, Object> reqContext, Message outMessage) {
        return CompletionStage.class.equals(ori.getMethodToInvoke().getReturnType());
    }

    protected Object doInvokeAsync(OperationResourceInfo ori, Message outMessage, InvocationCallback<Object> asyncCallback) {
        MPAsyncInvocationInterceptorImpl aiiImpl = new MPAsyncInvocationInterceptorImpl(outMessage);
        outMessage.getInterceptorChain().add((Interceptor)aiiImpl);
        this.setTimeouts(this.cfg.getRequestContext());
        super.doInvokeAsync(ori, outMessage, asyncCallback);
        JaxrsClientCallback cb = (JaxrsClientCallback)outMessage.getExchange().get(JaxrsClientCallback.class);
        return cb.createFuture();
    }

    protected void doRunInterceptorChain(Message message) {
        this.setTimeouts(this.cfg.getRequestContext());
        super.doRunInterceptorChain(message);
    }

    protected JaxrsClientCallback<?> newJaxrsClientCallback(InvocationCallback<Object> asyncCallback, Message outMessage, Class<?> responseClass, Type outGenericType) {
        return new MPRestClientCallback<Object>(asyncCallback, outMessage, responseClass, outGenericType);
    }

    protected void checkResponse(Method m, Response r, Message inMessage) throws Throwable {
        MicroProfileClientProviderFactory factory = MicroProfileClientProviderFactory.getInstance(inMessage);
        List<ResponseExceptionMapper<?>> mappers = factory.createResponseExceptionMapper(inMessage, Throwable.class);
        for (ResponseExceptionMapper<?> mapper : mappers) {
            Throwable t;
            if (!mapper.handles(r.getStatus(), r.getHeaders()) || (t = mapper.toThrowable(r)) == null) continue;
            if (t instanceof RuntimeException) {
                throw t;
            }
            if (CompletionStage.class.isAssignableFrom(m.getReturnType())) {
                throw new CompletionException(t);
            }
            if (m.getExceptionTypes() == null) continue;
            for (Class<?> c : m.getExceptionTypes()) {
                if (!c.isAssignableFrom(t.getClass())) continue;
                throw t;
            }
            if (!LOG.isLoggable(Level.FINEST)) continue;
            LOG.log(Level.FINEST, "ResponseExceptionMapper, " + mapper.getClass().getName() + ", handles response, but client method does not declare it's Throwable type, " + t.getClass().getName());
        }
    }

    protected Class<?> getReturnType(Method method, Message outMessage) {
        Class returnType = super.getReturnType(method, outMessage);
        if (CompletionStage.class.isAssignableFrom(returnType)) {
            Type t = method.getGenericReturnType();
            returnType = InjectionUtils.getActualType((Type)t);
        }
        return returnType;
    }

    protected Type getGenericReturnType(Class<?> serviceCls, Method method, Class<?> returnType) {
        ParameterizedType pt;
        Type genericReturnType = super.getGenericReturnType(serviceCls, method, returnType);
        if (genericReturnType instanceof ParameterizedType && CompletionStage.class.isAssignableFrom(InjectionUtils.getRawType((Type)(pt = (ParameterizedType)genericReturnType)))) {
            Type[] actualTypeArguments = pt.getActualTypeArguments();
            if (actualTypeArguments.length > 0 && actualTypeArguments[0] instanceof ParameterizedType) {
                return InjectionUtils.processGenericTypeIfNeeded(serviceCls, returnType, (Type)((ParameterizedType)actualTypeArguments[0]));
            }
            return returnType;
        }
        return genericReturnType;
    }

    protected Message createMessage(Object body, OperationResourceInfo ori, MultivaluedMap<String, String> headers, URI currentURI, Exchange exchange, Map<String, Object> invocationContext, boolean proxy) {
        Method m = ori.getMethodToInvoke();
        Message msg = super.createMessage(body, ori, headers, currentURI, exchange, invocationContext, proxy);
        HashMap<String, Method> filterProps = (HashMap<String, Method>)msg.getExchange().get((Object)"jaxrs.filter.properties");
        if (filterProps == null) {
            filterProps = new HashMap<String, Method>();
            msg.getExchange().put((Object)"jaxrs.filter.properties", filterProps);
        }
        filterProps.put("org.eclipse.microprofile.rest.client.invokedMethod", m);
        return msg;
    }

    protected void setTimeouts(Map<String, Object> props) {
        block4: {
            try {
                Long connectTimeout = this.getIntFromProps(props, "http.connection.timeout");
                Long readTimeout = this.getIntFromProps(props, "http.receive.timeout");
                if (connectTimeout > -1L) {
                    this.cfg.getHttpConduit().getClient().setConnectionTimeout(connectTimeout.longValue());
                }
                if (readTimeout > -1L) {
                    this.cfg.getHttpConduit().getClient().setReceiveTimeout(readTimeout.longValue());
                }
            }
            catch (Exception ex) {
                if (!LOG.isLoggable(Level.FINEST)) break block4;
                LOG.log(Level.FINEST, "Caught exception setting timeouts", ex);
            }
        }
    }

    private Long getIntFromProps(Map<String, Object> props, String key) {
        Long l;
        Object o = props.get(key);
        if (o == null) {
            return -1L;
        }
        if (o instanceof Long) {
            l = (Long)o;
        } else if (o instanceof String) {
            try {
                l = Long.parseLong((String)o);
            }
            catch (NumberFormatException ex) {
                LOG.log(Level.WARNING, "INVALID_TIMEOUT_PROPERTY", new Object[]{key, o});
                return -1L;
            }
        } else {
            LOG.log(Level.WARNING, "INVALID_TIMEOUT_PROPERTY", new Object[]{key, o});
            return -1L;
        }
        if (l < 0L) {
            LOG.log(Level.WARNING, "INVALID_TIMEOUT_PROPERTY", new Object[]{key, o});
            return -1L;
        }
        return l;
    }

    private String invokeBestFitComputeMethod(Class<?> clientIntf, ClientHeaderParam anno) throws Throwable {
        String value;
        String methodName = anno.value()[0];
        methodName = methodName.substring(1, methodName.length() - 1);
        Class computeClass = clientIntf;
        if (methodName.contains(".")) {
            String className = methodName.substring(0, methodName.lastIndexOf(46));
            methodName = methodName.substring(methodName.lastIndexOf(46) + 1);
            try {
                computeClass = ClassLoaderUtils.loadClass((String)className, clientIntf);
            }
            catch (ClassNotFoundException ex) {
                LOG.warning("Cannot find specified computeValue class, " + className);
                return null;
            }
        }
        Method m = null;
        boolean includeHeaderName = false;
        try {
            m = computeClass.getMethod(methodName, String.class);
            includeHeaderName = true;
        }
        catch (NoSuchMethodException expected) {
            try {
                m = computeClass.getMethod(methodName, new Class[0]);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                // empty catch block
            }
        }
        if (m == null) {
            value = null;
            LOG.warning("Cannot find specified computeValue method, " + methodName + ", on client interface, " + clientIntf.getName());
        } else {
            try {
                Object valueFromComputeMethod = includeHeaderName ? m.invoke(computeClass == clientIntf ? this.objectInstance : null, anno.name()) : m.invoke(computeClass == clientIntf ? this.objectInstance : null, new Object[0]);
                value = valueFromComputeMethod instanceof String[] ? HttpUtils.getHeaderString(Arrays.asList((String[])valueFromComputeMethod)) : (String)valueFromComputeMethod;
            }
            catch (Throwable t) {
                if (LOG.isLoggable(Level.FINEST)) {
                    LOG.log(Level.FINEST, "Caught exception invoking compute method", t);
                }
                if (t instanceof InvocationTargetException) {
                    throw t.getCause();
                }
                throw t;
            }
        }
        return value;
    }

    private Parameter createClientHeaderParameter(ClientHeaderParam anno, Class<?> clientIntf) {
        String headerValue;
        Parameter p = new Parameter(ParameterType.HEADER, anno.name());
        String[] values = anno.value();
        if (values[0] != null && values[0].length() > 2 && values[0].startsWith("{") && values[0].endsWith("}")) {
            try {
                headerValue = this.invokeBestFitComputeMethod(clientIntf, anno);
            }
            catch (Throwable t) {
                if (anno.required()) {
                    this.throwException(t);
                }
                return null;
            }
        } else {
            headerValue = HttpUtils.getHeaderString(Arrays.asList(values));
        }
        p.setDefaultValue(headerValue);
        return p;
    }

    protected void handleHeaders(Method m, Object[] params, MultivaluedMap<String, String> headers, List<Parameter> beanParams, MultivaluedMap<ParameterType, Parameter> map) {
        super.handleHeaders(m, params, headers, beanParams, map);
        try {
            Parameter p;
            String headerName;
            Class<?> declaringClass = m.getDeclaringClass();
            ClientHeaderParam[] clientHeaderAnnosOnInterface = (ClientHeaderParam[])declaringClass.getAnnotationsByType(ClientHeaderParam.class);
            ClientHeaderParam[] clientHeaderAnnosOnMethod = (ClientHeaderParam[])m.getAnnotationsByType(ClientHeaderParam.class);
            RegisterClientHeaders headersFactoryAnno = declaringClass.getAnnotation(RegisterClientHeaders.class);
            if (clientHeaderAnnosOnInterface.length < 1 && clientHeaderAnnosOnMethod.length < 1 && headersFactoryAnno == null) {
                return;
            }
            for (ClientHeaderParam methodAnno : clientHeaderAnnosOnMethod) {
                headerName = methodAnno.name();
                if (headers.containsKey((Object)headerName) || (p = this.createClientHeaderParameter(methodAnno, declaringClass)) == null) continue;
                headers.putSingle((Object)p.getName(), (Object)p.getDefaultValue());
            }
            for (ClientHeaderParam intfAnno : clientHeaderAnnosOnInterface) {
                headerName = intfAnno.name();
                if (headers.containsKey((Object)headerName) || (p = this.createClientHeaderParameter(intfAnno, declaringClass)) == null) continue;
                headers.putSingle((Object)p.getName(), (Object)p.getDefaultValue());
            }
            if (headersFactoryAnno != null) {
                Class headersFactoryClass = headersFactoryAnno.value();
                this.mergeHeaders(headersFactoryClass, headers);
            }
        }
        catch (Throwable t) {
            this.throwException(t);
        }
    }

    private <T> T mapInstance(Instance<T> instance) {
        this.cdiInstances.add(instance);
        return instance.getValue();
    }

    private void mergeHeaders(Class<ClientHeadersFactory> factoryCls, MultivaluedMap<String, String> existingHeaders) {
        block4: {
            try {
                ClientHeadersFactory factory;
                Message m;
                Message message = m = JAXRS_UTILS_GET_CURRENT_MESSAGE_METHOD == null ? null : (Message)JAXRS_UTILS_GET_CURRENT_MESSAGE_METHOD.invoke(null, new Object[0]);
                if (m != null) {
                    factory = CDIFacade.getInstanceFromCDI(factoryCls, m.getExchange().getBus()).map(this::mapInstance).orElse(factoryCls.newInstance());
                    ProviderInfo pi = this.clientHeaderFactories.computeIfAbsent(factoryCls, k -> new ProviderInfo((Object)factory, m.getExchange().getBus(), true));
                    InjectionUtils.injectContexts((Object)factory, (AbstractResourceInfo)pi, (Message)m);
                } else {
                    factory = CDIFacade.getInstanceFromCDI(factoryCls).map(this::mapInstance).orElse(factoryCls.newInstance());
                }
                MultivaluedMap updatedHeaders = factory.update(MicroProfileClientProxyImpl.getJaxrsHeaders(m), existingHeaders);
                existingHeaders.putAll((Map)updatedHeaders);
            }
            catch (Throwable t) {
                if (!LOG.isLoggable(Level.FINEST)) break block4;
                LOG.log(Level.FINEST, "Caught exception getting JAX-RS incoming headers", t);
            }
        }
    }

    public Object invoke(Object o, Method m, Object[] params) throws Throwable {
        this.checkClosed();
        this.objectInstance = o;
        return this.interceptorWrapper.invoke(o, m, params, new Invoker(o, m, params, this));
    }

    private Object invokeActual(Object o, Method m, Object[] params) throws Throwable {
        return super.invoke(o, m, params);
    }

    private void throwException(Throwable t) {
        if (t instanceof Error) {
            throw (Error)t;
        }
        if (t instanceof RuntimeException) {
            throw (RuntimeException)t;
        }
        throw new RuntimeException(t);
    }

    private static MultivaluedMap<String, String> getJaxrsHeaders(Message m) {
        MultivaluedHashMap headers = new MultivaluedHashMap();
        if (m != null) {
            headers.putAll(CastUtils.cast((Map)((Map)m.get((Object)Message.PROTOCOL_HEADERS))));
        }
        return headers;
    }

    public void close() {
        this.cdiInstances.forEach(Instance::release);
        super.close();
    }

    public TLSConfiguration getTlsConfig() {
        return this.tlsConfig;
    }

    static {
        Method m;
        LOG = LogUtils.getL7dLogger(MicroProfileClientProxyImpl.class);
        NO_OP_CALLBACK = new InvocationCallback<Object>(){

            public void failed(Throwable t) {
            }

            public void completed(Object o) {
            }
        };
        try {
            Class<?> jaxrsUtilsClass = Class.forName("org.apache.cxf.jaxrs.utils.JAXRSUtils");
            m = ReflectionUtil.getDeclaredMethod(jaxrsUtilsClass, (String)"getCurrentMessage", (Class[])new Class[0]);
        }
        catch (Throwable t) {
            if (LOG.isLoggable(Level.FINEST)) {
                LOG.log(Level.FINEST, "Caught exception getting JAXRUtils class", t);
            }
            m = null;
        }
        JAXRS_UTILS_GET_CURRENT_MESSAGE_METHOD = m;
    }

    private static class Invoker
    implements Callable<Object> {
        private final Object targetObject;
        private final Method method;
        private final Object[] params;
        private final MicroProfileClientProxyImpl proxy;

        Invoker(Object o, Method m, Object[] params, MicroProfileClientProxyImpl proxy) {
            this.targetObject = o;
            this.method = m;
            this.params = params;
            this.proxy = proxy;
        }

        @Override
        public Object call() throws Exception {
            try {
                return this.proxy.invokeActual(this.targetObject, this.method, this.params);
            }
            catch (Exception ex) {
                throw ex;
            }
            catch (Throwable t) {
                throw new RuntimeException(t);
            }
        }
    }
}

