/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.microprofile.client;

import jakarta.ws.rs.core.Configuration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import org.apache.cxf.Bus;
import org.apache.cxf.BusFactory;
import org.apache.cxf.common.classloader.ClassLoaderUtils;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.common.util.ClassHelper;
import org.apache.cxf.endpoint.Endpoint;
import org.apache.cxf.jaxrs.model.ProviderInfo;
import org.apache.cxf.jaxrs.provider.ProviderFactory;
import org.apache.cxf.message.Message;
import org.apache.cxf.microprofile.client.ContractComparator;
import org.apache.cxf.microprofile.client.MicroProfileClientFactoryBean;
import org.eclipse.microprofile.rest.client.ext.ResponseExceptionMapper;

public final class MicroProfileClientProviderFactory
extends ProviderFactory {
    static final String CLIENT_FACTORY_NAME;
    private static final Class<?> ASYNC_II_FACTORY_CLASS;
    private static final Logger LOG;
    private List<ProviderInfo<ResponseExceptionMapper<?>>> responseExceptionMappers = new ArrayList(1);
    private List<ProviderInfo<Object>> asyncInvocationInterceptorFactories = new ArrayList<ProviderInfo<Object>>();
    private final Comparator<ProviderInfo<?>> comparator;

    private MicroProfileClientProviderFactory(Bus bus, Comparator<ProviderInfo<?>> comparator) {
        super(bus);
        this.comparator = comparator;
    }

    public static MicroProfileClientProviderFactory createInstance(Bus bus, Comparator<ProviderInfo<?>> comparator) {
        if (bus == null) {
            bus = BusFactory.getThreadDefaultBus();
        }
        MicroProfileClientProviderFactory factory = new MicroProfileClientProviderFactory(bus, comparator);
        ProviderFactory.initFactory((ProviderFactory)factory);
        factory.setBusProviders();
        return factory;
    }

    public static MicroProfileClientProviderFactory getInstance(Message m) {
        Endpoint e = m.getExchange().getEndpoint();
        return MicroProfileClientProviderFactory.getInstance(e);
    }

    public static MicroProfileClientProviderFactory getInstance(Endpoint e) {
        return (MicroProfileClientProviderFactory)((Object)e.get((Object)CLIENT_FACTORY_NAME));
    }

    static Comparator<ProviderInfo<?>> createComparator(MicroProfileClientFactoryBean bean) {
        Comparator parent = (o1, o2) -> MicroProfileClientProviderFactory.compareCustomStatus((ProviderInfo)o1, (ProviderInfo)o2);
        return new ContractComparator(bean, parent);
    }

    protected void setProviders(boolean custom, boolean busGlobal, Object ... providers) {
        List theProviders = this.prepareProviders(custom, busGlobal, providers, null);
        super.setCommonProviders(theProviders);
        for (ProviderInfo provider : theProviders) {
            Class providerCls = ClassHelper.getRealClass((Bus)this.getBus(), (Object)provider.getProvider());
            if (ResponseExceptionMapper.class.isAssignableFrom(providerCls)) {
                this.addProviderToList(this.responseExceptionMappers, provider);
            }
            if (ASYNC_II_FACTORY_CLASS == null || !ASYNC_II_FACTORY_CLASS.isAssignableFrom(providerCls)) continue;
            this.addProviderToList(this.asyncInvocationInterceptorFactories, provider);
        }
        this.responseExceptionMappers.sort(this.comparator);
        this.asyncInvocationInterceptorFactories.sort(this.comparator);
        this.injectContextProxies(new Collection[]{this.responseExceptionMappers});
        this.injectContextProxies(new Collection[]{this.asyncInvocationInterceptorFactories});
    }

    public List<ResponseExceptionMapper<?>> createResponseExceptionMapper(Message m, Class<?> paramType) {
        if (this.responseExceptionMappers.isEmpty()) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(this.responseExceptionMappers.stream().map(ProviderInfo::getProvider).sorted(new ResponseExceptionMapperComparator()).collect(Collectors.toList()));
    }

    public List<ProviderInfo<Object>> getAsyncInvocationInterceptorFactories() {
        return this.asyncInvocationInterceptorFactories;
    }

    public void clearProviders() {
        super.clearProviders();
        this.responseExceptionMappers.clear();
        this.asyncInvocationInterceptorFactories.clear();
    }

    public Configuration getConfiguration(Message m) {
        return (Configuration)m.getExchange().getOutMessage().getContextualProperty(Configuration.class.getName());
    }

    static {
        Class c;
        CLIENT_FACTORY_NAME = MicroProfileClientProviderFactory.class.getName();
        LOG = LogUtils.getL7dLogger(MicroProfileClientProviderFactory.class);
        try {
            c = ClassLoaderUtils.loadClass((String)"org.eclipse.microprofile.rest.client.ext.AsyncInvocationInterceptorFactory", MicroProfileClientProviderFactory.class);
        }
        catch (ClassNotFoundException ex) {
            c = null;
            LOG.log(Level.FINEST, ex, () -> "Caught ClassNotFoundException - expected if using MP Rest Client 1.0 APIs");
        }
        ASYNC_II_FACTORY_CLASS = c;
    }

    private class ResponseExceptionMapperComparator
    implements Comparator<ResponseExceptionMapper<?>> {
        private ResponseExceptionMapperComparator() {
        }

        @Override
        public int compare(ResponseExceptionMapper<?> oLeft, ResponseExceptionMapper<?> oRight) {
            return oLeft.getPriority() - oRight.getPriority();
        }
    }
}

