/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.microprofile.client.cdi;

import java.util.IdentityHashMap;
import java.util.Map;
import org.apache.cxf.jaxrs.impl.ConfigurableImpl;
import org.apache.cxf.microprofile.client.cdi.CDIFacade;
import org.apache.cxf.microprofile.client.cdi.Instance;

public final class CDIInstantiator
implements ConfigurableImpl.Instantiator {
    static final CDIInstantiator INSTANCE = new CDIInstantiator();
    private final Map<Object, Instance<?>> cdiInstances = new IdentityHashMap();

    private CDIInstantiator() {
    }

    public <T> Object create(Class<T> cls) {
        try {
            return CDIFacade.getInstanceFromCDI(cls).map(i -> {
                Object instance = i.getValue();
                if (instance != null) {
                    this.cdiInstances.put(instance, (Instance<?>)i);
                }
                return instance;
            }).orElse(cls.newInstance());
        }
        catch (Throwable t) {
            throw new RuntimeException(t);
        }
    }

    public void release(Object instance) {
        Instance<?> cdiInstance = this.cdiInstances.remove(instance);
        if (cdiInstance != null) {
            cdiInstance.release();
        }
    }
}

