/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.jakartaee.bcel.classfile;

import java.io.DataInput;
import java.io.DataOutputStream;
import java.io.IOException;
import org.apache.tomcat.jakartaee.bcel.classfile.Attribute;
import org.apache.tomcat.jakartaee.bcel.classfile.ConstantPool;
import org.apache.tomcat.jakartaee.bcel.classfile.Utility;
import org.apache.tomcat.jakartaee.bcel.classfile.Visitor;

public final class NestMembers
extends Attribute {
    private int[] classes;

    public NestMembers(NestMembers c) {
        this(c.getNameIndex(), c.getLength(), c.getClasses(), c.getConstantPool());
    }

    public NestMembers(int name_index, int length, int[] classes, ConstantPool constant_pool) {
        super((byte)26, name_index, length, constant_pool);
        this.classes = classes != null ? classes : new int[]{};
    }

    NestMembers(int name_index, int length, DataInput input, ConstantPool constant_pool) throws IOException {
        this(name_index, length, (int[])null, constant_pool);
        int number_of_classes = input.readUnsignedShort();
        this.classes = new int[number_of_classes];
        for (int i = 0; i < number_of_classes; ++i) {
            this.classes[i] = input.readUnsignedShort();
        }
    }

    @Override
    public void accept(Visitor v) {
        v.visitNestMembers(this);
    }

    @Override
    public void dump(DataOutputStream file) throws IOException {
        super.dump(file);
        file.writeShort(this.classes.length);
        for (int index : this.classes) {
            file.writeShort(index);
        }
    }

    public int[] getClasses() {
        return this.classes;
    }

    public int getNumberClasses() {
        return this.classes == null ? 0 : this.classes.length;
    }

    public String[] getClassNames() {
        String[] names = new String[this.classes.length];
        for (int i = 0; i < this.classes.length; ++i) {
            names[i] = super.getConstantPool().getConstantString(this.classes[i], (byte)7).replace('/', '.');
        }
        return names;
    }

    public void setClasses(int[] classes) {
        this.classes = classes != null ? classes : new int[]{};
    }

    @Override
    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append("NestMembers(");
        buf.append(this.classes.length);
        buf.append("):\n");
        for (int index : this.classes) {
            String class_name = super.getConstantPool().getConstantString(index, (byte)7);
            buf.append("  ").append(Utility.compactClassName(class_name, false)).append("\n");
        }
        return buf.substring(0, buf.length() - 1);
    }

    @Override
    public Attribute copy(ConstantPool _constant_pool) {
        NestMembers c = (NestMembers)this.clone();
        if (this.classes != null) {
            c.classes = new int[this.classes.length];
            System.arraycopy(this.classes, 0, c.classes, 0, this.classes.length);
        }
        c.setConstantPool(_constant_pool);
        return c;
    }
}

