/*
 * Decompiled with CFR 0.152.
 */
package org.apache.johnzon.jsonb.factory;

import jakarta.enterprise.context.spi.CreationalContext;
import jakarta.enterprise.inject.spi.Bean;
import jakarta.enterprise.inject.spi.BeanManager;
import java.lang.annotation.Annotation;
import java.util.Set;
import org.apache.johnzon.jsonb.factory.SimpleJohnzonAdapterFactory;
import org.apache.johnzon.jsonb.spi.JohnzonAdapterFactory;

public class CdiJohnzonAdapterFactory
extends SimpleJohnzonAdapterFactory {
    private final BeanManager bm;

    public CdiJohnzonAdapterFactory(Object bm) {
        this.bm = (BeanManager)BeanManager.class.cast(bm);
    }

    @Override
    public <T> JohnzonAdapterFactory.Instance<T> create(Class<T> type) {
        try {
            Set beans = this.bm.getBeans(type, new Annotation[0]);
            Bean bean = this.bm.resolve(beans);
            if (bean != null) {
                CreationalContext creationalContext = this.bm.createCreationalContext(null);
                Object instance = this.bm.getReference(bean, type, creationalContext);
                if (this.bm.isNormalScope(bean.getScope())) {
                    return new JohnzonAdapterFactory.ConstantInstance<Object>(this.bm.getReference(bean, type, creationalContext));
                }
                return new CdiInstance(instance, creationalContext);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return super.create(type);
    }

    private static class CdiInstance<T>
    implements JohnzonAdapterFactory.Instance<T> {
        private final T value;
        private final CreationalContext<Object> context;

        private CdiInstance(T instance, CreationalContext<Object> creationalContext) {
            this.value = instance;
            this.context = creationalContext;
        }

        @Override
        public T getValue() {
            return this.value;
        }

        @Override
        public void release() {
            this.context.release();
        }
    }
}

