/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.server.cxf.rs;

import jakarta.ws.rs.core.Application;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.openejb.server.rest.InternalApplication;

public class ApplicationData {
    private final String path;
    private final Application application;
    private final Class<?> applicationClass;
    final List<Resource> resources = new ArrayList<Resource>();
    final List<Provider> providers = new ArrayList<Provider>();
    final List<Invalid> invalids = new ArrayList<Invalid>();

    public ApplicationData(String path, Application application) {
        this.path = path;
        this.application = application;
        if (application instanceof InternalApplication && ((InternalApplication)application).getOriginal() != null) {
            InternalApplication internalApplication = (InternalApplication)application;
            this.applicationClass = internalApplication.getOriginal().getClass();
        } else {
            this.applicationClass = application.getClass();
        }
    }

    public String getPath() {
        return this.path;
    }

    public Application getApplication() {
        return this.application;
    }

    public Class<?> getApplicationClass() {
        return this.applicationClass;
    }

    public List<Resource> getResources() {
        return this.resources;
    }

    public List<Class<?>> getResourceClasses() {
        return this.resources.stream().map(Resource::getClazz).collect(Collectors.toList());
    }

    public List<Provider> getProviders() {
        return this.providers;
    }

    public List<Invalid> getInvalids() {
        return this.invalids;
    }

    public void addProvider(boolean discovered, Class<?> clazz, Object singleton) {
        this.providers.add(new Provider(discovered, clazz, singleton));
    }

    public void addResource(boolean discovered, Class<?> clazz, Object singleton) {
        this.resources.add(new Resource(discovered, clazz, singleton));
    }

    public void addInvalid(Class<?> clazz, String reason) {
        this.invalids.add(new Invalid(clazz, reason));
    }

    public String toString() {
        return "Application{path='" + this.path + "', class=" + this.applicationClass.getName() + ", resources=" + this.resources.size() + ", providers=" + this.providers.size() + ", invalids=" + this.invalids.size() + "}";
    }

    public static class Invalid {
        private final Class<?> clazz;
        private final String reason;

        public Invalid(Class<?> clazz, String reason) {
            this.clazz = clazz;
            this.reason = reason;
        }

        public String toString() {
            return "Invalid{clazz=" + this.clazz.getName() + ", reason='" + this.reason + "'}";
        }
    }

    public static class Provider {
        private final Class<?> clazz;
        private final boolean discovered;
        private final Object singleton;

        public Provider(boolean discovered, Class<?> clazz, Object singleton) {
            this.discovered = discovered;
            this.clazz = clazz;
            this.singleton = singleton;
        }

        public String toString() {
            return "Provider{clazz=" + this.clazz.getName() + ", discovered=" + this.discovered + ", singleton=" + (this.singleton != null) + "}";
        }
    }

    public static class Resource {
        private final Class<?> clazz;
        private final boolean discovered;
        private final Object singleton;

        public Resource(boolean discovered, Class<?> clazz, Object singleton) {
            this.discovered = discovered;
            this.clazz = clazz;
            this.singleton = singleton;
        }

        public boolean isDiscovered() {
            return this.discovered;
        }

        public Class<?> getClazz() {
            return this.clazz;
        }

        public Object getSingleton() {
            return this.singleton;
        }

        public String toString() {
            return "Resource{clazz=" + this.clazz.getName() + ", discovered=" + this.discovered + ", singleton=" + (this.singleton != null) + "}";
        }
    }
}

