/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.el.unified.resolver;

import jakarta.el.ELContext;
import jakarta.el.ELException;
import jakarta.el.ELResolver;
import jakarta.el.PropertyNotFoundException;
import jakarta.el.PropertyNotWritableException;
import jakarta.faces.application.Application;
import jakarta.faces.context.FacesContext;
import java.beans.FeatureDescriptor;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import java.util.ResourceBundle;
import org.apache.myfaces.config.RuntimeConfig;

public final class ResourceBundleResolver
extends ELResolver {
    private RuntimeConfig runtimeConfig;

    public void setValue(ELContext context, Object base, Object property, Object value) throws NullPointerException, PropertyNotFoundException, PropertyNotWritableException, ELException {
        if (base != null) {
            return;
        }
        if (base == null && property == null) {
            throw new PropertyNotFoundException();
        }
        if (!(property instanceof String)) {
            return;
        }
        ResourceBundle bundle = ResourceBundleResolver.getResourceBundle(context, (String)property);
        if (bundle != null) {
            throw new PropertyNotWritableException("ResourceBundles are read-only");
        }
    }

    public boolean isReadOnly(ELContext context, Object base, Object property) throws NullPointerException, PropertyNotFoundException, ELException {
        if (base != null) {
            return false;
        }
        if (property == null) {
            throw new PropertyNotFoundException();
        }
        if (!(property instanceof String)) {
            return false;
        }
        ResourceBundle bundle = ResourceBundleResolver.getResourceBundle(context, (String)property);
        if (bundle != null) {
            context.setPropertyResolved(true);
            return true;
        }
        return false;
    }

    public Object getValue(ELContext context, Object base, Object property) throws NullPointerException, PropertyNotFoundException, ELException {
        if (base != null) {
            return null;
        }
        if (property == null) {
            throw new PropertyNotFoundException();
        }
        if (!(property instanceof String)) {
            return null;
        }
        ResourceBundle bundle = ResourceBundleResolver.getResourceBundle(context, (String)property);
        if (bundle != null) {
            context.setPropertyResolved(true);
            return bundle;
        }
        return null;
    }

    public Class<?> getType(ELContext context, Object base, Object property) throws NullPointerException, PropertyNotFoundException, ELException {
        if (base != null) {
            return null;
        }
        if (property == null) {
            throw new PropertyNotFoundException();
        }
        if (!(property instanceof String)) {
            return null;
        }
        ResourceBundle bundle = ResourceBundleResolver.getResourceBundle(context, (String)property);
        if (bundle != null) {
            context.setPropertyResolved(true);
            return ResourceBundle.class;
        }
        return null;
    }

    public Iterator<FeatureDescriptor> getFeatureDescriptors(ELContext context, Object base) {
        if (base != null) {
            return null;
        }
        ArrayList<FeatureDescriptor> descriptors = new ArrayList<FeatureDescriptor>();
        Map<String, org.apache.myfaces.config.element.ResourceBundle> resourceBundles = this.runtimeConfig(context).getResourceBundles();
        for (org.apache.myfaces.config.element.ResourceBundle resourceBundle : resourceBundles.values()) {
            descriptors.add(ResourceBundleResolver.makeDescriptor(resourceBundle));
        }
        return descriptors.iterator();
    }

    public Class<?> getCommonPropertyType(ELContext context, Object base) {
        if (base != null) {
            return null;
        }
        return String.class;
    }

    private static FacesContext facesContext(ELContext context) {
        return (FacesContext)context.getContext(FacesContext.class);
    }

    private static ResourceBundle getResourceBundle(ELContext context, String property) {
        FacesContext facesContext = ResourceBundleResolver.facesContext(context);
        if (facesContext != null) {
            Application application = facesContext.getApplication();
            return application.getResourceBundle(facesContext, property);
        }
        return null;
    }

    protected RuntimeConfig runtimeConfig(ELContext context) {
        FacesContext facesContext = ResourceBundleResolver.facesContext(context);
        if (this.runtimeConfig == null) {
            this.runtimeConfig = RuntimeConfig.getCurrentInstance(facesContext.getExternalContext());
        }
        return this.runtimeConfig;
    }

    private static FeatureDescriptor makeDescriptor(org.apache.myfaces.config.element.ResourceBundle bundle) {
        FeatureDescriptor fd = new FeatureDescriptor();
        fd.setValue("resolvableAtDesignTime", Boolean.TRUE);
        fd.setName(bundle.getVar());
        fd.setDisplayName(bundle.getDisplayName());
        fd.setValue("type", ResourceBundle.class);
        fd.setShortDescription("");
        fd.setExpert(false);
        fd.setHidden(false);
        fd.setPreferred(true);
        return fd;
    }
}

