/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.rs.security.jose.jaxrs;

import jakarta.annotation.Priority;
import jakarta.ws.rs.WebApplicationException;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.MultivaluedMap;
import jakarta.ws.rs.ext.WriterInterceptor;
import jakarta.ws.rs.ext.WriterInterceptorContext;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.apache.cxf.common.util.StringUtils;
import org.apache.cxf.helpers.IOUtils;
import org.apache.cxf.io.CachedOutputStream;
import org.apache.cxf.jaxrs.utils.JAXRSUtils;
import org.apache.cxf.rs.security.jose.jaxrs.AbstractJweJsonWriterProvider;
import org.apache.cxf.rs.security.jose.jaxrs.JoseJaxrsUtils;
import org.apache.cxf.rs.security.jose.jwe.JweEncryptionProvider;
import org.apache.cxf.rs.security.jose.jwe.JweHeaders;
import org.apache.cxf.rs.security.jose.jwe.JweJsonProducer;

@Priority(value=1001)
public class JweJsonWriterInterceptor
extends AbstractJweJsonWriterProvider
implements WriterInterceptor {
    private Set<String> protectedHttpHeaders;
    private boolean protectHttpHeaders;
    private boolean contentTypeRequired = true;
    private boolean useJweOutputStream;

    public void aroundWriteTo(WriterInterceptorContext ctx) throws IOException, WebApplicationException {
        if (ctx.getEntity() == null) {
            ctx.proceed();
            return;
        }
        OutputStream actualOs = ctx.getOutputStream();
        JweHeaders sharedProtectedHeaders = new JweHeaders();
        List<String> propLocs = this.getPropertyLocations();
        ArrayList<JweHeaders> perRecipientUnprotectedHeaders = new ArrayList<JweHeaders>(propLocs.size());
        for (int i = 0; i < propLocs.size(); ++i) {
            perRecipientUnprotectedHeaders.add(new JweHeaders());
        }
        List<JweEncryptionProvider> providers = this.getInitializedEncryptionProviders(propLocs, sharedProtectedHeaders, perRecipientUnprotectedHeaders);
        String ctString = null;
        MediaType contentMediaType = ctx.getMediaType();
        if (this.contentTypeRequired && contentMediaType != null) {
            ctString = "application".equals(contentMediaType.getType()) ? contentMediaType.getSubtype() : JAXRSUtils.mediaTypeToString(contentMediaType, new String[0]);
        }
        if (ctString != null) {
            sharedProtectedHeaders.setContentType(ctString);
        }
        this.protectHttpHeadersIfNeeded(ctx, sharedProtectedHeaders);
        if (!this.useJweOutputStream) {
            CachedOutputStream cos = new CachedOutputStream();
            ctx.setOutputStream((OutputStream)cos);
            ctx.proceed();
            JweJsonProducer producer = new JweJsonProducer(sharedProtectedHeaders, cos.getBytes());
            String jweContent = producer.encryptWith(providers, perRecipientUnprotectedHeaders);
            this.setJoseMediaType(ctx);
            IOUtils.copy(new ByteArrayInputStream(StringUtils.toBytesUTF8(jweContent)), actualOs);
            actualOs.flush();
        }
    }

    private void setJoseMediaType(WriterInterceptorContext ctx) {
        MediaType joseMediaType = JAXRSUtils.toMediaType("application/jose+json");
        ctx.setMediaType(joseMediaType);
    }

    public void setUseJweOutputStream(boolean useJweOutputStream) {
        this.useJweOutputStream = useJweOutputStream;
    }

    protected void protectHttpHeadersIfNeeded(WriterInterceptorContext ctx, JweHeaders jweHeaders) {
        if (this.protectHttpHeaders) {
            JoseJaxrsUtils.protectHttpHeaders((MultivaluedMap<String, Object>)ctx.getHeaders(), jweHeaders, this.protectedHttpHeaders);
        }
    }

    public void setProtectHttpHeaders(boolean protectHttpHeaders) {
        this.protectHttpHeaders = protectHttpHeaders;
    }

    public void setProtectedHttpHeaders(Set<String> protectedHttpHeaders) {
        this.protectedHttpHeaders = protectedHttpHeaders;
    }
}

