/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jaxws.spi;

import java.lang.reflect.Method;
import java.util.LinkedHashSet;
import java.util.Set;
import org.apache.cxf.Bus;
import org.apache.cxf.common.spi.GeneratedClassClassLoader;
import org.apache.cxf.common.util.PackageUtils;
import org.apache.cxf.common.util.StringUtils;
import org.apache.cxf.jaxws.spi.WrapperClassCreator;
import org.apache.cxf.jaxws.support.JaxWsServiceFactoryBean;
import org.apache.cxf.service.model.InterfaceInfo;
import org.apache.cxf.service.model.MessageInfo;
import org.apache.cxf.service.model.MessagePartInfo;
import org.apache.cxf.service.model.OperationInfo;

public class WrapperClassLoader
extends GeneratedClassClassLoader
implements WrapperClassCreator {
    public WrapperClassLoader(Bus bus) {
        super(bus);
    }

    @Override
    public Set<Class<?>> generate(JaxWsServiceFactoryBean factory, InterfaceInfo interfaceInfo, boolean q) {
        LinkedHashSet wrapperBeans = new LinkedHashSet();
        for (OperationInfo opInfo : interfaceInfo.getOperations()) {
            MessageInfo messageInfo;
            Method method;
            if (!opInfo.isUnwrappedCapable() || (method = (Method)opInfo.getProperty("operation.method")) == null) continue;
            MessagePartInfo inf = opInfo.getInput().getFirstMessagePart();
            if (inf.getTypeClass() == null) {
                messageInfo = opInfo.getUnwrappedOperation().getInput();
                wrapperBeans.add(this.createWrapperClass(inf, messageInfo, opInfo, method, true, factory));
            }
            if ((messageInfo = opInfo.getUnwrappedOperation().getOutput()) == null || (inf = opInfo.getOutput().getFirstMessagePart()).getTypeClass() != null) continue;
            wrapperBeans.add(this.createWrapperClass(inf, messageInfo, opInfo, method, false, factory));
        }
        return wrapperBeans;
    }

    private Class<?> createWrapperClass(MessagePartInfo wrapperPart, MessageInfo messageInfo, OperationInfo op, Method method, boolean isRequest, JaxWsServiceFactoryBean factory) {
        boolean anonymous = factory.getAnonymousWrapperTypes();
        String pkg = this.getPackageName(method) + ".jaxws_asm" + (anonymous ? "_an" : "");
        String className = pkg + "." + StringUtils.capitalize(op.getName().getLocalPart());
        if (!isRequest) {
            className = className + "Response";
        }
        Class<?> def = this.findClass(className, method.getDeclaringClass());
        String origClassName = className;
        int count = 0;
        while (def != null) {
            Boolean b = messageInfo.getProperty("parameterized", Boolean.class);
            if (b != null && b.booleanValue()) {
                className = origClassName + ++count;
                def = this.findClass(className, method.getDeclaringClass());
                continue;
            }
            wrapperPart.setTypeClass(def);
            return def;
        }
        return null;
    }

    private String getPackageName(Method method) {
        String pkg = PackageUtils.getPackageName(method.getDeclaringClass());
        return pkg.length() == 0 ? "defaultnamespace" : pkg;
    }
}

