/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.client;

import jakarta.ejb.EJBException;
import jakarta.ejb.EJBObject;
import java.lang.reflect.Method;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.UUID;
import java.util.concurrent.Callable;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.openejb.client.ApplicationException;
import org.apache.openejb.client.ClientMetaData;
import org.apache.openejb.client.EJBHomeHandler;
import org.apache.openejb.client.EJBHomeProxy;
import org.apache.openejb.client.EJBInvocationHandler;
import org.apache.openejb.client.EJBMetaDataImpl;
import org.apache.openejb.client.EJBObjectHandle;
import org.apache.openejb.client.EJBObjectProxy;
import org.apache.openejb.client.EJBObjectProxyHandle;
import org.apache.openejb.client.EJBRequest;
import org.apache.openejb.client.EJBResponse;
import org.apache.openejb.client.EntityEJBObjectHandler;
import org.apache.openejb.client.JNDIContext;
import org.apache.openejb.client.RequestMethodCode;
import org.apache.openejb.client.ServerMetaData;
import org.apache.openejb.client.SingletonEJBObjectHandler;
import org.apache.openejb.client.StatefulEJBObjectHandler;
import org.apache.openejb.client.StatelessEJBObjectHandler;
import org.apache.openejb.client.SystemError;
import org.apache.openejb.client.SystemException;
import org.apache.openejb.client.ThrowableArtifact;
import org.apache.openejb.client.proxy.InvocationHandler;
import org.apache.openejb.client.proxy.ProxyManager;
import org.apache.openejb.client.serializer.SerializationWrapper;
import org.apache.openejb.client.util.ClassLoaderUtil;

public abstract class EJBObjectHandler
extends EJBInvocationHandler {
    protected static final Method GETEJBHOME = EJBObjectHandler.getMethod(EJBObject.class, "getEJBHome", null);
    protected static final Method GETHANDLE = EJBObjectHandler.getMethod(EJBObject.class, "getHandle", null);
    protected static final Method GETPRIMARYKEY = EJBObjectHandler.getMethod(EJBObject.class, "getPrimaryKey", null);
    protected static final Method ISIDENTICAL = EJBObjectHandler.getMethod(EJBObject.class, "isIdentical", EJBObject.class);
    protected static final Method REMOVE = EJBObjectHandler.getMethod(EJBObject.class, "remove", null);
    protected static final Method GETHANDLER = EJBObjectHandler.getMethod(EJBObjectProxy.class, "getEJBObjectHandler", null);
    protected static final Method CANCEL = EJBObjectHandler.getMethod(Future.class, "cancel", Boolean.TYPE);
    public Object registryId;
    EJBHomeProxy ejbHome = null;
    protected ThreadPoolExecutor executor = null;

    public EJBObjectHandler() {
    }

    public EJBObjectHandler(ThreadPoolExecutor es, EJBMetaDataImpl ejb, ServerMetaData server, ClientMetaData client, JNDIContext.AuthenticationInfo auth) {
        super(ejb, server, client, null, auth);
        this.executor = es;
    }

    public EJBObjectHandler(ThreadPoolExecutor es, EJBMetaDataImpl ejb, ServerMetaData server, ClientMetaData client, Object primaryKey, JNDIContext.AuthenticationInfo auth) {
        super(ejb, server, client, primaryKey, auth);
        this.executor = es;
    }

    protected void setEJBHomeProxy(EJBHomeProxy ejbHome) {
        this.ejbHome = ejbHome;
    }

    public static EJBObjectHandler createEJBObjectHandler(ThreadPoolExecutor executorService, EJBMetaDataImpl ejb, ServerMetaData server, ClientMetaData client, Object primaryKey, JNDIContext.AuthenticationInfo auth) {
        switch (ejb.type) {
            case 8: 
            case 9: {
                return new EntityEJBObjectHandler(executorService, ejb, server, client, primaryKey, auth);
            }
            case 6: {
                return new StatefulEJBObjectHandler(executorService, ejb, server, client, primaryKey, auth);
            }
            case 7: {
                return new StatelessEJBObjectHandler(executorService, ejb, server, client, primaryKey, auth);
            }
            case 10: {
                return new SingletonEJBObjectHandler(executorService, ejb, server, client, primaryKey, auth);
            }
        }
        throw new IllegalStateException("Uknown bean type code '" + ejb.type + "' : " + ejb.toString());
    }

    public abstract Object getRegistryId();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EJBObjectProxy createEJBObjectProxy() {
        EJBObjectProxy ejbObject = null;
        try {
            ArrayList<Class<EJBObjectProxy>> interfaces = new ArrayList<Class<EJBObjectProxy>>();
            if (this.ejb.remoteClass != null) {
                interfaces.add(this.ejb.remoteClass);
            } else if (this.ejb.businessClasses.size() > 0) {
                interfaces.addAll(this.ejb.businessClasses);
            }
            interfaces.add(EJBObjectProxy.class);
            ClassLoader oldCl = Thread.currentThread().getContextClassLoader();
            boolean parent = ClassLoaderUtil.isParent(this.getClass().getClassLoader(), oldCl);
            if (!parent) {
                Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
            }
            try {
                ejbObject = (EJBObjectProxy)ProxyManager.newProxyInstance(interfaces.toArray(new Class[interfaces.size()]), (InvocationHandler)this);
            }
            finally {
                if (!parent) {
                    Thread.currentThread().setContextClassLoader(oldCl);
                }
            }
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        return ejbObject;
    }

    @Override
    public Object _invoke(Object p, Method m, Object[] a) throws Throwable {
        try {
            if (m.getDeclaringClass().equals(Object.class)) {
                if (m.equals(TOSTRING)) {
                    return "proxy=" + this;
                }
                if (m.equals(EQUALS)) {
                    return this.equals(m, a, p);
                }
                if (m.equals(HASHCODE)) {
                    return this.hashCode();
                }
                throw new UnsupportedOperationException("Unknown method: " + m);
            }
            if (m.getDeclaringClass() == EJBObjectProxy.class) {
                if (m.equals(GETHANDLER)) {
                    return this;
                }
                if (m.getName().equals("writeReplace")) {
                    return new EJBObjectProxyHandle(this);
                }
                if (m.getName().equals("readResolve")) {
                    return null;
                }
                throw new UnsupportedOperationException("Unknown method: " + m);
            }
            if (m.getDeclaringClass() == EJBObject.class) {
                if (m.equals(GETHANDLE)) {
                    return this.getHandle(m, a, p);
                }
                if (m.equals(GETPRIMARYKEY)) {
                    return this.getPrimaryKey(m, a, p);
                }
                if (m.equals(ISIDENTICAL)) {
                    return this.isIdentical(m, a, p);
                }
                if (m.equals(GETEJBHOME)) {
                    return this.getEJBHome(m, a, p);
                }
                if (m.equals(REMOVE)) {
                    return this.remove(m, a, p);
                }
                throw new UnsupportedOperationException("Unknown method: " + m);
            }
            return this.businessMethod(m, a, p);
        }
        catch (SystemException e) {
            EJBObjectHandler.invalidateAllHandlers(this.getRegistryId());
            throw this.convertException(EJBObjectHandler.getCause(e), m);
        }
        catch (ApplicationException ae) {
            throw this.convertException(EJBObjectHandler.getCause(ae), m);
        }
        catch (SystemError se) {
            this.invalidateReference();
            if (this.remote) {
                throw new RemoteException("Container has suffered a SystemException", EJBObjectHandler.getCause(se));
            }
            throw new EJBException("Container has suffered a SystemException").initCause(EJBObjectHandler.getCause(se));
        }
        catch (Throwable throwable) {
            if (this.remote) {
                if (throwable instanceof RemoteException) {
                    throw throwable;
                }
                throw new RemoteException("Unknown Container Exception: " + throwable.getClass().getName() + ": " + throwable.getMessage(), EJBObjectHandler.getCause(throwable));
            }
            if (throwable instanceof EJBException) {
                throw throwable;
            }
            throw new EJBException("Unknown Container Exception: " + throwable.getClass().getName() + ": " + throwable.getMessage()).initCause(EJBObjectHandler.getCause(throwable));
        }
    }

    protected Object getEJBHome(Method method, Object[] args, Object proxy) throws Throwable {
        if (this.ejbHome == null) {
            this.ejbHome = EJBHomeHandler.createEJBHomeHandler(this.executor, this.ejb, this.server, this.client, this.authenticationInfo).createEJBHomeProxy();
        }
        return this.ejbHome;
    }

    protected Object getHandle(Method method, Object[] args, Object proxy) throws Throwable {
        return new EJBObjectHandle((EJBObjectProxy)proxy);
    }

    protected abstract Object getPrimaryKey(Method var1, Object[] var2, Object var3) throws Throwable;

    protected abstract Object isIdentical(Method var1, Object[] var2, Object var3) throws Throwable;

    protected abstract Object equals(Method var1, Object[] var2, Object var3) throws Throwable;

    protected abstract Object remove(Method var1, Object[] var2, Object var3) throws Throwable;

    protected Object businessMethod(Method method, Object[] args, Object proxy) throws Throwable {
        if (this.ejb.isAsynchronousMethod(method)) {
            try {
                String requestId = UUID.randomUUID().toString();
                EJBResponse response = new EJBResponse();
                AsynchronousCall asynchronousCall = new AsynchronousCall(method, args, proxy, requestId, response);
                if (this.executor == null) {
                    this.executor = JNDIContext.newExecutor(-1, null);
                }
                return new FutureAdapter(this.executor.submit(asynchronousCall), response, requestId);
            }
            catch (RejectedExecutionException e) {
                throw new EJBException("failed to allocate internal resource to execute the target task", (Exception)e);
            }
        }
        return this._businessMethod(method, args, proxy, null);
    }

    private Object _businessMethod(Method method, Object[] args, Object proxy, String requestId) throws Throwable {
        EJBRequest req = new EJBRequest(RequestMethodCode.EJB_OBJECT_BUSINESS_METHOD, this.ejb, method, args, this.primaryKey, this.client.getSerializer());
        EJBRequest.Body body = req.getBody();
        body.setRequestId(requestId);
        body.setAuthentication(this.authenticationInfo);
        EJBResponse res = this.request(req);
        return this._handleBusinessMethodResponse(res);
    }

    private Object _businessMethod(Method method, Object[] args, Object proxy, String requestId, EJBResponse response) throws Throwable {
        EJBRequest req = new EJBRequest(RequestMethodCode.EJB_OBJECT_BUSINESS_METHOD, this.ejb, method, args, this.primaryKey, this.client.getSerializer());
        req.getBody().setRequestId(requestId);
        EJBResponse res = this.request(req, response);
        return this._handleBusinessMethodResponse(res);
    }

    private Object _handleBusinessMethodResponse(EJBResponse res) throws Throwable {
        switch (res.getResponseCode()) {
            case 11: {
                throw new SystemError((ThrowableArtifact)this.getResult(res));
            }
            case 10: {
                throw new SystemException((ThrowableArtifact)this.getResult(res));
            }
            case 9: {
                throw new ApplicationException((ThrowableArtifact)this.getResult(res));
            }
            case 4: {
                return this.getResult(res);
            }
            case 3: {
                Object result = res.getResult();
                if (!ThrowableArtifact.class.isInstance(result)) break;
                throw ((ThrowableArtifact)ThrowableArtifact.class.cast(result)).getThrowable();
            }
        }
        throw new RemoteException("Received invalid response code from server: " + res.getResponseCode());
    }

    private Object getResult(EJBResponse res) throws ClassNotFoundException {
        Object result = res.getResult();
        if (this.client.getSerializer() != null && SerializationWrapper.class.isInstance(result)) {
            SerializationWrapper wrapper = (SerializationWrapper)SerializationWrapper.class.cast(result);
            return this.client.getSerializer().deserialize(wrapper.getData(), Thread.currentThread().getContextClassLoader().loadClass(wrapper.getClassname()));
        }
        return res.getResult();
    }

    private class FutureAdapter<T>
    implements Future<T> {
        private Future<T> target;
        private String requestId;
        private EJBResponse response;
        private volatile boolean canceled;
        private AtomicBoolean lastMayInterruptIfRunningValue = new AtomicBoolean(false);

        public FutureAdapter(Future<T> target, EJBResponse response, String requestId) {
            this.target = target;
            this.requestId = requestId;
            this.response = response;
        }

        @Override
        public boolean cancel(boolean mayInterruptIfRunning) {
            if (this.canceled) {
                return true;
            }
            if (EJBObjectHandler.this.executor.getQueue().remove(this.target)) {
                this.canceled = true;
                return true;
            }
            if (!this.target.isDone()) {
                if (this.lastMayInterruptIfRunningValue.getAndSet(mayInterruptIfRunning) == mayInterruptIfRunning) {
                    return false;
                }
                EJBRequest req = new EJBRequest(RequestMethodCode.FUTURE_CANCEL, EJBObjectHandler.this.ejb, CANCEL, new Object[]{mayInterruptIfRunning}, EJBObjectHandler.this.primaryKey, EJBObjectHandler.this.client.getSerializer());
                req.getBody().setRequestId(this.requestId);
                try {
                    EJBResponse res = EJBObjectHandler.this.request(req);
                    if (res.getResponseCode() != 4) {
                        Logger.getLogger(this.getClass().getName()).info("Unexpected response on cancel: " + res);
                    }
                }
                catch (Exception e) {
                    Logger.getLogger(this.getClass().getName()).log(Level.INFO, "Unexpected error on cancel", e);
                    return false;
                }
            }
            return false;
        }

        @Override
        public T get() throws InterruptedException, ExecutionException {
            if (this.canceled) {
                throw new CancellationException();
            }
            return this.target.get();
        }

        @Override
        public T get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
            if (this.canceled) {
                throw new CancellationException();
            }
            return this.target.get(timeout, unit);
        }

        @Override
        public boolean isCancelled() {
            return this.canceled;
        }

        @Override
        public boolean isDone() {
            if (this.canceled) {
                return false;
            }
            return this.target.isDone();
        }
    }

    private class AsynchronousCall
    implements Callable {
        private Method method;
        private Object[] args;
        private Object proxy;
        private String requestId;
        private EJBResponse response;

        public AsynchronousCall(Method method, Object[] args, Object proxy, String requestId, EJBResponse response) {
            this.method = method;
            this.args = args;
            this.proxy = proxy;
            this.requestId = requestId;
            this.response = response;
        }

        public Object call() throws Exception {
            try {
                return EJBObjectHandler.this._businessMethod(this.method, this.args, this.proxy, this.requestId, this.response);
            }
            catch (Exception e) {
                throw e;
            }
            catch (Throwable error) {
                throw new SystemException(error);
            }
        }
    }
}

