/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.rest;

import jakarta.ws.rs.core.MultivaluedMap;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;

public class MultivaluedMapWithCaseInsensitiveKeySet<V>
implements MultivaluedMap<String, V> {
    private final MultivaluedMap<String, V> delegate;

    public MultivaluedMapWithCaseInsensitiveKeySet(MultivaluedMap<String, V> map) {
        this.delegate = map;
    }

    public void add(String key, V value) {
        this.delegate.add((Object)key, value);
    }

    public V getFirst(String key) {
        return (V)this.delegate.getFirst((Object)this.realKey(key));
    }

    public void addAll(String key, V ... newValues) {
        this.delegate.addAll((Object)key, (Object[])newValues);
    }

    public void addAll(String key, List<V> valueList) {
        this.delegate.addAll((Object)key, valueList);
    }

    public void addFirst(String key, V value) {
        this.delegate.addFirst((Object)key, value);
    }

    public boolean equalsIgnoreValueOrder(MultivaluedMap<String, V> otherMap) {
        return this.delegate.equalsIgnoreValueOrder(otherMap);
    }

    public void putSingle(String key, V value) {
        this.delegate.putSingle((Object)key, value);
    }

    public int size() {
        return this.delegate.size();
    }

    public boolean isEmpty() {
        return this.delegate.isEmpty();
    }

    public boolean containsKey(Object key) {
        return MultivaluedMapWithCaseInsensitiveKeySet.getInsensitiveKeySet(this.delegate.keySet()).contains(key.toString());
    }

    public boolean containsValue(Object value) {
        return this.delegate.containsValue(value);
    }

    public List<V> get(Object key) {
        return (List)this.delegate.get((Object)this.realKey(key));
    }

    public List<V> put(String key, List<V> value) {
        return (List)this.delegate.put((Object)key, value);
    }

    public List<V> remove(Object key) {
        return (List)this.delegate.remove((Object)this.realKey(key));
    }

    public void putAll(Map<? extends String, ? extends List<V>> m) {
        this.delegate.putAll(m);
    }

    public void clear() {
        this.delegate.clear();
    }

    public Set<String> keySet() {
        return MultivaluedMapWithCaseInsensitiveKeySet.getInsensitiveKeySet(this.delegate.keySet());
    }

    public Collection<List<V>> values() {
        return this.delegate.values();
    }

    public Set<Map.Entry<String, List<V>>> entrySet() {
        return this.delegate.entrySet();
    }

    private static Set<String> getInsensitiveKeySet(Set<String> values) {
        TreeSet<String> set = new TreeSet<String>(String.CASE_INSENSITIVE_ORDER);
        set.addAll(values);
        return set;
    }

    private static Object lowerCase(Object key) {
        if (key instanceof String) {
            return ((String)key).toLowerCase();
        }
        return key;
    }

    private String realKey(Object key) {
        for (Map.Entry entry : this.delegate.entrySet()) {
            if (!((String)entry.getKey()).toLowerCase().equals(MultivaluedMapWithCaseInsensitiveKeySet.lowerCase(key))) continue;
            return (String)entry.getKey();
        }
        return null;
    }
}

